/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.utils.HashCodeHelpers;
import java.util.concurrent.Executor;

public abstract class CameraExtensionSession
implements AutoCloseable {
    @NonNull
    public CameraDevice getDevice() {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    public int capture(@NonNull CaptureRequest request, @NonNull Executor executor, @NonNull ExtensionCaptureCallback listener) throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    public int setRepeatingRequest(@NonNull CaptureRequest request, @NonNull Executor executor, @NonNull ExtensionCaptureCallback listener) throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    public void stopRepeating() throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    @Nullable
    public StillCaptureLatency getRealtimeStillCaptureLatency() throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    @Override
    public void close() throws CameraAccessException {
        throw new UnsupportedOperationException("Subclasses must override this method");
    }

    public static class StillCaptureLatency {
        private final long mCaptureLatency;
        private final long mProcessingLatency;

        public StillCaptureLatency(long captureLatency, long processingLatency) {
            this.mCaptureLatency = captureLatency;
            this.mProcessingLatency = processingLatency;
        }

        public long getCaptureLatency() {
            return this.mCaptureLatency;
        }

        public long getProcessingLatency() {
            return this.mProcessingLatency;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StillCaptureLatency latency = (StillCaptureLatency)o;
            if (this.mCaptureLatency != latency.mCaptureLatency) {
                return false;
            }
            return this.mProcessingLatency == latency.mProcessingLatency;
        }

        public int hashCode() {
            return HashCodeHelpers.hashCode(this.mCaptureLatency, this.mProcessingLatency);
        }

        public String toString() {
            return "StillCaptureLatency(processingLatency:" + this.mProcessingLatency + ", captureLatency: " + this.mCaptureLatency + ")";
        }
    }

    public static abstract class StateCallback {
        public abstract void onConfigured(@NonNull CameraExtensionSession var1);

        public abstract void onConfigureFailed(@NonNull CameraExtensionSession var1);

        public void onClosed(@NonNull CameraExtensionSession session) {
        }
    }

    public static abstract class ExtensionCaptureCallback {
        public void onCaptureStarted(@NonNull CameraExtensionSession session, @NonNull CaptureRequest request, long timestamp) {
        }

        public void onCaptureProcessStarted(@NonNull CameraExtensionSession session, @NonNull CaptureRequest request) {
        }

        public void onCaptureFailed(@NonNull CameraExtensionSession session, @NonNull CaptureRequest request) {
        }

        public void onCaptureFailed(@NonNull CameraExtensionSession session, @NonNull CaptureRequest request, int failure) {
        }

        public void onCaptureSequenceCompleted(@NonNull CameraExtensionSession session, int sequenceId) {
        }

        public void onCaptureSequenceAborted(@NonNull CameraExtensionSession session, int sequenceId) {
        }

        public void onCaptureResultAvailable(@NonNull CameraExtensionSession session, @NonNull CaptureRequest request, @NonNull TotalCaptureResult result) {
        }

        public void onCaptureProcessProgressed(@NonNull CameraExtensionSession session, @NonNull CaptureRequest request, int progress) {
        }
    }
}

