/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics.fingerprint;

import android.hardware.biometrics.common.ICancellationSignal;
import android.hardware.biometrics.common.OperationContext;
import android.hardware.biometrics.fingerprint.PointerContext;
import android.hardware.keymaster.HardwareAuthToken;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ISession
extends IInterface {
    public static final int VERSION = 4;
    public static final String HASH = "41a730a7a6b5aa9cebebce70ee5b5e509b0af6fb";
    public static final String DESCRIPTOR = "android$hardware$biometrics$fingerprint$ISession".replace('$', '.');

    public void generateChallenge() throws RemoteException;

    public void revokeChallenge(long var1) throws RemoteException;

    public ICancellationSignal enroll(HardwareAuthToken var1) throws RemoteException;

    public ICancellationSignal authenticate(long var1) throws RemoteException;

    public ICancellationSignal detectInteraction() throws RemoteException;

    public void enumerateEnrollments() throws RemoteException;

    public void removeEnrollments(int[] var1) throws RemoteException;

    public void getAuthenticatorId() throws RemoteException;

    public void invalidateAuthenticatorId() throws RemoteException;

    public void resetLockout(HardwareAuthToken var1) throws RemoteException;

    public void close() throws RemoteException;

    @Deprecated
    public void onPointerDown(int var1, int var2, int var3, float var4, float var5) throws RemoteException;

    @Deprecated
    public void onPointerUp(int var1) throws RemoteException;

    public void onUiReady() throws RemoteException;

    public ICancellationSignal authenticateWithContext(long var1, OperationContext var3) throws RemoteException;

    public ICancellationSignal enrollWithContext(HardwareAuthToken var1, OperationContext var2) throws RemoteException;

    public ICancellationSignal detectInteractionWithContext(OperationContext var1) throws RemoteException;

    public void onPointerDownWithContext(PointerContext var1) throws RemoteException;

    public void onPointerUpWithContext(PointerContext var1) throws RemoteException;

    public void onContextChanged(OperationContext var1) throws RemoteException;

    public void onPointerCancelWithContext(PointerContext var1) throws RemoteException;

    @Deprecated
    public void setIgnoreDisplayTouches(boolean var1) throws RemoteException;

    public int getInterfaceVersion() throws RemoteException;

    public String getInterfaceHash() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISession {
        static final int TRANSACTION_generateChallenge = 1;
        static final int TRANSACTION_revokeChallenge = 2;
        static final int TRANSACTION_enroll = 3;
        static final int TRANSACTION_authenticate = 4;
        static final int TRANSACTION_detectInteraction = 5;
        static final int TRANSACTION_enumerateEnrollments = 6;
        static final int TRANSACTION_removeEnrollments = 7;
        static final int TRANSACTION_getAuthenticatorId = 8;
        static final int TRANSACTION_invalidateAuthenticatorId = 9;
        static final int TRANSACTION_resetLockout = 10;
        static final int TRANSACTION_close = 11;
        static final int TRANSACTION_onPointerDown = 12;
        static final int TRANSACTION_onPointerUp = 13;
        static final int TRANSACTION_onUiReady = 14;
        static final int TRANSACTION_authenticateWithContext = 15;
        static final int TRANSACTION_enrollWithContext = 16;
        static final int TRANSACTION_detectInteractionWithContext = 17;
        static final int TRANSACTION_onPointerDownWithContext = 18;
        static final int TRANSACTION_onPointerUpWithContext = 19;
        static final int TRANSACTION_onContextChanged = 20;
        static final int TRANSACTION_onPointerCancelWithContext = 21;
        static final int TRANSACTION_setIgnoreDisplayTouches = 22;
        static final int TRANSACTION_getInterfaceVersion = 0xFFFFFF;
        static final int TRANSACTION_getInterfaceHash = 0xFFFFFE;

        public Stub() {
            this.markVintfStability();
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISession asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISession) {
                return (ISession)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "generateChallenge";
                }
                case 2: {
                    return "revokeChallenge";
                }
                case 3: {
                    return "enroll";
                }
                case 4: {
                    return "authenticate";
                }
                case 5: {
                    return "detectInteraction";
                }
                case 6: {
                    return "enumerateEnrollments";
                }
                case 7: {
                    return "removeEnrollments";
                }
                case 8: {
                    return "getAuthenticatorId";
                }
                case 9: {
                    return "invalidateAuthenticatorId";
                }
                case 10: {
                    return "resetLockout";
                }
                case 11: {
                    return "close";
                }
                case 12: {
                    return "onPointerDown";
                }
                case 13: {
                    return "onPointerUp";
                }
                case 14: {
                    return "onUiReady";
                }
                case 15: {
                    return "authenticateWithContext";
                }
                case 16: {
                    return "enrollWithContext";
                }
                case 17: {
                    return "detectInteractionWithContext";
                }
                case 18: {
                    return "onPointerDownWithContext";
                }
                case 19: {
                    return "onPointerUpWithContext";
                }
                case 20: {
                    return "onContextChanged";
                }
                case 21: {
                    return "onPointerCancelWithContext";
                }
                case 22: {
                    return "setIgnoreDisplayTouches";
                }
                case 0xFFFFFF: {
                    return "getInterfaceVersion";
                }
                case 0xFFFFFE: {
                    return "getInterfaceHash";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            if (code == 0xFFFFFF) {
                reply.writeNoException();
                reply.writeInt(this.getInterfaceVersion());
                return true;
            }
            if (code == 0xFFFFFE) {
                reply.writeNoException();
                reply.writeString(this.getInterfaceHash());
                return true;
            }
            switch (code) {
                case 1: {
                    this.generateChallenge();
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    this.revokeChallenge(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    HardwareAuthToken _arg0 = data.readTypedObject(HardwareAuthToken.CREATOR);
                    data.enforceNoDataAvail();
                    ICancellationSignal _result = this.enroll(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 4: {
                    long _arg0 = data.readLong();
                    data.enforceNoDataAvail();
                    ICancellationSignal _result = this.authenticate(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 5: {
                    ICancellationSignal _result = this.detectInteraction();
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 6: {
                    this.enumerateEnrollments();
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    int[] _arg0 = data.createIntArray();
                    data.enforceNoDataAvail();
                    this.removeEnrollments(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    this.getAuthenticatorId();
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    this.invalidateAuthenticatorId();
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    HardwareAuthToken _arg0 = data.readTypedObject(HardwareAuthToken.CREATOR);
                    data.enforceNoDataAvail();
                    this.resetLockout(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    this.close();
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    float _arg3 = data.readFloat();
                    float _arg4 = data.readFloat();
                    data.enforceNoDataAvail();
                    this.onPointerDown(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onPointerUp(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    this.onUiReady();
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    long _arg0 = data.readLong();
                    OperationContext _arg1 = data.readTypedObject(OperationContext.CREATOR);
                    data.enforceNoDataAvail();
                    ICancellationSignal _result = this.authenticateWithContext(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 16: {
                    HardwareAuthToken _arg0 = data.readTypedObject(HardwareAuthToken.CREATOR);
                    OperationContext _arg1 = data.readTypedObject(OperationContext.CREATOR);
                    data.enforceNoDataAvail();
                    ICancellationSignal _result = this.enrollWithContext(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 17: {
                    OperationContext _arg0 = data.readTypedObject(OperationContext.CREATOR);
                    data.enforceNoDataAvail();
                    ICancellationSignal _result = this.detectInteractionWithContext(_arg0);
                    reply.writeNoException();
                    reply.writeStrongInterface(_result);
                    break;
                }
                case 18: {
                    PointerContext _arg0 = data.readTypedObject(PointerContext.CREATOR);
                    data.enforceNoDataAvail();
                    this.onPointerDownWithContext(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    PointerContext _arg0 = data.readTypedObject(PointerContext.CREATOR);
                    data.enforceNoDataAvail();
                    this.onPointerUpWithContext(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    OperationContext _arg0 = data.readTypedObject(OperationContext.CREATOR);
                    data.enforceNoDataAvail();
                    this.onContextChanged(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    PointerContext _arg0 = data.readTypedObject(PointerContext.CREATOR);
                    data.enforceNoDataAvail();
                    this.onPointerCancelWithContext(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setIgnoreDisplayTouches(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0xFFFFFE;
        }

        private static class Proxy
        implements ISession {
            private IBinder mRemote;
            private int mCachedVersion = -1;
            private String mCachedHash = "-1";

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void generateChallenge() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method generateChallenge is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void revokeChallenge(long challenge) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeLong(challenge);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method revokeChallenge is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal enroll(HardwareAuthToken hat) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(hat, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method enroll is unimplemented.");
                    }
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal authenticate(long operationId) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeLong(operationId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method authenticate is unimplemented.");
                    }
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal detectInteraction() throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method detectInteraction is unimplemented.");
                    }
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enumerateEnrollments() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method enumerateEnrollments is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeEnrollments(int[] enrollmentIds) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeIntArray(enrollmentIds);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method removeEnrollments is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getAuthenticatorId() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method getAuthenticatorId is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invalidateAuthenticatorId() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method invalidateAuthenticatorId is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetLockout(HardwareAuthToken hat) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(hat, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method resetLockout is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method close is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPointerDown(int pointerId, int x, int y, float minor, float major) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(pointerId);
                    _data.writeInt(x);
                    _data.writeInt(y);
                    _data.writeFloat(minor);
                    _data.writeFloat(major);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onPointerDown is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPointerUp(int pointerId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeInt(pointerId);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onPointerUp is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onUiReady() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onUiReady is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal authenticateWithContext(long operationId, OperationContext context) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeLong(operationId);
                    _data.writeTypedObject(context, 0);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method authenticateWithContext is unimplemented.");
                    }
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal enrollWithContext(HardwareAuthToken hat, OperationContext context) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(hat, 0);
                    _data.writeTypedObject(context, 0);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method enrollWithContext is unimplemented.");
                    }
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICancellationSignal detectInteractionWithContext(OperationContext context) throws RemoteException {
                ICancellationSignal _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(context, 0);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method detectInteractionWithContext is unimplemented.");
                    }
                    _reply.readException();
                    _result = ICancellationSignal.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPointerDownWithContext(PointerContext context) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(context, 0);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onPointerDownWithContext is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPointerUpWithContext(PointerContext context) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(context, 0);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onPointerUpWithContext is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onContextChanged(OperationContext context) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(context, 0);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onContextChanged is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPointerCancelWithContext(PointerContext context) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeTypedObject(context, 0);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method onPointerCancelWithContext is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setIgnoreDisplayTouches(boolean shouldIgnore) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeBoolean(shouldIgnore);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    if (!_status) {
                        throw new RemoteException("Method setIgnoreDisplayTouches is unimplemented.");
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getInterfaceVersion() throws RemoteException {
                if (this.mCachedVersion == -1) {
                    Parcel data = Parcel.obtain(this.asBinder());
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFF, data, reply, 0);
                        reply.readException();
                        this.mCachedVersion = reply.readInt();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedVersion;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public synchronized String getInterfaceHash() throws RemoteException {
                if ("-1".equals(this.mCachedHash)) {
                    Parcel data = Parcel.obtain(this.asBinder());
                    Parcel reply = Parcel.obtain();
                    try {
                        data.writeInterfaceToken(DESCRIPTOR);
                        boolean _status = this.mRemote.transact(0xFFFFFE, data, reply, 0);
                        reply.readException();
                        this.mCachedHash = reply.readString();
                    }
                    finally {
                        reply.recycle();
                        data.recycle();
                    }
                }
                return this.mCachedHash;
            }
        }
    }

    public static class Default
    implements ISession {
        @Override
        public void generateChallenge() throws RemoteException {
        }

        @Override
        public void revokeChallenge(long challenge) throws RemoteException {
        }

        @Override
        public ICancellationSignal enroll(HardwareAuthToken hat) throws RemoteException {
            return null;
        }

        @Override
        public ICancellationSignal authenticate(long operationId) throws RemoteException {
            return null;
        }

        @Override
        public ICancellationSignal detectInteraction() throws RemoteException {
            return null;
        }

        @Override
        public void enumerateEnrollments() throws RemoteException {
        }

        @Override
        public void removeEnrollments(int[] enrollmentIds) throws RemoteException {
        }

        @Override
        public void getAuthenticatorId() throws RemoteException {
        }

        @Override
        public void invalidateAuthenticatorId() throws RemoteException {
        }

        @Override
        public void resetLockout(HardwareAuthToken hat) throws RemoteException {
        }

        @Override
        public void close() throws RemoteException {
        }

        @Override
        public void onPointerDown(int pointerId, int x, int y, float minor, float major) throws RemoteException {
        }

        @Override
        public void onPointerUp(int pointerId) throws RemoteException {
        }

        @Override
        public void onUiReady() throws RemoteException {
        }

        @Override
        public ICancellationSignal authenticateWithContext(long operationId, OperationContext context) throws RemoteException {
            return null;
        }

        @Override
        public ICancellationSignal enrollWithContext(HardwareAuthToken hat, OperationContext context) throws RemoteException {
            return null;
        }

        @Override
        public ICancellationSignal detectInteractionWithContext(OperationContext context) throws RemoteException {
            return null;
        }

        @Override
        public void onPointerDownWithContext(PointerContext context) throws RemoteException {
        }

        @Override
        public void onPointerUpWithContext(PointerContext context) throws RemoteException {
        }

        @Override
        public void onContextChanged(OperationContext context) throws RemoteException {
        }

        @Override
        public void onPointerCancelWithContext(PointerContext context) throws RemoteException {
        }

        @Override
        public void setIgnoreDisplayTouches(boolean shouldIgnore) throws RemoteException {
        }

        @Override
        public int getInterfaceVersion() {
            return 0;
        }

        @Override
        public String getInterfaceHash() {
            return "";
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

