/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.biometrics;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.security.identity.IdentityCredential;
import android.security.identity.PresentationSession;
import android.security.keystore2.AndroidKeyStoreProvider;
import java.security.Signature;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;

public class CryptoObject {
    private final Object mCrypto;

    public CryptoObject(@NonNull Signature signature) {
        this.mCrypto = signature;
    }

    public CryptoObject(@NonNull Cipher cipher) {
        this.mCrypto = cipher;
    }

    public CryptoObject(@NonNull Mac mac) {
        this.mCrypto = mac;
    }

    @Deprecated
    public CryptoObject(@NonNull IdentityCredential credential) {
        this.mCrypto = credential;
    }

    public CryptoObject(@NonNull PresentationSession session) {
        this.mCrypto = session;
    }

    @FlaggedApi(value="android.hardware.biometrics.add_key_agreement_crypto_object")
    public CryptoObject(@NonNull KeyAgreement keyAgreement) {
        this.mCrypto = keyAgreement;
    }

    public CryptoObject(long operationHandle) {
        this.mCrypto = operationHandle;
    }

    @Nullable
    public Signature getSignature() {
        return this.mCrypto instanceof Signature ? (Signature)this.mCrypto : null;
    }

    @Nullable
    public Cipher getCipher() {
        return this.mCrypto instanceof Cipher ? (Cipher)this.mCrypto : null;
    }

    @Nullable
    public Mac getMac() {
        return this.mCrypto instanceof Mac ? (Mac)this.mCrypto : null;
    }

    @Deprecated
    @Nullable
    public IdentityCredential getIdentityCredential() {
        return this.mCrypto instanceof IdentityCredential ? (IdentityCredential)this.mCrypto : null;
    }

    @Nullable
    public PresentationSession getPresentationSession() {
        return this.mCrypto instanceof PresentationSession ? (PresentationSession)this.mCrypto : null;
    }

    @FlaggedApi(value="android.hardware.biometrics.add_key_agreement_crypto_object")
    @Nullable
    public KeyAgreement getKeyAgreement() {
        return this.mCrypto instanceof KeyAgreement ? (KeyAgreement)this.mCrypto : null;
    }

    public long getOpId() {
        if (this.mCrypto == null) {
            return 0L;
        }
        if (this.mCrypto instanceof Long) {
            return (Long)this.mCrypto;
        }
        if (this.mCrypto instanceof IdentityCredential) {
            return ((IdentityCredential)this.mCrypto).getCredstoreOperationHandle();
        }
        if (this.mCrypto instanceof PresentationSession) {
            return ((PresentationSession)this.mCrypto).getCredstoreOperationHandle();
        }
        return AndroidKeyStoreProvider.getKeyStoreOperationHandle(this.mCrypto);
    }
}

