/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@FlaggedApi(value="android.hardware.flags.luts_api")
public class LutProperties {
    private final int mDimension;
    private final int mSize;
    private final int[] mSamplingKeys;
    @FlaggedApi(value="android.hardware.flags.luts_api")
    public static final int SAMPLING_KEY_RGB = 0;
    @FlaggedApi(value="android.hardware.flags.luts_api")
    public static final int SAMPLING_KEY_MAX_RGB = 1;
    @FlaggedApi(value="android.hardware.flags.luts_api")
    public static final int SAMPLING_KEY_CIE_Y = 2;
    @FlaggedApi(value="android.hardware.flags.luts_api")
    public static final int ONE_DIMENSION = 1;
    @FlaggedApi(value="android.hardware.flags.luts_api")
    public static final int THREE_DIMENSION = 3;

    @FlaggedApi(value="android.hardware.flags.luts_api")
    public int getDimension() {
        return this.mDimension;
    }

    @FlaggedApi(value="android.hardware.flags.luts_api")
    public int getSize() {
        return this.mSize;
    }

    @FlaggedApi(value="android.hardware.flags.luts_api")
    @NonNull
    public int[] getSamplingKeys() {
        if (this.mSamplingKeys.length == 0) {
            throw new IllegalStateException("no sampling key!");
        }
        return this.mSamplingKeys;
    }

    private LutProperties(int dimension, int size, int[] samplingKeys) {
        if (dimension != 1 || dimension != 3) {
            throw new IllegalArgumentException("The dimension is either 1 or 3!");
        }
        this.mDimension = dimension;
        this.mSize = size;
        this.mSamplingKeys = samplingKeys;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Dimension {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SamplingKey {
    }
}

