/*
 * Decompiled with CFR 0.152.
 */
package android.hardware;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ICameraServiceListener
extends IInterface {
    public static final int STATUS_NOT_PRESENT = 0;
    public static final int STATUS_PRESENT = 1;
    public static final int STATUS_ENUMERATING = 2;
    public static final int STATUS_NOT_AVAILABLE = -2;
    public static final int STATUS_UNKNOWN = -1;
    public static final int TORCH_STATUS_NOT_AVAILABLE = 0;
    public static final int TORCH_STATUS_AVAILABLE_OFF = 1;
    public static final int TORCH_STATUS_AVAILABLE_ON = 2;
    public static final int TORCH_STATUS_UNKNOWN = -1;

    public void onStatusChanged(int var1, String var2, int var3) throws RemoteException;

    public void onPhysicalCameraStatusChanged(int var1, String var2, String var3, int var4) throws RemoteException;

    public void onTorchStatusChanged(int var1, String var2, int var3) throws RemoteException;

    public void onTorchStrengthLevelChanged(String var1, int var2, int var3) throws RemoteException;

    public void onCameraAccessPrioritiesChanged() throws RemoteException;

    public void onCameraOpened(String var1, String var2, int var3) throws RemoteException;

    public void onCameraOpenedInSharedMode(String var1, String var2, int var3, boolean var4) throws RemoteException;

    public void onCameraClosed(String var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICameraServiceListener {
        public static final String DESCRIPTOR = "android.hardware.ICameraServiceListener";
        static final int TRANSACTION_onStatusChanged = 1;
        static final int TRANSACTION_onPhysicalCameraStatusChanged = 2;
        static final int TRANSACTION_onTorchStatusChanged = 3;
        static final int TRANSACTION_onTorchStrengthLevelChanged = 4;
        static final int TRANSACTION_onCameraAccessPrioritiesChanged = 5;
        static final int TRANSACTION_onCameraOpened = 6;
        static final int TRANSACTION_onCameraOpenedInSharedMode = 7;
        static final int TRANSACTION_onCameraClosed = 8;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ICameraServiceListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ICameraServiceListener) {
                return (ICameraServiceListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onStatusChanged";
                }
                case 2: {
                    return "onPhysicalCameraStatusChanged";
                }
                case 3: {
                    return "onTorchStatusChanged";
                }
                case 4: {
                    return "onTorchStrengthLevelChanged";
                }
                case 5: {
                    return "onCameraAccessPrioritiesChanged";
                }
                case 6: {
                    return "onCameraOpened";
                }
                case 7: {
                    return "onCameraOpenedInSharedMode";
                }
                case 8: {
                    return "onCameraClosed";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onStatusChanged(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onPhysicalCameraStatusChanged(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTorchStatusChanged(_arg0, _arg1, _arg2);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onTorchStrengthLevelChanged(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    this.onCameraAccessPrioritiesChanged();
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCameraOpened(_arg0, _arg1, _arg2);
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    boolean _arg3 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onCameraOpenedInSharedMode(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 8: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onCameraClosed(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 7;
        }

        private static class Proxy
        implements ICameraServiceListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStatusChanged(int status, String cameraId, int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(status);
                    _data.writeString(cameraId);
                    _data.writeInt(deviceId);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPhysicalCameraStatusChanged(int status, String cameraId, String physicalCameraId, int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(status);
                    _data.writeString(cameraId);
                    _data.writeString(physicalCameraId);
                    _data.writeInt(deviceId);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTorchStatusChanged(int status, String cameraId, int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(status);
                    _data.writeString(cameraId);
                    _data.writeInt(deviceId);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTorchStrengthLevelChanged(String cameraId, int newTorchStrength, int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(cameraId);
                    _data.writeInt(newTorchStrength);
                    _data.writeInt(deviceId);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onCameraAccessPrioritiesChanged() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCameraOpened(String cameraId, String clientPackageId, int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(cameraId);
                    _data.writeString(clientPackageId);
                    _data.writeInt(deviceId);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCameraOpenedInSharedMode(String cameraId, String clientPackageId, int deviceId, boolean primaryClient) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(cameraId);
                    _data.writeString(clientPackageId);
                    _data.writeInt(deviceId);
                    _data.writeBoolean(primaryClient);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCameraClosed(String cameraId, int deviceId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(cameraId);
                    _data.writeInt(deviceId);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICameraServiceListener {
        @Override
        public void onStatusChanged(int status, String cameraId, int deviceId) throws RemoteException {
        }

        @Override
        public void onPhysicalCameraStatusChanged(int status, String cameraId, String physicalCameraId, int deviceId) throws RemoteException {
        }

        @Override
        public void onTorchStatusChanged(int status, String cameraId, int deviceId) throws RemoteException {
        }

        @Override
        public void onTorchStrengthLevelChanged(String cameraId, int newTorchStrength, int deviceId) throws RemoteException {
        }

        @Override
        public void onCameraAccessPrioritiesChanged() throws RemoteException {
        }

        @Override
        public void onCameraOpened(String cameraId, String clientPackageId, int deviceId) throws RemoteException {
        }

        @Override
        public void onCameraOpenedInSharedMode(String cameraId, String clientPackageId, int deviceId, boolean primaryClient) throws RemoteException {
        }

        @Override
        public void onCameraClosed(String cameraId, int deviceId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

