/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.graphics.ColorSpace;
import android.graphics.Rect;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import java.io.OutputStream;

@RavenwoodKeepWholeClass
public class YuvImage {
    private static final int WORKING_COMPRESS_STORAGE = 4096;
    private int mFormat;
    private byte[] mData;
    private int[] mStrides;
    private int mWidth;
    private int mHeight;
    @NonNull
    private ColorSpace mColorSpace;
    private static final String[] sSupportedFormats = new String[]{"NV21", "YUY2", "YCBCR_P010", "YUV_420_888"};
    private static final ColorSpace.Named[] sSupportedJpegRHdrColorSpaces = new ColorSpace.Named[]{ColorSpace.Named.BT2020_HLG, ColorSpace.Named.BT2020_PQ};
    private static final ColorSpace.Named[] sSupportedJpegRSdrColorSpaces = new ColorSpace.Named[]{ColorSpace.Named.SRGB, ColorSpace.Named.DISPLAY_P3};

    private static String printSupportedFormats() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sSupportedFormats.length; ++i) {
            sb.append(sSupportedFormats[i]);
            if (i == sSupportedFormats.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private static String printSupportedJpegRColorSpaces(boolean isHdr) {
        ColorSpace.Named[] colorSpaces = isHdr ? sSupportedJpegRHdrColorSpaces : sSupportedJpegRSdrColorSpaces;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < colorSpaces.length; ++i) {
            sb.append(ColorSpace.get(colorSpaces[i]).getName());
            if (i == colorSpaces.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private static boolean isSupportedJpegRColorSpace(boolean isHdr, int colorSpace) {
        ColorSpace.Named[] colorSpaces;
        for (ColorSpace.Named cs : colorSpaces = isHdr ? sSupportedJpegRHdrColorSpaces : sSupportedJpegRSdrColorSpaces) {
            if (cs.ordinal() != colorSpace) continue;
            return true;
        }
        return false;
    }

    public YuvImage(byte[] yuv, int format, int width, int height, int[] strides) {
        this(yuv, format, width, height, strides, ColorSpace.get(ColorSpace.Named.SRGB));
    }

    public YuvImage(@NonNull byte[] yuv, int format, int width, int height, @Nullable int[] strides, @NonNull ColorSpace colorSpace) {
        if (format != 17 && format != 20 && format != 54 && format != 35) {
            throw new IllegalArgumentException("only supports the following ImageFormat:" + YuvImage.printSupportedFormats());
        }
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width and height must large than 0");
        }
        if (yuv == null) {
            throw new IllegalArgumentException("yuv cannot be null");
        }
        if (colorSpace == null) {
            throw new IllegalArgumentException("ColorSpace cannot be null");
        }
        this.mStrides = strides == null ? this.calculateStrides(width, format) : strides;
        this.mData = yuv;
        this.mFormat = format;
        this.mWidth = width;
        this.mHeight = height;
        this.mColorSpace = colorSpace;
    }

    public boolean compressToJpeg(Rect rectangle, int quality, OutputStream stream) {
        if (this.mFormat != 17 && this.mFormat != 20) {
            throw new IllegalArgumentException("Only ImageFormat.NV21 and ImageFormat.YUY2 are supported.");
        }
        if (this.mColorSpace.getId() != ColorSpace.Named.SRGB.ordinal()) {
            throw new IllegalArgumentException("Only SRGB color space is supported.");
        }
        Rect wholeImage = new Rect(0, 0, this.mWidth, this.mHeight);
        if (!wholeImage.contains(rectangle)) {
            throw new IllegalArgumentException("rectangle is not inside the image");
        }
        if (quality < 0 || quality > 100) {
            throw new IllegalArgumentException("quality must be 0..100");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream cannot be null");
        }
        this.adjustRectangle(rectangle);
        int[] offsets = this.calculateOffsets(rectangle.left, rectangle.top);
        return YuvImage.nativeCompressToJpeg(this.mData, this.mFormat, rectangle.width(), rectangle.height(), offsets, this.mStrides, quality, stream, new byte[4096]);
    }

    public boolean compressToJpegR(@NonNull YuvImage sdr, int quality, @NonNull OutputStream stream) {
        byte[] emptyExif = new byte[]{};
        return this.compressToJpegR(sdr, quality, stream, emptyExif);
    }

    @FlaggedApi(value="com.android.graphics.flags.yuv_image_compress_to_ultra_hdr")
    public boolean compressToJpegR(@NonNull YuvImage sdr, int quality, @NonNull OutputStream stream, @NonNull byte[] exif) {
        if (sdr == null) {
            throw new IllegalArgumentException("SDR input cannot be null");
        }
        if (this.mData.length == 0 || sdr.getYuvData().length == 0) {
            throw new IllegalArgumentException("Input images cannot be empty");
        }
        if (this.mFormat != 54 || sdr.getYuvFormat() != 35) {
            throw new IllegalArgumentException("only support ImageFormat.YCBCR_P010 and ImageFormat.YUV_420_888");
        }
        if (sdr.getWidth() != this.mWidth || sdr.getHeight() != this.mHeight) {
            throw new IllegalArgumentException("HDR and SDR resolution mismatch");
        }
        if (quality < 0 || quality > 100) {
            throw new IllegalArgumentException("quality must be 0..100");
        }
        if (stream == null) {
            throw new IllegalArgumentException("stream cannot be null");
        }
        if (!YuvImage.isSupportedJpegRColorSpace(true, this.mColorSpace.getId()) || !YuvImage.isSupportedJpegRColorSpace(false, sdr.getColorSpace().getId())) {
            throw new IllegalArgumentException("Not supported color space. SDR only supports: " + YuvImage.printSupportedJpegRColorSpaces(false) + "HDR only supports: " + YuvImage.printSupportedJpegRColorSpaces(true));
        }
        return YuvImage.nativeCompressToJpegR(this.mData, this.mColorSpace.getDataSpace(), sdr.getYuvData(), sdr.getColorSpace().getDataSpace(), this.mWidth, this.mHeight, quality, stream, new byte[4096], exif, this.mStrides, sdr.getStrides());
    }

    public byte[] getYuvData() {
        return this.mData;
    }

    public int getYuvFormat() {
        return this.mFormat;
    }

    public int[] getStrides() {
        return this.mStrides;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    @NonNull
    public ColorSpace getColorSpace() {
        return this.mColorSpace;
    }

    int[] calculateOffsets(int left, int top) {
        int[] offsets = null;
        if (this.mFormat == 17) {
            offsets = new int[]{top * this.mStrides[0] + left, this.mHeight * this.mStrides[0] + top / 2 * this.mStrides[1] + left / 2 * 2};
            return offsets;
        }
        if (this.mFormat == 20) {
            offsets = new int[]{top * this.mStrides[0] + left / 2 * 4};
            return offsets;
        }
        return offsets;
    }

    private int[] calculateStrides(int width, int format) {
        int[] strides = null;
        switch (format) {
            case 17: {
                strides = new int[]{width, width};
                return strides;
            }
            case 54: {
                strides = new int[]{width * 2, width * 2};
                return strides;
            }
            case 35: {
                strides = new int[]{width, (width + 1) / 2, (width + 1) / 2};
                return strides;
            }
            case 20: {
                strides = new int[]{width * 2};
                return strides;
            }
        }
        throw new IllegalArgumentException("only supports the following ImageFormat:" + YuvImage.printSupportedFormats());
    }

    private void adjustRectangle(Rect rect) {
        int width = rect.width();
        int height = rect.height();
        if (this.mFormat == 17) {
            rect.left &= 0xFFFFFFFE;
            rect.top &= 0xFFFFFFFE;
            rect.right = rect.left + (width &= 0xFFFFFFFE);
            rect.bottom = rect.top + (height &= 0xFFFFFFFE);
        }
        if (this.mFormat == 20) {
            rect.left &= 0xFFFFFFFE;
            rect.right = rect.left + (width &= 0xFFFFFFFE);
        }
    }

    private static native boolean nativeCompressToJpeg(byte[] var0, int var1, int var2, int var3, int[] var4, int[] var5, int var6, OutputStream var7, byte[] var8);

    private static native boolean nativeCompressToJpegR(byte[] var0, int var1, byte[] var2, int var3, int var4, int var5, int var6, OutputStream var7, byte[] var8, byte[] var9, int[] var10, int[] var11);
}

