/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.NonNull;
import android.graphics.Path;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import dalvik.annotation.optimization.CriticalNative;
import dalvik.system.VMRuntime;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import libcore.util.NativeAllocationRegistry;

@RavenwoodKeepWholeClass
public class PathIterator
implements Iterator<Segment> {
    private final float[] mPointsArray;
    private final long mPointsAddress;
    private int mCachedVerb = -1;
    private boolean mDone = false;
    private final long mNativeIterator;
    private final Path mPath;
    private final int mPathGenerationId;
    private static int POINT_ARRAY_SIZE = 8;
    private static boolean IS_DALVIK;
    public static int VERB_MOVE = 0;
    public static int VERB_LINE = 1;
    public static int VERB_QUAD = 2;
    public static int VERB_CONIC = 3;
    public static int VERB_CUBIC = 4;
    public static int VERB_CLOSE = 5;
    public static int VERB_DONE = 6;

    PathIterator(@NonNull Path path) {
        this.mPath = path;
        this.mNativeIterator = PathIterator.nCreate(this.mPath.mNativePath);
        this.mPathGenerationId = this.mPath.getGenerationId();
        if (IS_DALVIK) {
            VMRuntime runtime = VMRuntime.getRuntime();
            this.mPointsArray = (float[])runtime.newNonMovableArray(Float.TYPE, 8);
            this.mPointsAddress = runtime.addressOf(this.mPointsArray);
        } else {
            this.mPointsArray = new float[8];
            this.mPointsAddress = 0L;
        }
        NoImagePreloadHolder.sRegistry.registerNativeAllocation(this, this.mNativeIterator);
    }

    @NonNull
    public int next(@NonNull float[] points, int offset) {
        if (points.length < offset + 8) {
            throw new ArrayIndexOutOfBoundsException("points array must be able to hold at least 8 entries");
        }
        int returnVerb = this.getReturnVerb(this.mCachedVerb);
        this.mCachedVerb = -1;
        System.arraycopy(this.mPointsArray, 0, points, offset, 8);
        return returnVerb;
    }

    @Override
    public boolean hasNext() {
        if (this.mCachedVerb == -1) {
            this.mCachedVerb = this.nextInternal();
        }
        return this.mCachedVerb != 6;
    }

    @NonNull
    public int peek() {
        if (this.mPathGenerationId != this.mPath.getGenerationId()) {
            throw new ConcurrentModificationException("Iterator cannot be used on modified Path");
        }
        if (this.mDone) {
            return 6;
        }
        return PathIterator.nPeek(this.mNativeIterator);
    }

    @NonNull
    private int nextInternal() {
        int verb;
        if (this.mDone) {
            return 6;
        }
        if (this.mPathGenerationId != this.mPath.getGenerationId()) {
            throw new ConcurrentModificationException("Iterator cannot be used on modified Path");
        }
        int n = verb = IS_DALVIK ? PathIterator.nNext(this.mNativeIterator, this.mPointsAddress) : PathIterator.nNextHost(this.mNativeIterator, this.mPointsArray);
        if (verb == 6) {
            this.mDone = true;
        }
        return verb;
    }

    @Override
    @NonNull
    public Segment next() {
        int returnVerb = this.getReturnVerb(this.mCachedVerb);
        this.mCachedVerb = -1;
        float conicWeight = 0.0f;
        if (returnVerb == 3) {
            conicWeight = this.mPointsArray[6];
        }
        float[] returnPoints = new float[8];
        System.arraycopy(this.mPointsArray, 0, returnPoints, 0, 8);
        return new Segment(returnVerb, returnPoints, conicWeight);
    }

    private int getReturnVerb(int cachedVerb) {
        switch (cachedVerb) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
        }
        return this.nextInternal();
    }

    private static native long nCreate(long var0);

    private static native long nGetFinalizer();

    private static native int nNextHost(long var0, float[] var2);

    @CriticalNative
    private static native int nNext(long var0, long var2);

    @CriticalNative
    private static native int nPeek(long var0);

    public static void deferredStaticInitializer() {
        IS_DALVIK = "dalvik".equalsIgnoreCase(System.getProperty("java.vm.name"));
    }

    private static class NoImagePreloadHolder {
        private static final NativeAllocationRegistry sRegistry = NativeAllocationRegistry.createMalloced(PathIterator.class.getClassLoader(), PathIterator.nGetFinalizer());

        private NoImagePreloadHolder() {
        }
    }

    public static class Segment {
        private final int mVerb;
        private final float[] mPoints;
        private final float mConicWeight;

        @NonNull
        public int getVerb() {
            return this.mVerb;
        }

        @NonNull
        public float[] getPoints() {
            return this.mPoints;
        }

        public float getConicWeight() {
            return this.mConicWeight;
        }

        Segment(@NonNull int verb, @NonNull float[] points, float conicWeight) {
            this.mVerb = verb;
            this.mPoints = points;
            this.mConicWeight = conicWeight;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface Verb {
    }
}

