/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.NonNull;
import android.graphics.Color;
import android.graphics.ColorSpace;
import android.graphics.MeshSpecification;
import android.graphics.RectF;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.Buffer;
import java.nio.ShortBuffer;
import libcore.util.NativeAllocationRegistry;

@RavenwoodKeepWholeClass
public class Mesh {
    private long mNativeMeshWrapper;
    private boolean mIsIndexed;
    public static final int TRIANGLES = 0;
    public static final int TRIANGLE_STRIP = 1;

    public Mesh(@NonNull MeshSpecification meshSpec, int mode, @NonNull Buffer vertexBuffer, int vertexCount, @NonNull RectF bounds) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("Invalid value passed in for mode parameter");
        }
        long nativeMesh = Mesh.nativeMake(meshSpec.mNativeMeshSpec, mode, vertexBuffer, vertexBuffer.isDirect(), vertexCount, vertexBuffer.position(), bounds.left, bounds.top, bounds.right, bounds.bottom);
        if (nativeMesh == 0L) {
            throw new IllegalArgumentException("Mesh construction failed.");
        }
        this.meshSetup(nativeMesh, false);
    }

    public Mesh(@NonNull MeshSpecification meshSpec, int mode, @NonNull Buffer vertexBuffer, int vertexCount, @NonNull ShortBuffer indexBuffer, @NonNull RectF bounds) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException("Invalid value passed in for mode parameter");
        }
        long nativeMesh = Mesh.nativeMakeIndexed(meshSpec.mNativeMeshSpec, mode, vertexBuffer, vertexBuffer.isDirect(), vertexCount, vertexBuffer.position(), indexBuffer, indexBuffer.isDirect(), indexBuffer.capacity(), indexBuffer.position(), bounds.left, bounds.top, bounds.right, bounds.bottom);
        if (nativeMesh == 0L) {
            throw new IllegalArgumentException("Mesh construction failed.");
        }
        this.meshSetup(nativeMesh, true);
    }

    public void setColorUniform(@NonNull String uniformName, int color2) {
        this.setUniform(uniformName, Color.valueOf(color2).getComponents(), true);
    }

    public void setColorUniform(@NonNull String uniformName, long color2) {
        Color exSRGB = Color.valueOf(color2).convert(ColorSpace.get(ColorSpace.Named.EXTENDED_SRGB));
        this.setUniform(uniformName, exSRGB.getComponents(), true);
    }

    public void setColorUniform(@NonNull String uniformName, @NonNull Color color2) {
        if (color2 == null) {
            throw new NullPointerException("The color parameter must not be null");
        }
        Color exSRGB = color2.convert(ColorSpace.get(ColorSpace.Named.EXTENDED_SRGB));
        this.setUniform(uniformName, exSRGB.getComponents(), true);
    }

    public void setFloatUniform(@NonNull String uniformName, float value) {
        this.setFloatUniform(uniformName, value, 0.0f, 0.0f, 0.0f, 1);
    }

    public void setFloatUniform(@NonNull String uniformName, float value1, float value2) {
        this.setFloatUniform(uniformName, value1, value2, 0.0f, 0.0f, 2);
    }

    public void setFloatUniform(@NonNull String uniformName, float value1, float value2, float value3) {
        this.setFloatUniform(uniformName, value1, value2, value3, 0.0f, 3);
    }

    public void setFloatUniform(@NonNull String uniformName, float value1, float value2, float value3, float value4) {
        this.setFloatUniform(uniformName, value1, value2, value3, value4, 4);
    }

    public void setFloatUniform(@NonNull String uniformName, @NonNull float[] values) {
        this.setUniform(uniformName, values, false);
    }

    private void setFloatUniform(String uniformName, float value1, float value2, float value3, float value4, int count) {
        if (uniformName == null) {
            throw new NullPointerException("The uniformName parameter must not be null");
        }
        Mesh.nativeUpdateUniforms(this.mNativeMeshWrapper, uniformName, value1, value2, value3, value4, count);
    }

    private void setUniform(String uniformName, float[] values, boolean isColor) {
        if (uniformName == null) {
            throw new NullPointerException("The uniformName parameter must not be null");
        }
        if (values == null) {
            throw new NullPointerException("The uniform values parameter must not be null");
        }
        Mesh.nativeUpdateUniforms(this.mNativeMeshWrapper, uniformName, values, isColor);
    }

    public void setIntUniform(@NonNull String uniformName, int value) {
        this.setIntUniform(uniformName, value, 0, 0, 0, 1);
    }

    public void setIntUniform(@NonNull String uniformName, int value1, int value2) {
        this.setIntUniform(uniformName, value1, value2, 0, 0, 2);
    }

    public void setIntUniform(@NonNull String uniformName, int value1, int value2, int value3) {
        this.setIntUniform(uniformName, value1, value2, value3, 0, 3);
    }

    public void setIntUniform(@NonNull String uniformName, int value1, int value2, int value3, int value4) {
        this.setIntUniform(uniformName, value1, value2, value3, value4, 4);
    }

    public void setIntUniform(@NonNull String uniformName, @NonNull int[] values) {
        if (uniformName == null) {
            throw new NullPointerException("The uniformName parameter must not be null");
        }
        if (values == null) {
            throw new NullPointerException("The uniform values parameter must not be null");
        }
        Mesh.nativeUpdateUniforms(this.mNativeMeshWrapper, uniformName, values);
    }

    long getNativeWrapperInstance() {
        return this.mNativeMeshWrapper;
    }

    private void setIntUniform(String uniformName, int value1, int value2, int value3, int value4, int count) {
        if (uniformName == null) {
            throw new NullPointerException("The uniformName parameter must not be null");
        }
        Mesh.nativeUpdateUniforms(this.mNativeMeshWrapper, uniformName, value1, value2, value3, value4, count);
    }

    private void meshSetup(long nativeMeshWrapper, boolean isIndexed) {
        this.mNativeMeshWrapper = nativeMeshWrapper;
        this.mIsIndexed = isIndexed;
        MeshHolder.MESH_SPECIFICATION_REGISTRY.registerNativeAllocation(this, this.mNativeMeshWrapper);
    }

    private static native long nativeGetFinalizer();

    private static native long nativeMake(long var0, int var2, Buffer var3, boolean var4, int var5, int var6, float var7, float var8, float var9, float var10);

    private static native long nativeMakeIndexed(long var0, int var2, Buffer var3, boolean var4, int var5, int var6, ShortBuffer var7, boolean var8, int var9, int var10, float var11, float var12, float var13, float var14);

    private static native void nativeUpdateUniforms(long var0, String var2, float var3, float var4, float var5, float var6, int var7);

    private static native void nativeUpdateUniforms(long var0, String var2, float[] var3, boolean var4);

    private static native void nativeUpdateUniforms(long var0, String var2, int var3, int var4, int var5, int var6, int var7);

    private static native void nativeUpdateUniforms(long var0, String var2, int[] var3);

    private static class MeshHolder {
        public static final NativeAllocationRegistry MESH_SPECIFICATION_REGISTRY = NativeAllocationRegistry.createMalloced(MeshSpecification.class.getClassLoader(), Mesh.nativeGetFinalizer());

        private MeshHolder() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface Mode {
    }
}

