/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.compat.annotation.UnsupportedAppUsage;
import android.graphics.ColorFilter;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;

@RavenwoodKeepWholeClass
public class LightingColorFilter
extends ColorFilter {
    private int mMul;
    private int mAdd;

    public LightingColorFilter(int mul, int add) {
        this.mMul = mul;
        this.mAdd = add;
    }

    public int getColorMultiply() {
        return this.mMul;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setColorMultiply(int mul) {
        if (this.mMul != mul) {
            this.mMul = mul;
            LightingColorFilter.native_SetLightingFilterMul(this.getNativeInstance(), mul);
        }
    }

    public int getColorAdd() {
        return this.mAdd;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public void setColorAdd(int add) {
        if (this.mAdd != add) {
            this.mAdd = add;
            LightingColorFilter.native_SetLightingFilterAdd(this.getNativeInstance(), add);
        }
    }

    @Override
    long createNativeInstance() {
        return LightingColorFilter.native_CreateLightingFilter(this.mMul, this.mAdd);
    }

    private static native long native_CreateLightingFilter(int var0, int var1);

    private static native void native_SetLightingFilterAdd(long var0, int var2);

    private static native void native_SetLightingFilterMul(long var0, int var2);
}

