/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.annotation.NonNull;
import android.graphics.BlendMode;
import android.graphics.ColorFilter;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;

@RavenwoodKeepWholeClass
public final class BlendModeColorFilter
extends ColorFilter {
    final int mColor;
    private final BlendMode mMode;

    public BlendModeColorFilter(int color2, @NonNull BlendMode mode) {
        this.mColor = color2;
        this.mMode = mode;
    }

    public int getColor() {
        return this.mColor;
    }

    public BlendMode getMode() {
        return this.mMode;
    }

    @Override
    long createNativeInstance() {
        return BlendModeColorFilter.native_CreateBlendModeFilter(this.mColor, this.mMode.getXfermode().porterDuffMode);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BlendModeColorFilter other = (BlendModeColorFilter)object;
        return other.mMode == this.mMode && other.mColor == this.mColor;
    }

    public int hashCode() {
        return 31 * this.mMode.hashCode() + this.mColor;
    }

    private static native long native_CreateBlendModeFilter(int var0, int var1);
}

