/*
 * Decompiled with CFR 0.152.
 */
package android.devicelock;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.devicelock.DeviceId;
import android.devicelock.IDeviceLockService;
import android.devicelock.IGetDeviceIdCallback;
import android.devicelock.IGetEnrollmentTypeCallback;
import android.devicelock.IGetKioskAppsCallback;
import android.devicelock.IIsDeviceLockedCallback;
import android.devicelock.IVoidResultCallback;
import android.devicelock.ParcelableException;
import android.os.OutcomeReceiver;
import android.os.RemoteException;
import android.text.TextUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;

public class DeviceLockManager {
    private static final String TAG = "DeviceLockManager";
    private final IDeviceLockService mService;
    public static final int DEVICE_LOCK_ROLE_FINANCING = 0;
    @FlaggedApi(value="com.android.devicelock.flags.extra_device_lock_version")
    public static final String EXTRA_DEVICE_LOCK_VERSION = "android.devicelock.extra.DEVICE_LOCK_VERSION";
    @SystemApi
    @FlaggedApi(value="com.android.devicelock.flags.get_enrollment_type")
    public static final int ENROLLMENT_TYPE_NONE = 0;
    @SystemApi
    @FlaggedApi(value="com.android.devicelock.flags.get_enrollment_type")
    public static final int ENROLLMENT_TYPE_FINANCE = 1;
    @SystemApi
    @FlaggedApi(value="com.android.devicelock.flags.get_enrollment_type")
    public static final int ENROLLMENT_TYPE_SUBSIDY = 2;

    public DeviceLockManager(Context context, IDeviceLockService service) {
        this.mService = service;
    }

    @NonNull
    public IDeviceLockService getService() {
        return this.mService;
    }

    @RequiresPermission(value="android.permission.MANAGE_DEVICE_LOCK_STATE")
    public void lockDevice(final @NonNull Executor executor, final @NonNull OutcomeReceiver<Void, Exception> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.lockDevice(new IVoidResultCallback.Stub(this){

                @Override
                public void onSuccess() {
                    executor.execute(() -> callback.onResult(null));
                }

                @Override
                public void onError(ParcelableException parcelableException) {
                    callback.onError(parcelableException.getException());
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_DEVICE_LOCK_STATE")
    public void unlockDevice(final @NonNull Executor executor, final @NonNull OutcomeReceiver<Void, Exception> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.unlockDevice(new IVoidResultCallback.Stub(this){

                @Override
                public void onSuccess() {
                    executor.execute(() -> callback.onResult(null));
                }

                @Override
                public void onError(ParcelableException parcelableException) {
                    callback.onError(parcelableException.getException());
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_DEVICE_LOCK_STATE")
    public void isDeviceLocked(final @NonNull Executor executor, final @NonNull OutcomeReceiver<Boolean, Exception> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.isDeviceLocked(new IIsDeviceLockedCallback.Stub(this){

                @Override
                public void onIsDeviceLocked(boolean locked) {
                    executor.execute(() -> callback.onResult(locked));
                }

                @Override
                public void onError(ParcelableException parcelableException) {
                    executor.execute(() -> callback.onError(parcelableException.getException()));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_DEVICE_LOCK_STATE")
    @FlaggedApi(value="com.android.devicelock.flags.clear_device_restrictions")
    public void clearDeviceRestrictions(final @NonNull Executor executor, final @NonNull OutcomeReceiver<Void, Exception> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.clearDeviceRestrictions(new IVoidResultCallback.Stub(this){

                @Override
                public void onSuccess() {
                    executor.execute(() -> callback.onResult(null));
                }

                @Override
                public void onError(ParcelableException parcelableException) {
                    callback.onError(parcelableException.getException());
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_DEVICE_LOCK_STATE")
    public void getDeviceId(final @NonNull Executor executor, final @NonNull OutcomeReceiver<DeviceId, Exception> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.getDeviceId(new IGetDeviceIdCallback.Stub(this){

                @Override
                public void onDeviceIdReceived(int type, String id2) {
                    if (TextUtils.isEmpty(id2)) {
                        executor.execute(() -> callback.onError(new Exception("Cannot get device id (empty)")));
                    } else {
                        executor.execute(() -> callback.onResult(new DeviceId(type, id2)));
                    }
                }

                @Override
                public void onError(ParcelableException parcelableException) {
                    callback.onError(parcelableException.getException());
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresNoPermission
    public void getKioskApps(final @NonNull Executor executor, final @NonNull OutcomeReceiver<Map<Integer, String>, Exception> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.getKioskApps(new IGetKioskAppsCallback.Stub(this){

                @Override
                public void onKioskAppsReceived(Map kioskApps) {
                    executor.execute(() -> callback.onResult(kioskApps));
                }

                @Override
                public void onError(ParcelableException parcelableException) {
                    callback.onError(parcelableException.getException());
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.devicelock.flags.get_enrollment_type")
    @RequiresPermission(value="android.permission.GET_DEVICE_LOCK_ENROLLMENT_TYPE")
    public void getEnrollmentType(final @NonNull Executor executor, final @NonNull OutcomeReceiver<Integer, Exception> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.getEnrollmentType(new IGetEnrollmentTypeCallback.Stub(this){

                @Override
                public void onEnrollmentTypeReceived(int enrollmentType) {
                    executor.execute(() -> callback.onResult(enrollmentType));
                }

                @Override
                public void onError(ParcelableException parcelableException) {
                    callback.onError(parcelableException.getException());
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_DEVICE_LOCK_STATE")
    @FlaggedApi(value="com.android.devicelock.flags.notify_kiosk_setup_finished")
    public void notifyKioskSetupFinished(final @NonNull Executor executor, final @NonNull OutcomeReceiver<Void, Exception> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.notifyKioskSetupFinished(new IVoidResultCallback.Stub(this){

                @Override
                public void onSuccess() {
                    executor.execute(() -> callback.onResult(null));
                }

                @Override
                public void onError(ParcelableException parcelableException) {
                    callback.onError(parcelableException.getException());
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Target(value={ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EnrollmentType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceLockRole {
    }
}

