/*
 * Decompiled with CFR 0.152.
 */
package android.credentials.selection;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.credentials.selection.AuthenticationEntry;
import android.credentials.selection.Entry;
import android.credentials.selection.GetCredentialProviderInfo;
import android.credentials.selection.ProviderData;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import java.util.ArrayList;
import java.util.List;

@FlaggedApi(value="android.credentials.flags.configurable_selector_ui_enabled")
public class GetCredentialProviderData
extends ProviderData
implements Parcelable {
    @NonNull
    private final List<Entry> mCredentialEntries;
    @NonNull
    private final List<Entry> mActionChips;
    @NonNull
    private final List<AuthenticationEntry> mAuthenticationEntries;
    @Nullable
    private final Entry mRemoteEntry;
    @NonNull
    public static final Parcelable.Creator<GetCredentialProviderData> CREATOR = new Parcelable.Creator<GetCredentialProviderData>(){

        @Override
        public GetCredentialProviderData createFromParcel(@NonNull Parcel in) {
            return new GetCredentialProviderData(in);
        }

        public GetCredentialProviderData[] newArray(int size) {
            return new GetCredentialProviderData[size];
        }
    };

    public GetCredentialProviderData(@NonNull String providerFlattenedComponentName, @NonNull List<Entry> credentialEntries, @NonNull List<Entry> actionChips, @NonNull List<AuthenticationEntry> authenticationEntries, @Nullable Entry remoteEntry) {
        super(providerFlattenedComponentName);
        this.mCredentialEntries = new ArrayList<Entry>(credentialEntries);
        this.mActionChips = new ArrayList<Entry>(actionChips);
        this.mAuthenticationEntries = new ArrayList<AuthenticationEntry>(authenticationEntries);
        this.mRemoteEntry = remoteEntry;
    }

    @NonNull
    public GetCredentialProviderInfo toGetCredentialProviderInfo() {
        return new GetCredentialProviderInfo(this.getProviderFlattenedComponentName(), this.mCredentialEntries, this.mActionChips, this.mAuthenticationEntries, this.mRemoteEntry);
    }

    @NonNull
    public List<Entry> getCredentialEntries() {
        return this.mCredentialEntries;
    }

    @NonNull
    public List<Entry> getActionChips() {
        return this.mActionChips;
    }

    @NonNull
    public List<AuthenticationEntry> getAuthenticationEntries() {
        return this.mAuthenticationEntries;
    }

    @Nullable
    public Entry getRemoteEntry() {
        return this.mRemoteEntry;
    }

    private GetCredentialProviderData(@NonNull Parcel in) {
        super(in);
        Entry remoteEntry;
        ArrayList<Entry> credentialEntries = new ArrayList<Entry>();
        in.readTypedList(credentialEntries, Entry.CREATOR);
        this.mCredentialEntries = credentialEntries;
        AnnotationValidations.validate(NonNull.class, null, this.mCredentialEntries);
        ArrayList<Entry> actionChips = new ArrayList<Entry>();
        in.readTypedList(actionChips, Entry.CREATOR);
        this.mActionChips = actionChips;
        AnnotationValidations.validate(NonNull.class, null, this.mActionChips);
        ArrayList<AuthenticationEntry> authenticationEntries = new ArrayList<AuthenticationEntry>();
        in.readTypedList(authenticationEntries, AuthenticationEntry.CREATOR);
        this.mAuthenticationEntries = authenticationEntries;
        AnnotationValidations.validate(NonNull.class, null, this.mAuthenticationEntries);
        this.mRemoteEntry = remoteEntry = in.readTypedObject(Entry.CREATOR);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeTypedList(this.mCredentialEntries);
        dest.writeTypedList(this.mActionChips);
        dest.writeTypedList(this.mAuthenticationEntries);
        dest.writeTypedObject(this.mRemoteEntry, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @FlaggedApi(value="android.credentials.flags.configurable_selector_ui_enabled")
    public static class Builder {
        @NonNull
        private String mProviderFlattenedComponentName;
        @NonNull
        private List<Entry> mCredentialEntries = new ArrayList<Entry>();
        @NonNull
        private List<Entry> mActionChips = new ArrayList<Entry>();
        @NonNull
        private List<AuthenticationEntry> mAuthenticationEntries = new ArrayList<AuthenticationEntry>();
        @Nullable
        private Entry mRemoteEntry = null;

        public Builder(@NonNull String providerFlattenedComponentName) {
            this.mProviderFlattenedComponentName = providerFlattenedComponentName;
        }

        @NonNull
        public Builder setCredentialEntries(@NonNull List<Entry> credentialEntries) {
            this.mCredentialEntries = credentialEntries;
            return this;
        }

        @NonNull
        public Builder setActionChips(@NonNull List<Entry> actionChips) {
            this.mActionChips = actionChips;
            return this;
        }

        @NonNull
        public Builder setAuthenticationEntries(@NonNull List<AuthenticationEntry> authenticationEntry) {
            this.mAuthenticationEntries = authenticationEntry;
            return this;
        }

        @NonNull
        public Builder setRemoteEntry(@Nullable Entry remoteEntry) {
            this.mRemoteEntry = remoteEntry;
            return this;
        }

        @NonNull
        public GetCredentialProviderData build() {
            return new GetCredentialProviderData(this.mProviderFlattenedComponentName, this.mCredentialEntries, this.mActionChips, this.mAuthenticationEntries, this.mRemoteEntry);
        }
    }
}

