/*
 * Decompiled with CFR 0.152.
 */
package android.credentials.selection;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.slice.Slice;
import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
@FlaggedApi(value="android.credentials.flags.configurable_selector_ui_enabled")
public class AuthenticationEntry
implements Parcelable {
    @NonNull
    private final String mKey;
    @NonNull
    private final String mSubkey;
    @NonNull
    private final int mStatus;
    @Nullable
    private Intent mFrameworkExtrasIntent;
    @NonNull
    private final Slice mSlice;
    public static final int STATUS_LOCKED = 0;
    public static final int STATUS_UNLOCKED_BUT_EMPTY_LESS_RECENT = 1;
    public static final int STATUS_UNLOCKED_BUT_EMPTY_MOST_RECENT = 2;
    @NonNull
    public static final Parcelable.Creator<AuthenticationEntry> CREATOR = new Parcelable.Creator<AuthenticationEntry>(){

        @Override
        public AuthenticationEntry createFromParcel(@NonNull Parcel in) {
            return new AuthenticationEntry(in);
        }

        public AuthenticationEntry[] newArray(int size) {
            return new AuthenticationEntry[size];
        }
    };

    private AuthenticationEntry(@NonNull Parcel in) {
        this.mKey = in.readString8();
        this.mSubkey = in.readString8();
        this.mStatus = in.readInt();
        this.mSlice = in.readTypedObject(Slice.CREATOR);
        this.mFrameworkExtrasIntent = in.readTypedObject(Intent.CREATOR);
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mKey);
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mSubkey);
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mSlice);
    }

    public AuthenticationEntry(@NonNull String key, @NonNull String subkey, @NonNull Slice slice, int status, @NonNull Intent intent) {
        this.mKey = key;
        this.mSubkey = subkey;
        this.mSlice = slice;
        this.mStatus = status;
        this.mFrameworkExtrasIntent = intent;
    }

    @NonNull
    public String getKey() {
        return this.mKey;
    }

    @NonNull
    public String getSubkey() {
        return this.mSubkey;
    }

    @NonNull
    public Slice getSlice() {
        return this.mSlice;
    }

    @NonNull
    public int getStatus() {
        return this.mStatus;
    }

    @Nullable
    @SuppressLint(value={"IntentBuilderName"})
    public Intent getFrameworkExtrasIntent() {
        return this.mFrameworkExtrasIntent;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString8(this.mKey);
        dest.writeString8(this.mSubkey);
        dest.writeInt(this.mStatus);
        dest.writeTypedObject(this.mSlice, flags);
        dest.writeTypedObject(this.mFrameworkExtrasIntent, flags);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
    }
}

