/*
 * Decompiled with CFR 0.152.
 */
package android.credentials;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.app.ActivityOptions;
import android.app.PendingIntent;
import android.content.Context;
import android.content.IntentSender;
import android.credentials.CredentialManager;
import android.credentials.GetCredentialException;
import android.credentials.GetCredentialResponse;
import android.credentials.PrepareGetCredentialResponseInternal;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.OutcomeReceiver;
import android.util.Log;
import java.util.concurrent.Executor;

public class PrepareGetCredentialResponse {
    private static final Bundle OPTIONS_SENDER_BAL_OPTIN = ActivityOptions.makeBasic().setPendingIntentBackgroundActivityStartMode(1).toBundle();
    private static final String TAG = "CredentialManager";
    @NonNull
    private final PrepareGetCredentialResponseInternal mResponseInternal;
    @NonNull
    private final PendingGetCredentialHandle mPendingGetCredentialHandle;

    @RequiresPermission(value="android.permission.CREDENTIAL_MANAGER_QUERY_CANDIDATE_CREDENTIALS")
    public boolean hasCredentialResults(@NonNull String credentialType) {
        return this.mResponseInternal.hasCredentialResults(credentialType);
    }

    @RequiresPermission(value="android.permission.CREDENTIAL_MANAGER_QUERY_CANDIDATE_CREDENTIALS")
    public boolean hasAuthenticationResults() {
        return this.mResponseInternal.hasAuthenticationResults();
    }

    @RequiresPermission(value="android.permission.CREDENTIAL_MANAGER_QUERY_CANDIDATE_CREDENTIALS")
    public boolean hasRemoteResults() {
        return this.mResponseInternal.hasRemoteResults();
    }

    @NonNull
    public PendingGetCredentialHandle getPendingGetCredentialHandle() {
        return this.mPendingGetCredentialHandle;
    }

    protected PrepareGetCredentialResponse(@NonNull PrepareGetCredentialResponseInternal responseInternal, @NonNull CredentialManager.GetCredentialTransportPendingUseCase getCredentialTransport) {
        this.mResponseInternal = responseInternal;
        this.mPendingGetCredentialHandle = new PendingGetCredentialHandle(getCredentialTransport, responseInternal.getPendingIntent());
    }

    public static class PendingGetCredentialHandle {
        @NonNull
        private final CredentialManager.GetCredentialTransportPendingUseCase mGetCredentialTransport;
        @Nullable
        private final PendingIntent mPendingIntent;

        PendingGetCredentialHandle(@NonNull CredentialManager.GetCredentialTransportPendingUseCase transport, @Nullable PendingIntent pendingIntent) {
            this.mGetCredentialTransport = transport;
            this.mPendingIntent = pendingIntent;
        }

        void show(final @NonNull Context context, @Nullable CancellationSignal cancellationSignal, final @NonNull Executor executor, final @NonNull OutcomeReceiver<GetCredentialResponse, GetCredentialException> callback) {
            if (this.mPendingIntent == null) {
                executor.execute(() -> callback.onError(new GetCredentialException("android.credentials.GetCredentialException.TYPE_NO_CREDENTIAL")));
                return;
            }
            this.mGetCredentialTransport.setCallback(new GetPendingCredentialInternalCallback(){

                @Override
                public void onPendingIntent(PendingIntent pendingIntent) {
                    try {
                        context.startIntentSender(pendingIntent.getIntentSender(), null, 0, 0, 0, OPTIONS_SENDER_BAL_OPTIN);
                    }
                    catch (IntentSender.SendIntentException e) {
                        Log.e(PrepareGetCredentialResponse.TAG, "startIntentSender() failed for intent for show()", e);
                        executor.execute(() -> callback.onError(new GetCredentialException("android.credentials.GetCredentialException.TYPE_UNKNOWN")));
                    }
                }

                @Override
                public void onResponse(GetCredentialResponse response) {
                    executor.execute(() -> callback.onResult(response));
                }

                @Override
                public void onError(String errorType, String message) {
                    executor.execute(() -> callback.onError(new GetCredentialException(errorType, message)));
                }
            });
            try {
                context.startIntentSender(this.mPendingIntent.getIntentSender(), null, 0, 0, 0, OPTIONS_SENDER_BAL_OPTIN);
            }
            catch (IntentSender.SendIntentException e) {
                Log.e(PrepareGetCredentialResponse.TAG, "startIntentSender() failed for intent for show()", e);
                executor.execute(() -> callback.onError(new GetCredentialException("android.credentials.GetCredentialException.TYPE_UNKNOWN")));
            }
        }
    }

    protected static interface GetPendingCredentialInternalCallback {
        public void onPendingIntent(@NonNull PendingIntent var1);

        public void onResponse(@NonNull GetCredentialResponse var1);

        public void onError(@NonNull String var1, @Nullable String var2);
    }
}

