/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm.parsing;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.pm.ArchivedPackageParcel;
import android.content.pm.PackageInfo;
import android.content.pm.SharedLibraryInfo;
import android.content.pm.SigningDetails;
import android.content.pm.VerifierInfo;
import com.android.internal.util.CollectionUtils;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ApkLite {
    @NonNull
    private final String mPackageName;
    @NonNull
    private final String mPath;
    @Nullable
    private final String mSplitName;
    @Nullable
    private final String mUsesSplitName;
    @Nullable
    private final String mConfigForSplit;
    @Nullable
    private final Set<String> mRequiredSplitTypes;
    @Nullable
    private final Set<String> mSplitTypes;
    private final int mVersionCodeMajor;
    private final int mVersionCode;
    private final int mRevisionCode;
    private final int mInstallLocation;
    private final int mMinSdkVersion;
    private final int mTargetSdkVersion;
    @NonNull
    private final VerifierInfo[] mVerifiers;
    @NonNull
    private final SigningDetails mSigningDetails;
    private final boolean mFeatureSplit;
    private final boolean mIsolatedSplits;
    private final boolean mSplitRequired;
    private final boolean mCoreApp;
    private final boolean mDebuggable;
    private final boolean mProfileableByShell;
    private final boolean mMultiArch;
    private final boolean mUse32bitAbi;
    private final boolean mExtractNativeLibs;
    private final boolean mUseEmbeddedDex;
    @Nullable
    private final String mTargetPackageName;
    private final boolean mOverlayIsStatic;
    private final int mOverlayPriority;
    @Nullable
    private final String mRequiredSystemPropertyName;
    @Nullable
    private final String mRequiredSystemPropertyValue;
    private final int mRollbackDataPolicy;
    private final boolean mHasDeviceAdminReceiver;
    private final boolean mIsSdkLibrary;
    private final boolean mIsStaticLibrary;
    @NonNull
    private final List<String> mUsesSdkLibraries;
    @Nullable
    private final long[] mUsesSdkLibrariesVersionsMajor;
    @Nullable
    private final String[][] mUsesSdkLibrariesCertDigests;
    @NonNull
    private final List<String> mUsesStaticLibraries;
    @Nullable
    private final long[] mUsesStaticLibrariesVersions;
    @Nullable
    private final String[][] mUsesStaticLibrariesCertDigests;
    private final boolean mUpdatableSystem;
    @Nullable
    private final String mEmergencyInstaller;
    @NonNull
    private final List<SharedLibraryInfo> mDeclaredLibraries;
    @Nullable
    private final ArchivedPackageParcel mArchivedPackage;
    private final int mPageSizeCompat;

    public ApkLite(String path, String packageName, String splitName, boolean isFeatureSplit, String configForSplit, String usesSplitName, boolean isSplitRequired, int versionCode, int versionCodeMajor, int revisionCode, int installLocation, List<VerifierInfo> verifiers, SigningDetails signingDetails, boolean coreApp, boolean debuggable, boolean profileableByShell, boolean multiArch, boolean use32bitAbi, boolean useEmbeddedDex, boolean extractNativeLibs, boolean isolatedSplits, String targetPackageName, boolean overlayIsStatic, int overlayPriority, String requiredSystemPropertyName, String requiredSystemPropertyValue, int minSdkVersion, int targetSdkVersion, int rollbackDataPolicy, Set<String> requiredSplitTypes, Set<String> splitTypes, boolean hasDeviceAdminReceiver, boolean isSdkLibrary, List<String> usesSdkLibraries, long[] usesSdkLibrariesVersionsMajor, String[][] usesSdkLibrariesCertDigests, boolean isStaticLibrary, List<String> usesStaticLibraries, long[] usesStaticLibrariesVersionsMajor, String[][] usesStaticLibrariesCertDigests, boolean updatableSystem, String emergencyInstaller, List<SharedLibraryInfo> declaredLibraries, int pageSizeCompat) {
        this.mPath = path;
        this.mPackageName = packageName;
        this.mSplitName = splitName;
        this.mSplitTypes = splitTypes;
        this.mFeatureSplit = isFeatureSplit;
        this.mConfigForSplit = configForSplit;
        this.mUsesSplitName = usesSplitName;
        this.mRequiredSplitTypes = requiredSplitTypes;
        this.mSplitRequired = isSplitRequired || this.hasAnyRequiredSplitTypes();
        this.mVersionCode = versionCode;
        this.mVersionCodeMajor = versionCodeMajor;
        this.mRevisionCode = revisionCode;
        this.mInstallLocation = installLocation;
        this.mVerifiers = verifiers.toArray(new VerifierInfo[verifiers.size()]);
        this.mSigningDetails = signingDetails;
        this.mCoreApp = coreApp;
        this.mDebuggable = debuggable;
        this.mProfileableByShell = profileableByShell;
        this.mMultiArch = multiArch;
        this.mUse32bitAbi = use32bitAbi;
        this.mUseEmbeddedDex = useEmbeddedDex;
        this.mExtractNativeLibs = extractNativeLibs;
        this.mIsolatedSplits = isolatedSplits;
        this.mTargetPackageName = targetPackageName;
        this.mOverlayIsStatic = overlayIsStatic;
        this.mOverlayPriority = overlayPriority;
        this.mRequiredSystemPropertyName = requiredSystemPropertyName;
        this.mRequiredSystemPropertyValue = requiredSystemPropertyValue;
        this.mMinSdkVersion = minSdkVersion;
        this.mTargetSdkVersion = targetSdkVersion;
        this.mRollbackDataPolicy = rollbackDataPolicy;
        this.mHasDeviceAdminReceiver = hasDeviceAdminReceiver;
        this.mIsSdkLibrary = isSdkLibrary;
        this.mIsStaticLibrary = isStaticLibrary;
        this.mUsesSdkLibraries = usesSdkLibraries;
        this.mUsesSdkLibrariesVersionsMajor = usesSdkLibrariesVersionsMajor;
        this.mUsesSdkLibrariesCertDigests = usesSdkLibrariesCertDigests;
        this.mUsesStaticLibraries = usesStaticLibraries;
        this.mUsesStaticLibrariesVersions = usesStaticLibrariesVersionsMajor;
        this.mUsesStaticLibrariesCertDigests = usesStaticLibrariesCertDigests;
        this.mUpdatableSystem = updatableSystem;
        this.mEmergencyInstaller = emergencyInstaller;
        this.mArchivedPackage = null;
        this.mDeclaredLibraries = declaredLibraries;
        this.mPageSizeCompat = pageSizeCompat;
    }

    public ApkLite(String path, ArchivedPackageParcel archivedPackage) {
        this.mPath = path;
        this.mPackageName = archivedPackage.packageName;
        this.mSplitName = null;
        this.mSplitTypes = null;
        this.mFeatureSplit = false;
        this.mConfigForSplit = null;
        this.mUsesSplitName = null;
        this.mRequiredSplitTypes = null;
        this.mSplitRequired = this.hasAnyRequiredSplitTypes();
        this.mVersionCode = archivedPackage.versionCode;
        this.mVersionCodeMajor = archivedPackage.versionCodeMajor;
        this.mRevisionCode = 0;
        this.mInstallLocation = -1;
        this.mVerifiers = new VerifierInfo[0];
        this.mSigningDetails = archivedPackage.signingDetails;
        this.mCoreApp = false;
        this.mDebuggable = false;
        this.mProfileableByShell = false;
        this.mMultiArch = false;
        this.mUse32bitAbi = false;
        this.mUseEmbeddedDex = false;
        this.mExtractNativeLibs = false;
        this.mIsolatedSplits = false;
        this.mTargetPackageName = null;
        this.mOverlayIsStatic = false;
        this.mOverlayPriority = 0;
        this.mRequiredSystemPropertyName = null;
        this.mRequiredSystemPropertyValue = null;
        this.mMinSdkVersion = 1;
        this.mTargetSdkVersion = archivedPackage.targetSdkVersion;
        this.mRollbackDataPolicy = 0;
        this.mHasDeviceAdminReceiver = false;
        this.mIsSdkLibrary = false;
        this.mIsStaticLibrary = false;
        this.mUsesSdkLibraries = Collections.emptyList();
        this.mUsesSdkLibrariesVersionsMajor = null;
        this.mUsesSdkLibrariesCertDigests = null;
        this.mUsesStaticLibraries = Collections.emptyList();
        this.mUsesStaticLibrariesVersions = null;
        this.mUsesStaticLibrariesCertDigests = null;
        this.mUpdatableSystem = true;
        this.mEmergencyInstaller = null;
        this.mArchivedPackage = archivedPackage;
        this.mDeclaredLibraries = null;
        this.mPageSizeCompat = 0;
    }

    public long getLongVersionCode() {
        return PackageInfo.composeLongVersionCode(this.mVersionCodeMajor, this.mVersionCode);
    }

    private boolean hasAnyRequiredSplitTypes() {
        return !CollectionUtils.isEmpty(this.mRequiredSplitTypes);
    }

    @NonNull
    public String getPackageName() {
        return this.mPackageName;
    }

    @NonNull
    public String getPath() {
        return this.mPath;
    }

    @Nullable
    public String getSplitName() {
        return this.mSplitName;
    }

    @Nullable
    public String getUsesSplitName() {
        return this.mUsesSplitName;
    }

    @Nullable
    public String getConfigForSplit() {
        return this.mConfigForSplit;
    }

    @Nullable
    public Set<String> getRequiredSplitTypes() {
        return this.mRequiredSplitTypes;
    }

    @Nullable
    public Set<String> getSplitTypes() {
        return this.mSplitTypes;
    }

    public int getVersionCodeMajor() {
        return this.mVersionCodeMajor;
    }

    public int getVersionCode() {
        return this.mVersionCode;
    }

    public int getRevisionCode() {
        return this.mRevisionCode;
    }

    public int getInstallLocation() {
        return this.mInstallLocation;
    }

    public int getMinSdkVersion() {
        return this.mMinSdkVersion;
    }

    public int getTargetSdkVersion() {
        return this.mTargetSdkVersion;
    }

    @NonNull
    public VerifierInfo[] getVerifiers() {
        return this.mVerifiers;
    }

    @NonNull
    public SigningDetails getSigningDetails() {
        return this.mSigningDetails;
    }

    public boolean isFeatureSplit() {
        return this.mFeatureSplit;
    }

    public boolean isIsolatedSplits() {
        return this.mIsolatedSplits;
    }

    public boolean isSplitRequired() {
        return this.mSplitRequired;
    }

    public boolean isCoreApp() {
        return this.mCoreApp;
    }

    public boolean isDebuggable() {
        return this.mDebuggable;
    }

    public boolean isProfileableByShell() {
        return this.mProfileableByShell;
    }

    public boolean isMultiArch() {
        return this.mMultiArch;
    }

    public boolean isUse32bitAbi() {
        return this.mUse32bitAbi;
    }

    public boolean isExtractNativeLibs() {
        return this.mExtractNativeLibs;
    }

    public boolean isUseEmbeddedDex() {
        return this.mUseEmbeddedDex;
    }

    @Nullable
    public String getTargetPackageName() {
        return this.mTargetPackageName;
    }

    public boolean isOverlayIsStatic() {
        return this.mOverlayIsStatic;
    }

    public int getOverlayPriority() {
        return this.mOverlayPriority;
    }

    @Nullable
    public String getRequiredSystemPropertyName() {
        return this.mRequiredSystemPropertyName;
    }

    @Nullable
    public String getRequiredSystemPropertyValue() {
        return this.mRequiredSystemPropertyValue;
    }

    public int getRollbackDataPolicy() {
        return this.mRollbackDataPolicy;
    }

    public boolean isHasDeviceAdminReceiver() {
        return this.mHasDeviceAdminReceiver;
    }

    public boolean isIsSdkLibrary() {
        return this.mIsSdkLibrary;
    }

    public boolean isIsStaticLibrary() {
        return this.mIsStaticLibrary;
    }

    @NonNull
    public List<String> getUsesSdkLibraries() {
        return this.mUsesSdkLibraries;
    }

    @Nullable
    public long[] getUsesSdkLibrariesVersionsMajor() {
        return this.mUsesSdkLibrariesVersionsMajor;
    }

    @Nullable
    public String[][] getUsesSdkLibrariesCertDigests() {
        return this.mUsesSdkLibrariesCertDigests;
    }

    @NonNull
    public List<String> getUsesStaticLibraries() {
        return this.mUsesStaticLibraries;
    }

    @Nullable
    public long[] getUsesStaticLibrariesVersions() {
        return this.mUsesStaticLibrariesVersions;
    }

    @Nullable
    public String[][] getUsesStaticLibrariesCertDigests() {
        return this.mUsesStaticLibrariesCertDigests;
    }

    public boolean isUpdatableSystem() {
        return this.mUpdatableSystem;
    }

    @Nullable
    public String getEmergencyInstaller() {
        return this.mEmergencyInstaller;
    }

    @NonNull
    public List<SharedLibraryInfo> getDeclaredLibraries() {
        return this.mDeclaredLibraries;
    }

    @Nullable
    public ArchivedPackageParcel getArchivedPackage() {
        return this.mArchivedPackage;
    }

    public int getPageSizeCompat() {
        return this.mPageSizeCompat;
    }

    @Deprecated
    private void __metadata() {
    }
}

