/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.xmlpull.v1.XmlPullParserException;

@SystemApi
public class UserProperties
implements Parcelable {
    private static final String LOG_TAG = UserProperties.class.getSimpleName();
    private static final String ATTR_SHOW_IN_LAUNCHER = "showInLauncher";
    private static final String ATTR_START_WITH_PARENT = "startWithParent";
    private static final String ATTR_SHOW_IN_SETTINGS = "showInSettings";
    private static final String ATTR_SHOW_IN_QUIET_MODE = "showInQuietMode";
    private static final String ATTR_SHOW_IN_SHARING_SURFACES = "showInSharingSurfaces";
    private static final String ATTR_INHERIT_DEVICE_POLICY = "inheritDevicePolicy";
    private static final String ATTR_USE_PARENTS_CONTACTS = "useParentsContacts";
    private static final String ATTR_UPDATE_CROSS_PROFILE_INTENT_FILTERS_ON_OTA = "updateCrossProfileIntentFiltersOnOTA";
    private static final String ATTR_CROSS_PROFILE_INTENT_FILTER_ACCESS_CONTROL = "crossProfileIntentFilterAccessControl";
    private static final String ATTR_CROSS_PROFILE_INTENT_RESOLUTION_STRATEGY = "crossProfileIntentResolutionStrategy";
    private static final String ATTR_MEDIA_SHARED_WITH_PARENT = "mediaSharedWithParent";
    private static final String ATTR_CREDENTIAL_SHAREABLE_WITH_PARENT = "credentialShareableWithParent";
    private static final String ATTR_AUTH_ALWAYS_REQUIRED_TO_DISABLE_QUIET_MODE = "authAlwaysRequiredToDisableQuietMode";
    private static final String ATTR_DELETE_APP_WITH_PARENT = "deleteAppWithParent";
    private static final String ATTR_ALWAYS_VISIBLE = "alwaysVisible";
    private static final String ATTR_ALLOW_STOPPING_USER_WITH_DELAYED_LOCKING = "allowStoppingUserWithDelayedLocking";
    private static final String ATTR_CROSS_PROFILE_CONTENT_SHARING_STRATEGY = "crossProfileContentSharingStrategy";
    private static final String ATTR_PROFILE_API_VISIBILITY = "profileApiVisibility";
    private static final String ITEMS_RESTRICTED_ON_HOME_SCREEN = "itemsRestrictedOnHomeScreen";
    private static final int INDEX_SHOW_IN_LAUNCHER = 0;
    private static final int INDEX_START_WITH_PARENT = 1;
    private static final int INDEX_SHOW_IN_SETTINGS = 2;
    private static final int INDEX_INHERIT_DEVICE_POLICY = 3;
    private static final int INDEX_USE_PARENTS_CONTACTS = 4;
    private static final int INDEX_UPDATE_CROSS_PROFILE_INTENT_FILTERS_ON_OTA = 5;
    private static final int INDEX_CROSS_PROFILE_INTENT_FILTER_ACCESS_CONTROL = 6;
    private static final int INDEX_CROSS_PROFILE_INTENT_RESOLUTION_STRATEGY = 7;
    private static final int INDEX_MEDIA_SHARED_WITH_PARENT = 8;
    private static final int INDEX_CREDENTIAL_SHAREABLE_WITH_PARENT = 9;
    private static final int INDEX_DELETE_APP_WITH_PARENT = 10;
    private static final int INDEX_ALWAYS_VISIBLE = 11;
    private static final int INDEX_SHOW_IN_QUIET_MODE = 12;
    private static final int INDEX_AUTH_ALWAYS_REQUIRED_TO_DISABLE_QUIET_MODE = 13;
    private static final int INDEX_SHOW_IN_SHARING_SURFACES = 14;
    private static final int INDEX_CROSS_PROFILE_CONTENT_SHARING_STRATEGY = 15;
    private static final int INDEX_ALLOW_STOPPING_USER_WITH_DELAYED_LOCKING = 16;
    private static final int INDEX_PROFILE_API_VISIBILITY = 17;
    private static final int INDEX_ITEMS_RESTRICTED_ON_HOME_SCREEN = 18;
    private long mPropertiesPresent = 0L;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int SHOW_IN_LAUNCHER_UNKNOWN = -1;
    public static final int SHOW_IN_LAUNCHER_WITH_PARENT = 0;
    public static final int SHOW_IN_LAUNCHER_SEPARATE = 1;
    public static final int SHOW_IN_LAUNCHER_NO = 2;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int SHOW_IN_SETTINGS_UNKNOWN = -1;
    public static final int SHOW_IN_SETTINGS_WITH_PARENT = 0;
    public static final int SHOW_IN_SETTINGS_SEPARATE = 1;
    public static final int SHOW_IN_SETTINGS_NO = 2;
    public static final int INHERIT_DEVICE_POLICY_NO = 0;
    public static final int INHERIT_DEVICE_POLICY_FROM_PARENT = 1;
    @Nullable
    private final UserProperties mDefaultProperties;
    public static final int CROSS_PROFILE_INTENT_FILTER_ACCESS_LEVEL_ALL = 0;
    public static final int CROSS_PROFILE_INTENT_FILTER_ACCESS_LEVEL_SYSTEM = 10;
    public static final int CROSS_PROFILE_INTENT_FILTER_ACCESS_LEVEL_SYSTEM_ADD_ONLY = 20;
    public static final int CROSS_PROFILE_INTENT_RESOLUTION_STRATEGY_DEFAULT = 0;
    public static final int CROSS_PROFILE_INTENT_RESOLUTION_STRATEGY_NO_FILTERING = 1;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int SHOW_IN_QUIET_MODE_UNKNOWN = -1;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int SHOW_IN_QUIET_MODE_PAUSED = 0;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int SHOW_IN_QUIET_MODE_HIDDEN = 1;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int SHOW_IN_QUIET_MODE_DEFAULT = 2;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int SHOW_IN_SHARING_SURFACES_UNKNOWN = -1;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int SHOW_IN_SHARING_SURFACES_WITH_PARENT = 0;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int SHOW_IN_SHARING_SURFACES_SEPARATE = 1;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int SHOW_IN_SHARING_SURFACES_NO = 2;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int CROSS_PROFILE_CONTENT_SHARING_UNKNOWN = -1;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int CROSS_PROFILE_CONTENT_SHARING_NO_DELEGATION = 0;
    @SuppressLint(value={"UnflaggedApi"})
    public static final int CROSS_PROFILE_CONTENT_SHARING_DELEGATE_FROM_PARENT = 1;
    public static final int PROFILE_API_VISIBILITY_UNKNOWN = -1;
    public static final int PROFILE_API_VISIBILITY_VISIBLE = 0;
    public static final int PROFILE_API_VISIBILITY_HIDDEN = 1;
    private int mShowInLauncher;
    private int mShowInSettings;
    private int mShowInQuietMode;
    private int mShowInSharingSurfaces;
    private boolean mStartWithParent;
    private boolean mDeleteAppWithParent;
    private boolean mAlwaysVisible;
    private int mInheritDevicePolicy;
    private boolean mUseParentsContacts;
    private boolean mUpdateCrossProfileIntentFiltersOnOTA;
    private boolean mMediaSharedWithParent;
    private boolean mCredentialShareableWithParent;
    private boolean mAuthAlwaysRequiredToDisableQuietMode;
    private boolean mAllowStoppingUserWithDelayedLocking;
    private int mCrossProfileIntentFilterAccessControl;
    private int mCrossProfileIntentResolutionStrategy;
    private int mCrossProfileContentSharingStrategy;
    private int mProfileApiVisibility;
    private boolean mItemsRestrictedOnHomeScreen;
    @NonNull
    public static final Parcelable.Creator<UserProperties> CREATOR = new Parcelable.Creator<UserProperties>(){

        @Override
        public UserProperties createFromParcel(Parcel source) {
            return new UserProperties(source);
        }

        public UserProperties[] newArray(int size) {
            return new UserProperties[size];
        }
    };

    public UserProperties(@NonNull UserProperties defaultProperties) {
        this.mDefaultProperties = defaultProperties;
        this.mPropertiesPresent = 0L;
    }

    @SuppressLint(value={"MissingPermission"})
    public UserProperties(UserProperties orig, boolean exposeAllFields, boolean hasManagePermission, boolean hasQueryOrManagePermission) {
        if (orig.mDefaultProperties == null) {
            throw new IllegalArgumentException("Attempting to copy a non-original UserProperties.");
        }
        this.mDefaultProperties = null;
        if (exposeAllFields) {
            this.setStartWithParent(orig.getStartWithParent());
            this.setInheritDevicePolicy(orig.getInheritDevicePolicy());
            this.setUpdateCrossProfileIntentFiltersOnOTA(orig.getUpdateCrossProfileIntentFiltersOnOTA());
            this.setCrossProfileIntentFilterAccessControl(orig.getCrossProfileIntentFilterAccessControl());
            this.setCrossProfileIntentResolutionStrategy(orig.getCrossProfileIntentResolutionStrategy());
            this.setDeleteAppWithParent(orig.getDeleteAppWithParent());
            this.setAlwaysVisible(orig.getAlwaysVisible());
            this.setAllowStoppingUserWithDelayedLocking(orig.getAllowStoppingUserWithDelayedLocking());
        }
        if (hasManagePermission) {
            this.setShowInSettings(orig.getShowInSettings());
            this.setUseParentsContacts(orig.getUseParentsContacts());
            this.setAuthAlwaysRequiredToDisableQuietMode(orig.isAuthAlwaysRequiredToDisableQuietMode());
        }
        if (hasQueryOrManagePermission) {
            // empty if block
        }
        this.setShowInLauncher(orig.getShowInLauncher());
        this.setMediaSharedWithParent(orig.isMediaSharedWithParent());
        this.setCredentialShareableWithParent(orig.isCredentialShareableWithParent());
        this.setShowInQuietMode(orig.getShowInQuietMode());
        this.setShowInSharingSurfaces(orig.getShowInSharingSurfaces());
        this.setCrossProfileContentSharingStrategy(orig.getCrossProfileContentSharingStrategy());
        this.setProfileApiVisibility(orig.getProfileApiVisibility());
        this.setItemsRestrictedOnHomeScreen(orig.areItemsRestrictedOnHomeScreen());
    }

    private boolean isPresent(long index) {
        return (this.mPropertiesPresent & 1L << (int)index) != 0L;
    }

    private void setPresent(long index) {
        this.mPropertiesPresent |= 1L << (int)index;
    }

    @VisibleForTesting
    public long getPropertiesPresent() {
        return this.mPropertiesPresent;
    }

    public int getShowInLauncher() {
        if (this.isPresent(0L)) {
            return this.mShowInLauncher;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mShowInLauncher;
        }
        throw new SecurityException("You don't have permission to query showInLauncher");
    }

    public void setShowInLauncher(int val) {
        this.mShowInLauncher = val;
        this.setPresent(0L);
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public int getShowInSettings() {
        if (this.isPresent(2L)) {
            return this.mShowInSettings;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mShowInSettings;
        }
        throw new SecurityException("You don't have permission to query mShowInSettings");
    }

    public void setShowInSettings(int val) {
        this.mShowInSettings = val;
        this.setPresent(2L);
    }

    @SuppressLint(value={"UnflaggedApi"})
    public int getShowInQuietMode() {
        if (this.isPresent(12L)) {
            return this.mShowInQuietMode;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mShowInQuietMode;
        }
        throw new SecurityException("You don't have permission to query ShowInQuietMode");
    }

    public void setShowInQuietMode(int showInQuietMode) {
        this.mShowInQuietMode = showInQuietMode;
        this.setPresent(12L);
    }

    @SuppressLint(value={"UnflaggedApi"})
    public int getShowInSharingSurfaces() {
        if (this.isPresent(14L)) {
            return this.mShowInSharingSurfaces;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mShowInSharingSurfaces;
        }
        throw new SecurityException("You don't have permission to query ShowInSharingSurfaces");
    }

    public void setShowInSharingSurfaces(int showInSharingSurfaces) {
        this.mShowInSharingSurfaces = showInSharingSurfaces;
        this.setPresent(14L);
    }

    public boolean getStartWithParent() {
        if (this.isPresent(1L)) {
            return this.mStartWithParent;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mStartWithParent;
        }
        throw new SecurityException("You don't have permission to query startWithParent");
    }

    public void setStartWithParent(boolean val) {
        this.mStartWithParent = val;
        this.setPresent(1L);
    }

    public boolean getDeleteAppWithParent() {
        if (this.isPresent(10L)) {
            return this.mDeleteAppWithParent;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mDeleteAppWithParent;
        }
        throw new SecurityException("You don't have permission to query deleteAppWithParent");
    }

    public void setDeleteAppWithParent(boolean val) {
        this.mDeleteAppWithParent = val;
        this.setPresent(10L);
    }

    public boolean getAlwaysVisible() {
        if (this.isPresent(11L)) {
            return this.mAlwaysVisible;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mAlwaysVisible;
        }
        throw new SecurityException("You don't have permission to query alwaysVisible");
    }

    public void setAlwaysVisible(boolean val) {
        this.mAlwaysVisible = val;
        this.setPresent(11L);
    }

    public int getInheritDevicePolicy() {
        if (this.isPresent(3L)) {
            return this.mInheritDevicePolicy;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mInheritDevicePolicy;
        }
        throw new SecurityException("You don't have permission to query inheritDevicePolicy");
    }

    public void setInheritDevicePolicy(int val) {
        this.mInheritDevicePolicy = val;
        this.setPresent(3L);
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean getUseParentsContacts() {
        if (this.isPresent(4L)) {
            return this.mUseParentsContacts;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mUseParentsContacts;
        }
        throw new SecurityException("You don't have permission to query useParentsContacts");
    }

    public void setUseParentsContacts(boolean val) {
        this.mUseParentsContacts = val;
        this.setPresent(4L);
    }

    public boolean getUpdateCrossProfileIntentFiltersOnOTA() {
        if (this.isPresent(5L)) {
            return this.mUpdateCrossProfileIntentFiltersOnOTA;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mUpdateCrossProfileIntentFiltersOnOTA;
        }
        throw new SecurityException("You don't have permission to query updateCrossProfileIntentFiltersOnOTA");
    }

    public void setUpdateCrossProfileIntentFiltersOnOTA(boolean val) {
        this.mUpdateCrossProfileIntentFiltersOnOTA = val;
        this.setPresent(5L);
    }

    public boolean isMediaSharedWithParent() {
        if (this.isPresent(8L)) {
            return this.mMediaSharedWithParent;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mMediaSharedWithParent;
        }
        throw new SecurityException("You don't have permission to query mediaSharedWithParent");
    }

    public void setMediaSharedWithParent(boolean val) {
        this.mMediaSharedWithParent = val;
        this.setPresent(8L);
    }

    public boolean isCredentialShareableWithParent() {
        if (this.isPresent(9L)) {
            return this.mCredentialShareableWithParent;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mCredentialShareableWithParent;
        }
        throw new SecurityException("You don't have permission to query credentialShareableWithParent");
    }

    public void setCredentialShareableWithParent(boolean val) {
        this.mCredentialShareableWithParent = val;
        this.setPresent(9L);
    }

    @RequiresPermission(value="android.permission.MANAGE_USERS")
    public boolean isAuthAlwaysRequiredToDisableQuietMode() {
        if (this.isPresent(13L)) {
            return this.mAuthAlwaysRequiredToDisableQuietMode;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mAuthAlwaysRequiredToDisableQuietMode;
        }
        throw new SecurityException("You don't have permission to query authAlwaysRequiredToDisableQuietMode");
    }

    public void setAuthAlwaysRequiredToDisableQuietMode(boolean val) {
        this.mAuthAlwaysRequiredToDisableQuietMode = val;
        this.setPresent(13L);
    }

    public boolean getAllowStoppingUserWithDelayedLocking() {
        if (this.isPresent(16L)) {
            return this.mAllowStoppingUserWithDelayedLocking;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mAllowStoppingUserWithDelayedLocking;
        }
        throw new SecurityException("You don't have permission to query allowStoppingUserWithDelayedLocking");
    }

    public void setAllowStoppingUserWithDelayedLocking(boolean val) {
        this.mAllowStoppingUserWithDelayedLocking = val;
        this.setPresent(16L);
    }

    public int getCrossProfileIntentFilterAccessControl() {
        if (this.isPresent(6L)) {
            return this.mCrossProfileIntentFilterAccessControl;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mCrossProfileIntentFilterAccessControl;
        }
        throw new SecurityException("You don't have permission to query crossProfileIntentFilterAccessControl");
    }

    public void setCrossProfileIntentFilterAccessControl(int val) {
        this.mCrossProfileIntentFilterAccessControl = val;
        this.setPresent(6L);
    }

    public int getCrossProfileIntentResolutionStrategy() {
        if (this.isPresent(7L)) {
            return this.mCrossProfileIntentResolutionStrategy;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mCrossProfileIntentResolutionStrategy;
        }
        throw new SecurityException("You don't have permission to query crossProfileIntentResolutionStrategy");
    }

    public void setCrossProfileIntentResolutionStrategy(int val) {
        this.mCrossProfileIntentResolutionStrategy = val;
        this.setPresent(7L);
    }

    @SuppressLint(value={"UnflaggedApi"})
    public int getCrossProfileContentSharingStrategy() {
        if (this.isPresent(15L)) {
            return this.mCrossProfileContentSharingStrategy;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mCrossProfileContentSharingStrategy;
        }
        throw new SecurityException("You don't have permission to query crossProfileContentSharingStrategy");
    }

    public void setCrossProfileContentSharingStrategy(int val) {
        this.mCrossProfileContentSharingStrategy = val;
        this.setPresent(15L);
    }

    @NonNull
    public int getProfileApiVisibility() {
        if (this.isPresent(17L)) {
            return this.mProfileApiVisibility;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mProfileApiVisibility;
        }
        throw new SecurityException("You don't have permission to query profileApiVisibility");
    }

    @NonNull
    public void setProfileApiVisibility(int profileApiVisibility) {
        this.mProfileApiVisibility = profileApiVisibility;
        this.setPresent(17L);
    }

    public boolean areItemsRestrictedOnHomeScreen() {
        if (this.isPresent(18L)) {
            return this.mItemsRestrictedOnHomeScreen;
        }
        if (this.mDefaultProperties != null) {
            return this.mDefaultProperties.mItemsRestrictedOnHomeScreen;
        }
        throw new SecurityException("You don't have permission to query mItemsRestrictedOnHomeScreen");
    }

    public void setItemsRestrictedOnHomeScreen(boolean val) {
        this.mItemsRestrictedOnHomeScreen = val;
        this.setPresent(18L);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("UserProperties{");
        s.append("mPropertiesPresent=");
        s.append(Long.toBinaryString(this.mPropertiesPresent));
        try {
            s.append((CharSequence)this.listPropertiesAsStringBuilder());
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        s.append("}");
        return s.toString();
    }

    private StringBuilder listPropertiesAsStringBuilder() {
        StringBuilder s = new StringBuilder();
        s.append(", mShowInLauncher=");
        s.append(this.getShowInLauncher());
        s.append(", mStartWithParent=");
        s.append(this.getStartWithParent());
        s.append(", mShowInSettings=");
        s.append(this.getShowInSettings());
        s.append(", mInheritDevicePolicy=");
        s.append(this.getInheritDevicePolicy());
        s.append(", mUseParentsContacts=");
        s.append(this.getUseParentsContacts());
        s.append(", mUpdateCrossProfileIntentFiltersOnOTA=");
        s.append(this.getUpdateCrossProfileIntentFiltersOnOTA());
        s.append(", mCrossProfileIntentFilterAccessControl=");
        s.append(this.getCrossProfileIntentFilterAccessControl());
        s.append(", mCrossProfileIntentResolutionStrategy=");
        s.append(this.getCrossProfileIntentResolutionStrategy());
        s.append(", mMediaSharedWithParent=");
        s.append(this.isMediaSharedWithParent());
        s.append(", mCredentialShareableWithParent=");
        s.append(this.isCredentialShareableWithParent());
        s.append(", mAuthAlwaysRequiredToDisableQuietMode=");
        s.append(this.isAuthAlwaysRequiredToDisableQuietMode());
        s.append(", mAllowStoppingUserWithDelayedLocking=");
        s.append(this.getAllowStoppingUserWithDelayedLocking());
        s.append(", mDeleteAppWithParent=");
        s.append(this.getDeleteAppWithParent());
        s.append(", mAlwaysVisible=");
        s.append(this.getAlwaysVisible());
        s.append(", mCrossProfileContentSharingStrategy=");
        s.append(this.getCrossProfileContentSharingStrategy());
        s.append(", mProfileApiVisibility=");
        s.append(this.getProfileApiVisibility());
        s.append(", mItemsRestrictedOnHomeScreen=");
        s.append(this.areItemsRestrictedOnHomeScreen());
        return s;
    }

    public void println(PrintWriter pw, String prefix) {
        pw.println(prefix + "UserProperties:");
        pw.println(prefix + "    mPropertiesPresent=" + Long.toBinaryString(this.mPropertiesPresent));
        pw.println(prefix + "    mShowInLauncher=" + this.getShowInLauncher());
        pw.println(prefix + "    mStartWithParent=" + this.getStartWithParent());
        pw.println(prefix + "    mShowInSettings=" + this.getShowInSettings());
        pw.println(prefix + "    mInheritDevicePolicy=" + this.getInheritDevicePolicy());
        pw.println(prefix + "    mUseParentsContacts=" + this.getUseParentsContacts());
        pw.println(prefix + "    mUpdateCrossProfileIntentFiltersOnOTA=" + this.getUpdateCrossProfileIntentFiltersOnOTA());
        pw.println(prefix + "    mCrossProfileIntentFilterAccessControl=" + this.getCrossProfileIntentFilterAccessControl());
        pw.println(prefix + "    mCrossProfileIntentResolutionStrategy=" + this.getCrossProfileIntentResolutionStrategy());
        pw.println(prefix + "    mMediaSharedWithParent=" + this.isMediaSharedWithParent());
        pw.println(prefix + "    mCredentialShareableWithParent=" + this.isCredentialShareableWithParent());
        pw.println(prefix + "    mAuthAlwaysRequiredToDisableQuietMode=" + this.isAuthAlwaysRequiredToDisableQuietMode());
        pw.println(prefix + "    mAllowStoppingUserWithDelayedLocking=" + this.getAllowStoppingUserWithDelayedLocking());
        pw.println(prefix + "    mDeleteAppWithParent=" + this.getDeleteAppWithParent());
        pw.println(prefix + "    mAlwaysVisible=" + this.getAlwaysVisible());
        pw.println(prefix + "    mCrossProfileContentSharingStrategy=" + this.getCrossProfileContentSharingStrategy());
        pw.println(prefix + "    mProfileApiVisibility=" + this.getProfileApiVisibility());
        pw.println(prefix + "    mItemsRestrictedOnHomeScreen=" + this.areItemsRestrictedOnHomeScreen());
    }

    public UserProperties(TypedXmlPullParser parser, @NonNull UserProperties defaultUserPropertiesReference) throws IOException, XmlPullParserException {
        this(defaultUserPropertiesReference);
        this.updateFromXml(parser);
    }

    public void updateFromXml(TypedXmlPullParser parser) throws IOException, XmlPullParserException {
        int attributeCount = parser.getAttributeCount();
        block42: for (int i = 0; i < attributeCount; ++i) {
            String attributeName;
            switch (attributeName = parser.getAttributeName(i)) {
                case "showInLauncher": {
                    this.setShowInLauncher(parser.getAttributeInt(i));
                    continue block42;
                }
                case "startWithParent": {
                    this.setStartWithParent(parser.getAttributeBoolean(i));
                    continue block42;
                }
                case "showInSettings": {
                    this.setShowInSettings(parser.getAttributeInt(i));
                    continue block42;
                }
                case "showInQuietMode": {
                    this.setShowInQuietMode(parser.getAttributeInt(i));
                    continue block42;
                }
                case "showInSharingSurfaces": {
                    this.setShowInSharingSurfaces(parser.getAttributeInt(i));
                    continue block42;
                }
                case "inheritDevicePolicy": {
                    this.setInheritDevicePolicy(parser.getAttributeInt(i));
                    continue block42;
                }
                case "useParentsContacts": {
                    this.setUseParentsContacts(parser.getAttributeBoolean(i));
                    continue block42;
                }
                case "updateCrossProfileIntentFiltersOnOTA": {
                    this.setUpdateCrossProfileIntentFiltersOnOTA(parser.getAttributeBoolean(i));
                    continue block42;
                }
                case "crossProfileIntentFilterAccessControl": {
                    this.setCrossProfileIntentFilterAccessControl(parser.getAttributeInt(i));
                    continue block42;
                }
                case "crossProfileIntentResolutionStrategy": {
                    this.setCrossProfileIntentResolutionStrategy(parser.getAttributeInt(i));
                    continue block42;
                }
                case "mediaSharedWithParent": {
                    this.setMediaSharedWithParent(parser.getAttributeBoolean(i));
                    continue block42;
                }
                case "credentialShareableWithParent": {
                    this.setCredentialShareableWithParent(parser.getAttributeBoolean(i));
                    continue block42;
                }
                case "authAlwaysRequiredToDisableQuietMode": {
                    this.setAuthAlwaysRequiredToDisableQuietMode(parser.getAttributeBoolean(i));
                    continue block42;
                }
                case "allowStoppingUserWithDelayedLocking": {
                    this.setAllowStoppingUserWithDelayedLocking(parser.getAttributeBoolean(i));
                    continue block42;
                }
                case "deleteAppWithParent": {
                    this.setDeleteAppWithParent(parser.getAttributeBoolean(i));
                    continue block42;
                }
                case "alwaysVisible": {
                    this.setAlwaysVisible(parser.getAttributeBoolean(i));
                    continue block42;
                }
                case "crossProfileContentSharingStrategy": {
                    this.setCrossProfileContentSharingStrategy(parser.getAttributeInt(i));
                    continue block42;
                }
                case "profileApiVisibility": {
                    this.setProfileApiVisibility(parser.getAttributeInt(i));
                    continue block42;
                }
                case "itemsRestrictedOnHomeScreen": {
                    this.setItemsRestrictedOnHomeScreen(parser.getAttributeBoolean(i));
                    continue block42;
                }
                default: {
                    Slog.w(LOG_TAG, "Skipping unknown property " + attributeName);
                }
            }
        }
    }

    public void writeToXml(TypedXmlSerializer serializer) throws IOException, XmlPullParserException {
        if (this.isPresent(0L)) {
            serializer.attributeInt(null, ATTR_SHOW_IN_LAUNCHER, this.mShowInLauncher);
        }
        if (this.isPresent(1L)) {
            serializer.attributeBoolean(null, ATTR_START_WITH_PARENT, this.mStartWithParent);
        }
        if (this.isPresent(2L)) {
            serializer.attributeInt(null, ATTR_SHOW_IN_SETTINGS, this.mShowInSettings);
        }
        if (this.isPresent(12L)) {
            serializer.attributeInt(null, ATTR_SHOW_IN_QUIET_MODE, this.mShowInQuietMode);
        }
        if (this.isPresent(14L)) {
            serializer.attributeInt(null, ATTR_SHOW_IN_SHARING_SURFACES, this.mShowInSharingSurfaces);
        }
        if (this.isPresent(3L)) {
            serializer.attributeInt(null, ATTR_INHERIT_DEVICE_POLICY, this.mInheritDevicePolicy);
        }
        if (this.isPresent(4L)) {
            serializer.attributeBoolean(null, ATTR_USE_PARENTS_CONTACTS, this.mUseParentsContacts);
        }
        if (this.isPresent(5L)) {
            serializer.attributeBoolean(null, ATTR_UPDATE_CROSS_PROFILE_INTENT_FILTERS_ON_OTA, this.mUpdateCrossProfileIntentFiltersOnOTA);
        }
        if (this.isPresent(6L)) {
            serializer.attributeInt(null, ATTR_CROSS_PROFILE_INTENT_FILTER_ACCESS_CONTROL, this.mCrossProfileIntentFilterAccessControl);
        }
        if (this.isPresent(7L)) {
            serializer.attributeInt(null, ATTR_CROSS_PROFILE_INTENT_RESOLUTION_STRATEGY, this.mCrossProfileIntentResolutionStrategy);
        }
        if (this.isPresent(8L)) {
            serializer.attributeBoolean(null, ATTR_MEDIA_SHARED_WITH_PARENT, this.mMediaSharedWithParent);
        }
        if (this.isPresent(9L)) {
            serializer.attributeBoolean(null, ATTR_CREDENTIAL_SHAREABLE_WITH_PARENT, this.mCredentialShareableWithParent);
        }
        if (this.isPresent(13L)) {
            serializer.attributeBoolean(null, ATTR_AUTH_ALWAYS_REQUIRED_TO_DISABLE_QUIET_MODE, this.mAuthAlwaysRequiredToDisableQuietMode);
        }
        if (this.isPresent(16L)) {
            serializer.attributeBoolean(null, ATTR_ALLOW_STOPPING_USER_WITH_DELAYED_LOCKING, this.mAllowStoppingUserWithDelayedLocking);
        }
        if (this.isPresent(10L)) {
            serializer.attributeBoolean(null, ATTR_DELETE_APP_WITH_PARENT, this.mDeleteAppWithParent);
        }
        if (this.isPresent(11L)) {
            serializer.attributeBoolean(null, ATTR_ALWAYS_VISIBLE, this.mAlwaysVisible);
        }
        if (this.isPresent(15L)) {
            serializer.attributeInt(null, ATTR_CROSS_PROFILE_CONTENT_SHARING_STRATEGY, this.mCrossProfileContentSharingStrategy);
        }
        if (this.isPresent(17L)) {
            serializer.attributeInt(null, ATTR_PROFILE_API_VISIBILITY, this.mProfileApiVisibility);
        }
        if (this.isPresent(18L)) {
            serializer.attributeBoolean(null, ITEMS_RESTRICTED_ON_HOME_SCREEN, this.mItemsRestrictedOnHomeScreen);
        }
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int parcelableFlags) {
        dest.writeLong(this.mPropertiesPresent);
        dest.writeInt(this.mShowInLauncher);
        dest.writeBoolean(this.mStartWithParent);
        dest.writeInt(this.mShowInSettings);
        dest.writeInt(this.mShowInQuietMode);
        dest.writeInt(this.mShowInSharingSurfaces);
        dest.writeInt(this.mInheritDevicePolicy);
        dest.writeBoolean(this.mUseParentsContacts);
        dest.writeBoolean(this.mUpdateCrossProfileIntentFiltersOnOTA);
        dest.writeInt(this.mCrossProfileIntentFilterAccessControl);
        dest.writeInt(this.mCrossProfileIntentResolutionStrategy);
        dest.writeBoolean(this.mMediaSharedWithParent);
        dest.writeBoolean(this.mCredentialShareableWithParent);
        dest.writeBoolean(this.mAuthAlwaysRequiredToDisableQuietMode);
        dest.writeBoolean(this.mAllowStoppingUserWithDelayedLocking);
        dest.writeBoolean(this.mDeleteAppWithParent);
        dest.writeBoolean(this.mAlwaysVisible);
        dest.writeInt(this.mCrossProfileContentSharingStrategy);
        dest.writeInt(this.mProfileApiVisibility);
        dest.writeBoolean(this.mItemsRestrictedOnHomeScreen);
    }

    private UserProperties(@NonNull Parcel source) {
        this.mDefaultProperties = null;
        this.mPropertiesPresent = source.readLong();
        this.mShowInLauncher = source.readInt();
        this.mStartWithParent = source.readBoolean();
        this.mShowInSettings = source.readInt();
        this.mShowInQuietMode = source.readInt();
        this.mShowInSharingSurfaces = source.readInt();
        this.mInheritDevicePolicy = source.readInt();
        this.mUseParentsContacts = source.readBoolean();
        this.mUpdateCrossProfileIntentFiltersOnOTA = source.readBoolean();
        this.mCrossProfileIntentFilterAccessControl = source.readInt();
        this.mCrossProfileIntentResolutionStrategy = source.readInt();
        this.mMediaSharedWithParent = source.readBoolean();
        this.mCredentialShareableWithParent = source.readBoolean();
        this.mAuthAlwaysRequiredToDisableQuietMode = source.readBoolean();
        this.mAllowStoppingUserWithDelayedLocking = source.readBoolean();
        this.mDeleteAppWithParent = source.readBoolean();
        this.mAlwaysVisible = source.readBoolean();
        this.mCrossProfileContentSharingStrategy = source.readInt();
        this.mProfileApiVisibility = source.readInt();
        this.mItemsRestrictedOnHomeScreen = source.readBoolean();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    private UserProperties(int showInLauncher, boolean startWithParent, int showInSettings, int showInQuietMode, int showInSharingSurfaces, int inheritDevicePolicy, boolean useParentsContacts, boolean updateCrossProfileIntentFiltersOnOTA, int crossProfileIntentFilterAccessControl, int crossProfileIntentResolutionStrategy, boolean mediaSharedWithParent, boolean credentialShareableWithParent, boolean authAlwaysRequiredToDisableQuietMode, boolean allowStoppingUserWithDelayedLocking, boolean deleteAppWithParent, boolean alwaysVisible, int crossProfileContentSharingStrategy, int profileApiVisibility, boolean itemsRestrictedOnHomeScreen) {
        this.mDefaultProperties = null;
        this.setShowInLauncher(showInLauncher);
        this.setStartWithParent(startWithParent);
        this.setShowInSettings(showInSettings);
        this.setShowInQuietMode(showInQuietMode);
        this.setShowInSharingSurfaces(showInSharingSurfaces);
        this.setInheritDevicePolicy(inheritDevicePolicy);
        this.setUseParentsContacts(useParentsContacts);
        this.setUpdateCrossProfileIntentFiltersOnOTA(updateCrossProfileIntentFiltersOnOTA);
        this.setCrossProfileIntentFilterAccessControl(crossProfileIntentFilterAccessControl);
        this.setCrossProfileIntentResolutionStrategy(crossProfileIntentResolutionStrategy);
        this.setMediaSharedWithParent(mediaSharedWithParent);
        this.setCredentialShareableWithParent(credentialShareableWithParent);
        this.setAuthAlwaysRequiredToDisableQuietMode(authAlwaysRequiredToDisableQuietMode);
        this.setAllowStoppingUserWithDelayedLocking(allowStoppingUserWithDelayedLocking);
        this.setDeleteAppWithParent(deleteAppWithParent);
        this.setAlwaysVisible(alwaysVisible);
        this.setCrossProfileContentSharingStrategy(crossProfileContentSharingStrategy);
        this.setProfileApiVisibility(profileApiVisibility);
        this.setItemsRestrictedOnHomeScreen(itemsRestrictedOnHomeScreen);
    }

    @SuppressLint(value={"UnflaggedApi"})
    public static class Builder {
        private int mShowInLauncher = 0;
        private boolean mStartWithParent = false;
        private int mShowInSettings = 0;
        private int mShowInQuietMode = 0;
        private int mShowInSharingSurfaces = 1;
        private int mInheritDevicePolicy = 0;
        private boolean mUseParentsContacts = false;
        private boolean mUpdateCrossProfileIntentFiltersOnOTA = false;
        private int mCrossProfileIntentFilterAccessControl = 0;
        private int mCrossProfileIntentResolutionStrategy = 0;
        private boolean mMediaSharedWithParent = false;
        private boolean mCredentialShareableWithParent = false;
        private boolean mAuthAlwaysRequiredToDisableQuietMode = false;
        private boolean mAllowStoppingUserWithDelayedLocking = false;
        private boolean mDeleteAppWithParent = false;
        private boolean mAlwaysVisible = false;
        private int mCrossProfileContentSharingStrategy = 0;
        private int mProfileApiVisibility = 0;
        private boolean mItemsRestrictedOnHomeScreen = false;

        @SuppressLint(value={"UnflaggedApi"})
        public Builder() {
        }

        public Builder setShowInLauncher(int showInLauncher) {
            this.mShowInLauncher = showInLauncher;
            return this;
        }

        public Builder setStartWithParent(boolean startWithParent) {
            this.mStartWithParent = startWithParent;
            return this;
        }

        public Builder setShowInSettings(int showInSettings) {
            this.mShowInSettings = showInSettings;
            return this;
        }

        @SuppressLint(value={"UnflaggedApi"})
        @NonNull
        public Builder setShowInQuietMode(int showInQuietMode) {
            this.mShowInQuietMode = showInQuietMode;
            return this;
        }

        @SuppressLint(value={"UnflaggedApi"})
        @NonNull
        public Builder setShowInSharingSurfaces(int showInSharingSurfaces) {
            this.mShowInSharingSurfaces = showInSharingSurfaces;
            return this;
        }

        public Builder setInheritDevicePolicy(int inheritRestrictionsDevicePolicy) {
            this.mInheritDevicePolicy = inheritRestrictionsDevicePolicy;
            return this;
        }

        public Builder setUseParentsContacts(boolean useParentsContacts) {
            this.mUseParentsContacts = useParentsContacts;
            return this;
        }

        public Builder setUpdateCrossProfileIntentFiltersOnOTA(boolean updateCrossProfileIntentFiltersOnOTA) {
            this.mUpdateCrossProfileIntentFiltersOnOTA = updateCrossProfileIntentFiltersOnOTA;
            return this;
        }

        public Builder setCrossProfileIntentFilterAccessControl(int crossProfileIntentFilterAccessControl) {
            this.mCrossProfileIntentFilterAccessControl = crossProfileIntentFilterAccessControl;
            return this;
        }

        public Builder setCrossProfileIntentResolutionStrategy(int crossProfileIntentResolutionStrategy) {
            this.mCrossProfileIntentResolutionStrategy = crossProfileIntentResolutionStrategy;
            return this;
        }

        public Builder setMediaSharedWithParent(boolean mediaSharedWithParent) {
            this.mMediaSharedWithParent = mediaSharedWithParent;
            return this;
        }

        public Builder setCredentialShareableWithParent(boolean credentialShareableWithParent) {
            this.mCredentialShareableWithParent = credentialShareableWithParent;
            return this;
        }

        public Builder setAuthAlwaysRequiredToDisableQuietMode(boolean authAlwaysRequiredToDisableQuietMode) {
            this.mAuthAlwaysRequiredToDisableQuietMode = authAlwaysRequiredToDisableQuietMode;
            return this;
        }

        public Builder setAllowStoppingUserWithDelayedLocking(boolean allowStoppingUserWithDelayedLocking) {
            this.mAllowStoppingUserWithDelayedLocking = allowStoppingUserWithDelayedLocking;
            return this;
        }

        public Builder setDeleteAppWithParent(boolean deleteAppWithParent) {
            this.mDeleteAppWithParent = deleteAppWithParent;
            return this;
        }

        public Builder setAlwaysVisible(boolean alwaysVisible) {
            this.mAlwaysVisible = alwaysVisible;
            return this;
        }

        @SuppressLint(value={"UnflaggedApi"})
        @NonNull
        public Builder setCrossProfileContentSharingStrategy(int crossProfileContentSharingStrategy) {
            this.mCrossProfileContentSharingStrategy = crossProfileContentSharingStrategy;
            return this;
        }

        @NonNull
        public Builder setProfileApiVisibility(int profileApiVisibility) {
            this.mProfileApiVisibility = profileApiVisibility;
            return this;
        }

        public Builder setItemsRestrictedOnHomeScreen(boolean itemsRestrictedOnHomeScreen) {
            this.mItemsRestrictedOnHomeScreen = itemsRestrictedOnHomeScreen;
            return this;
        }

        @SuppressLint(value={"UnflaggedApi"})
        @NonNull
        public UserProperties build() {
            return new UserProperties(this.mShowInLauncher, this.mStartWithParent, this.mShowInSettings, this.mShowInQuietMode, this.mShowInSharingSurfaces, this.mInheritDevicePolicy, this.mUseParentsContacts, this.mUpdateCrossProfileIntentFiltersOnOTA, this.mCrossProfileIntentFilterAccessControl, this.mCrossProfileIntentResolutionStrategy, this.mMediaSharedWithParent, this.mCredentialShareableWithParent, this.mAuthAlwaysRequiredToDisableQuietMode, this.mAllowStoppingUserWithDelayedLocking, this.mDeleteAppWithParent, this.mAlwaysVisible, this.mCrossProfileContentSharingStrategy, this.mProfileApiVisibility, this.mItemsRestrictedOnHomeScreen);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProfileApiVisibility {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CrossProfileContentSharingStrategy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShowInSharingSurfaces {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShowInQuietMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CrossProfileIntentResolutionStrategy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CrossProfileIntentFilterAccessControlLevel {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InheritDevicePolicy {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShowInSettings {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShowInLauncher {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    private static @interface PropertyIndex {
    }
}

