/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.content.pm.SignedPackageParcel;
import java.util.Arrays;
import java.util.Objects;

@SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
@FlaggedApi(value="android.permission.flags.enhanced_confirmation_mode_apis_enabled")
public class SignedPackage {
    @NonNull
    private final SignedPackageParcel mData;

    public SignedPackage(@NonNull String packageName, @NonNull byte[] certificateDigest) {
        SignedPackageParcel data = new SignedPackageParcel();
        data.packageName = packageName;
        data.certificateDigest = certificateDigest;
        this.mData = data;
    }

    public SignedPackage(@NonNull SignedPackageParcel data) {
        this.mData = data;
    }

    @NonNull
    public SignedPackageParcel getData() {
        return this.mData;
    }

    @NonNull
    public String getPackageName() {
        return this.mData.packageName;
    }

    @NonNull
    public byte[] getCertificateDigest() {
        return this.mData.certificateDigest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SignedPackage)) {
            return false;
        }
        SignedPackage that = (SignedPackage)o;
        return this.mData.packageName.equals(that.mData.packageName) && Arrays.equals(this.mData.certificateDigest, that.mData.certificateDigest);
    }

    public int hashCode() {
        return Objects.hash(this.mData.packageName, Arrays.hashCode(this.mData.certificateDigest));
    }
}

