/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.pm.VersionedPackage;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Pair;
import com.android.internal.hidden_from_bootclasspath.android.content.pm.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class SharedLibraryInfo
implements Parcelable {
    public static final int TYPE_BUILTIN = 0;
    public static final int TYPE_DYNAMIC = 1;
    public static final int TYPE_STATIC = 2;
    public static final int TYPE_SDK_PACKAGE = 3;
    public static final int VERSION_UNDEFINED = -1;
    private final String mPath;
    private final String mPackageName;
    private final String mName;
    private List<String> mCodePaths;
    private final long mVersion;
    private final int mType;
    private final boolean mIsNative;
    private final VersionedPackage mDeclaringPackage;
    private final List<VersionedPackage> mDependentPackages;
    private final List<VersionedPackage> mOptionalDependentPackages;
    private List<SharedLibraryInfo> mDependencies;
    private final List<String> mCertDigests;
    @NonNull
    public static final Parcelable.Creator<SharedLibraryInfo> CREATOR = new Parcelable.Creator<SharedLibraryInfo>(){

        @Override
        public SharedLibraryInfo createFromParcel(Parcel source) {
            return new SharedLibraryInfo(source);
        }

        public SharedLibraryInfo[] newArray(int size) {
            return new SharedLibraryInfo[size];
        }
    };

    public SharedLibraryInfo(String path, String packageName, List<String> codePaths, String name, long version, int type, VersionedPackage declaringPackage, List<VersionedPackage> dependentPackages, List<SharedLibraryInfo> dependencies, boolean isNative) {
        this.mPath = path;
        this.mPackageName = packageName;
        this.mCodePaths = codePaths;
        this.mName = name;
        this.mVersion = version;
        this.mType = type;
        this.mDeclaringPackage = declaringPackage;
        this.mDependentPackages = dependentPackages;
        this.mDependencies = dependencies;
        this.mIsNative = isNative;
        this.mOptionalDependentPackages = null;
        this.mCertDigests = null;
    }

    public SharedLibraryInfo(String path, String packageName, List<String> codePaths, String name, long version, int type, VersionedPackage declaringPackage, List<SharedLibraryInfo> dependencies, boolean isNative, Pair<List<VersionedPackage>, List<Boolean>> allDependentPackages) {
        this.mPath = path;
        this.mPackageName = packageName;
        this.mCodePaths = codePaths;
        this.mName = name;
        this.mVersion = version;
        this.mType = type;
        this.mDeclaringPackage = declaringPackage;
        this.mDependencies = dependencies;
        this.mIsNative = isNative;
        this.mCertDigests = null;
        List allDependents = (List)allDependentPackages.first;
        List usesLibOptional = (List)allDependentPackages.second;
        this.mDependentPackages = allDependents;
        ArrayList<VersionedPackage> optionalDependents = null;
        if (this.mType == 3 && Flags.sdkLibIndependence() && allDependents != null && usesLibOptional != null && allDependents.size() == usesLibOptional.size()) {
            for (int k = 0; k < allDependents.size(); ++k) {
                VersionedPackage versionedPackage = (VersionedPackage)allDependents.get(k);
                if (!((Boolean)usesLibOptional.get(k)).booleanValue()) continue;
                if (optionalDependents == null) {
                    optionalDependents = new ArrayList<VersionedPackage>();
                }
                optionalDependents.add(versionedPackage);
            }
        }
        this.mOptionalDependentPackages = optionalDependents;
    }

    private SharedLibraryInfo(Parcel parcel) {
        this.mPath = parcel.readString8();
        this.mPackageName = parcel.readString8();
        this.mCodePaths = parcel.readInt() != 0 ? Arrays.asList(parcel.createString8Array()) : null;
        this.mName = parcel.readString8();
        this.mVersion = parcel.readLong();
        this.mType = parcel.readInt();
        this.mDeclaringPackage = parcel.readParcelable(null, VersionedPackage.class);
        this.mDependentPackages = parcel.readArrayList(null, VersionedPackage.class);
        this.mDependencies = parcel.createTypedArrayList(CREATOR);
        this.mIsNative = parcel.readBoolean();
        this.mOptionalDependentPackages = parcel.readParcelableList(new ArrayList(), VersionedPackage.class.getClassLoader(), VersionedPackage.class);
        this.mCertDigests = parcel.createStringArrayList();
    }

    public SharedLibraryInfo(String name, long versionMajor, int type) {
        this.mPath = null;
        this.mPackageName = null;
        this.mName = name;
        this.mVersion = versionMajor;
        this.mType = type;
        this.mDeclaringPackage = null;
        this.mDependentPackages = null;
        this.mDependencies = null;
        this.mIsNative = false;
        this.mOptionalDependentPackages = null;
        this.mCertDigests = null;
    }

    @FlaggedApi(value="android.content.pm.sdk_dependency_installer")
    public SharedLibraryInfo(String name, long versionMajor, int type, List<String> certDigests) {
        this.mPath = null;
        this.mPackageName = null;
        this.mName = name;
        this.mVersion = versionMajor;
        this.mType = type;
        this.mDeclaringPackage = null;
        this.mDependentPackages = null;
        this.mDependencies = null;
        this.mIsNative = false;
        this.mOptionalDependentPackages = null;
        this.mCertDigests = certDigests;
    }

    public int getType() {
        return this.mType;
    }

    public boolean isNative() {
        return this.mIsNative;
    }

    public String getName() {
        return this.mName;
    }

    @Nullable
    public String getPath() {
        return this.mPath;
    }

    @Nullable
    public String getPackageName() {
        return this.mPackageName;
    }

    @NonNull
    public List<String> getAllCodePaths() {
        if (this.getPath() != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.getPath());
            return list;
        }
        return Objects.requireNonNull(this.mCodePaths);
    }

    public void setAllCodePaths(List<String> paths) {
        this.mCodePaths = paths;
    }

    public void addDependency(@Nullable SharedLibraryInfo info) {
        if (info == null) {
            return;
        }
        if (this.mDependencies == null) {
            this.mDependencies = new ArrayList<SharedLibraryInfo>();
        }
        this.mDependencies.add(info);
    }

    public void clearDependencies() {
        this.mDependencies = null;
    }

    @Nullable
    public List<SharedLibraryInfo> getDependencies() {
        return this.mDependencies;
    }

    @Deprecated
    public int getVersion() {
        return this.mVersion < 0L ? (int)this.mVersion : (int)(this.mVersion & Integer.MAX_VALUE);
    }

    public long getLongVersion() {
        return this.mVersion;
    }

    public boolean isBuiltin() {
        return this.mType == 0;
    }

    public boolean isDynamic() {
        return this.mType == 1;
    }

    public boolean isStatic() {
        return this.mType == 2;
    }

    public boolean isSdk() {
        return this.mType == 3;
    }

    @NonNull
    public VersionedPackage getDeclaringPackage() {
        return this.mDeclaringPackage;
    }

    @NonNull
    public List<VersionedPackage> getDependentPackages() {
        if (this.mDependentPackages == null) {
            return Collections.emptyList();
        }
        return this.mDependentPackages;
    }

    @FlaggedApi(value="android.content.pm.sdk_lib_independence")
    @NonNull
    public List<VersionedPackage> getOptionalDependentPackages() {
        if (this.mOptionalDependentPackages == null) {
            return Collections.emptyList();
        }
        return this.mOptionalDependentPackages;
    }

    @FlaggedApi(value="android.content.pm.sdk_dependency_installer")
    @NonNull
    public List<String> getCertDigests() {
        if (this.mCertDigests == null) {
            return Collections.emptyList();
        }
        return this.mCertDigests;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "SharedLibraryInfo{name:" + this.mName + ", type:" + SharedLibraryInfo.typeToString(this.mType) + ", version:" + this.mVersion + (!this.getDependentPackages().isEmpty() ? " has dependents" : "") + "}";
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString8(this.mPath);
        parcel.writeString8(this.mPackageName);
        if (this.mCodePaths != null) {
            parcel.writeInt(1);
            parcel.writeString8Array(this.mCodePaths.toArray(new String[this.mCodePaths.size()]));
        } else {
            parcel.writeInt(0);
        }
        parcel.writeString8(this.mName);
        parcel.writeLong(this.mVersion);
        parcel.writeInt(this.mType);
        parcel.writeParcelable(this.mDeclaringPackage, flags);
        parcel.writeList(this.mDependentPackages);
        parcel.writeTypedList(this.mDependencies);
        parcel.writeBoolean(this.mIsNative);
        parcel.writeParcelableList(this.mOptionalDependentPackages, flags);
        parcel.writeStringList(this.mCertDigests);
    }

    private static String typeToString(int type) {
        switch (type) {
            case 0: {
                return "builtin";
            }
            case 1: {
                return "dynamic";
            }
            case 2: {
                return "static";
            }
            case 3: {
                return "sdk";
            }
        }
        return "unknown";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

