/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.pm.ApplicationInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.Parcelling;

public class ProcessInfo
implements Parcelable {
    @NonNull
    public String name;
    @Nullable
    public ArraySet<String> deniedPermissions;
    public int gwpAsanMode;
    public int memtagMode;
    public int nativeHeapZeroInitialized;
    public boolean useEmbeddedDex;
    static Parcelling<ArraySet<String>> sParcellingForDeniedPermissions = Parcelling.Cache.get(Parcelling.BuiltIn.ForInternedStringArraySet.class);
    @NonNull
    public static final Parcelable.Creator<ProcessInfo> CREATOR;

    @Deprecated
    public ProcessInfo(@NonNull ProcessInfo orig) {
        this.name = orig.name;
        this.deniedPermissions = orig.deniedPermissions;
        this.gwpAsanMode = orig.gwpAsanMode;
        this.memtagMode = orig.memtagMode;
        this.nativeHeapZeroInitialized = orig.nativeHeapZeroInitialized;
        this.useEmbeddedDex = orig.useEmbeddedDex;
    }

    public ProcessInfo(@NonNull String name, @Nullable ArraySet<String> deniedPermissions, int gwpAsanMode, int memtagMode, int nativeHeapZeroInitialized, boolean useEmbeddedDex) {
        this.name = name;
        AnnotationValidations.validate(NonNull.class, null, (Object)name);
        this.deniedPermissions = deniedPermissions;
        this.gwpAsanMode = gwpAsanMode;
        AnnotationValidations.validate(ApplicationInfo.GwpAsanMode.class, null, gwpAsanMode);
        this.memtagMode = memtagMode;
        AnnotationValidations.validate(ApplicationInfo.MemtagMode.class, null, memtagMode);
        this.nativeHeapZeroInitialized = nativeHeapZeroInitialized;
        AnnotationValidations.validate(ApplicationInfo.NativeHeapZeroInitialized.class, null, nativeHeapZeroInitialized);
        this.useEmbeddedDex = useEmbeddedDex;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        byte flg = 0;
        if (this.useEmbeddedDex) {
            flg = (byte)(flg | 0x20);
        }
        if (this.deniedPermissions != null) {
            flg = (byte)(flg | 2);
        }
        dest.writeByte(flg);
        dest.writeString(this.name);
        sParcellingForDeniedPermissions.parcel(this.deniedPermissions, dest, flags);
        dest.writeInt(this.gwpAsanMode);
        dest.writeInt(this.memtagMode);
        dest.writeInt(this.nativeHeapZeroInitialized);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    protected ProcessInfo(@NonNull Parcel in) {
        byte flg = in.readByte();
        boolean _useEmbeddedDex = (flg & 0x20) != 0;
        String _name = in.readString();
        ArraySet<String> _deniedPermissions = sParcellingForDeniedPermissions.unparcel(in);
        int _gwpAsanMode = in.readInt();
        int _memtagMode = in.readInt();
        int _nativeHeapZeroInitialized = in.readInt();
        this.name = _name;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.name);
        this.deniedPermissions = _deniedPermissions;
        this.gwpAsanMode = _gwpAsanMode;
        AnnotationValidations.validate(ApplicationInfo.GwpAsanMode.class, null, this.gwpAsanMode);
        this.memtagMode = _memtagMode;
        AnnotationValidations.validate(ApplicationInfo.MemtagMode.class, null, this.memtagMode);
        this.nativeHeapZeroInitialized = _nativeHeapZeroInitialized;
        AnnotationValidations.validate(ApplicationInfo.NativeHeapZeroInitialized.class, null, this.nativeHeapZeroInitialized);
        this.useEmbeddedDex = _useEmbeddedDex;
    }

    @Deprecated
    private void __metadata() {
    }

    static {
        if (sParcellingForDeniedPermissions == null) {
            sParcellingForDeniedPermissions = Parcelling.Cache.put(new Parcelling.BuiltIn.ForInternedStringArraySet());
        }
        CREATOR = new Parcelable.Creator<ProcessInfo>(){

            public ProcessInfo[] newArray(int size) {
                return new ProcessInfo[size];
            }

            @Override
            public ProcessInfo createFromParcel(@NonNull Parcel in) {
                return new ProcessInfo(in);
            }
        };
    }
}

