/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.SystemProperties;
import android.util.ArrayMap;
import android.util.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class FallbackCategoryProvider {
    private static final String TAG = "FallbackCategoryProvider";
    private static final ArrayMap<String, Integer> sFallbacks = new ArrayMap();

    public static void loadFallbacks() {
        sFallbacks.clear();
        if (SystemProperties.getBoolean("fw.ignore_fb_categories", false)) {
            Log.d(TAG, "Ignoring fallback categories");
            return;
        }
        AssetManager assets = new AssetManager();
        assets.addAssetPath("/system/framework/framework-res.apk");
        Resources res = new Resources(assets, null, null);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(res.openRawResource(0x1100005)));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] split;
                if (line.charAt(0) == '#' || (split = line.split(",")).length != 2) continue;
                sFallbacks.put(split[0], Integer.parseInt(split[1]));
            }
            Log.d(TAG, "Found " + sFallbacks.size() + " fallback categories");
        }
        catch (IOException | NumberFormatException e) {
            Log.w(TAG, "Failed to read fallback categories", e);
        }
    }

    public static int getFallbackCategory(String packageName) {
        return sFallbacks.getOrDefault(packageName, -1);
    }
}

