/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.content.pm.Checksum;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public class ApkChecksum
implements Parcelable {
    @Nullable
    private final String mSplitName;
    @NonNull
    private final Checksum mChecksum;
    @Nullable
    private final String mInstallerPackageName;
    @Nullable
    private final byte[] mInstallerCertificate;
    @NonNull
    public static final Parcelable.Creator<ApkChecksum> CREATOR = new Parcelable.Creator<ApkChecksum>(){

        public ApkChecksum[] newArray(int size) {
            return new ApkChecksum[size];
        }

        @Override
        public ApkChecksum createFromParcel(@NonNull Parcel in) {
            return new ApkChecksum(in);
        }
    };

    public ApkChecksum(@Nullable String splitName, int type, @NonNull byte[] value) {
        this(splitName, new Checksum(type, value), null, null);
    }

    public ApkChecksum(@Nullable String splitName, int type, @NonNull byte[] value, @Nullable String sourcePackageName, @Nullable Certificate sourceCertificate) throws CertificateEncodingException {
        this(splitName, new Checksum(type, value), sourcePackageName, sourceCertificate != null ? sourceCertificate.getEncoded() : null);
    }

    public int getType() {
        return this.mChecksum.getType();
    }

    @NonNull
    public byte[] getValue() {
        return this.mChecksum.getValue();
    }

    @Nullable
    public byte[] getInstallerCertificateBytes() {
        return this.mInstallerCertificate;
    }

    @Nullable
    public Certificate getInstallerCertificate() throws CertificateException {
        if (this.mInstallerCertificate == null) {
            return null;
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream is = new ByteArrayInputStream(this.mInstallerCertificate);
        X509Certificate cert = (X509Certificate)cf.generateCertificate(is);
        return cert;
    }

    public ApkChecksum(@Nullable String splitName, @NonNull Checksum checksum, @Nullable String installerPackageName, @Nullable byte[] installerCertificate) {
        this.mSplitName = splitName;
        this.mChecksum = checksum;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mChecksum);
        this.mInstallerPackageName = installerPackageName;
        this.mInstallerCertificate = installerCertificate;
    }

    @Nullable
    public String getSplitName() {
        return this.mSplitName;
    }

    @Nullable
    public String getInstallerPackageName() {
        return this.mInstallerPackageName;
    }

    public String toString() {
        return "ApkChecksum { splitName = " + this.mSplitName + ", checksum = " + this.mChecksum + ", installerPackageName = " + this.mInstallerPackageName + ", installerCertificate = " + Arrays.toString(this.mInstallerCertificate) + " }";
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        byte flg = 0;
        if (this.mSplitName != null) {
            flg = (byte)(flg | 1);
        }
        if (this.mInstallerPackageName != null) {
            flg = (byte)(flg | 4);
        }
        if (this.mInstallerCertificate != null) {
            flg = (byte)(flg | 8);
        }
        dest.writeByte(flg);
        if (this.mSplitName != null) {
            dest.writeString(this.mSplitName);
        }
        dest.writeTypedObject(this.mChecksum, flags);
        if (this.mInstallerPackageName != null) {
            dest.writeString(this.mInstallerPackageName);
        }
        if (this.mInstallerCertificate != null) {
            dest.writeByteArray(this.mInstallerCertificate);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    ApkChecksum(@NonNull Parcel in) {
        byte flg = in.readByte();
        String splitName = (flg & 1) == 0 ? null : in.readString();
        Checksum checksum = in.readTypedObject(Checksum.CREATOR);
        String installerPackageName = (flg & 4) == 0 ? null : in.readString();
        byte[] installerCertificate = (flg & 8) == 0 ? null : in.createByteArray();
        this.mSplitName = splitName;
        this.mChecksum = checksum;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mChecksum);
        this.mInstallerPackageName = installerPackageName;
        this.mInstallerCertificate = installerCertificate;
    }

    @Deprecated
    private void __metadata() {
    }
}

