/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.annotation.NonNull;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;

public class SyncInfo
implements Parcelable {
    private static final Account REDACTED_ACCOUNT = new Account("*****", "*****");
    @UnsupportedAppUsage
    public final int authorityId;
    public final Account account;
    public final String authority;
    public final long startTime;
    @UnsupportedAppUsage
    @NonNull
    public static final Parcelable.Creator<SyncInfo> CREATOR = new Parcelable.Creator<SyncInfo>(){

        @Override
        public SyncInfo createFromParcel(Parcel in) {
            return new SyncInfo(in);
        }

        public SyncInfo[] newArray(int size) {
            return new SyncInfo[size];
        }
    };

    public static SyncInfo createAccountRedacted(int authorityId, String authority, long startTime) {
        return new SyncInfo(authorityId, REDACTED_ACCOUNT, authority, startTime);
    }

    @UnsupportedAppUsage
    public SyncInfo(int authorityId, Account account, String authority, long startTime) {
        this.authorityId = authorityId;
        this.account = account;
        this.authority = authority;
        this.startTime = startTime;
    }

    public SyncInfo(SyncInfo other) {
        this.authorityId = other.authorityId;
        this.account = new Account(other.account.name, other.account.type);
        this.authority = other.authority;
        this.startTime = other.startTime;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.authorityId);
        parcel.writeParcelable(this.account, flags);
        parcel.writeString(this.authority);
        parcel.writeLong(this.startTime);
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    SyncInfo(Parcel parcel) {
        this.authorityId = parcel.readInt();
        this.account = parcel.readParcelable(Account.class.getClassLoader(), Account.class);
        this.authority = parcel.readString();
        this.startTime = parcel.readLong();
    }
}

