/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.annotation.NonNull;
import android.net.Uri;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import java.util.List;

@RavenwoodKeepWholeClass
public class ContentUris {
    public static long parseId(@NonNull Uri contentUri) {
        String last = contentUri.getLastPathSegment();
        return last == null ? -1L : Long.parseLong(last);
    }

    @NonNull
    public static Uri.Builder appendId(@NonNull Uri.Builder builder, long id2) {
        return builder.appendEncodedPath(String.valueOf(id2));
    }

    @NonNull
    public static Uri withAppendedId(@NonNull Uri contentUri, long id2) {
        return ContentUris.appendId(contentUri.buildUpon(), id2).build();
    }

    @NonNull
    public static Uri removeId(@NonNull Uri contentUri) {
        String last = contentUri.getLastPathSegment();
        if (last == null) {
            throw new IllegalArgumentException("No path segments to remove");
        }
        Long.parseLong(last);
        List<String> segments = contentUri.getPathSegments();
        Uri.Builder builder = contentUri.buildUpon();
        builder.path((String)null);
        for (int i = 0; i < segments.size() - 1; ++i) {
            builder.appendPath(segments.get(i));
        }
        return builder.build();
    }
}

