/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.content.ContentInterface;
import android.content.ContentProvider;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.IContentProvider;
import android.content.OperationApplicationException;
import android.content.res.AssetFileDescriptor;
import android.database.CrossProcessCursorWrapper;
import android.database.Cursor;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.ICancellationSignal;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import dalvik.system.CloseGuard;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import libcore.io.IoUtils;

public class ContentProviderClient
implements ContentInterface,
AutoCloseable {
    private static final String TAG = "ContentProviderClient";
    @GuardedBy(value={"ContentProviderClient.class"})
    private static Handler sAnrHandler;
    private final ContentResolver mContentResolver;
    @UnsupportedAppUsage
    private final IContentProvider mContentProvider;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    private final String mPackageName;
    @NonNull
    private final AttributionSource mAttributionSource;
    private final String mAuthority;
    private final boolean mStable;
    private final AtomicBoolean mClosed = new AtomicBoolean();
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private long mAnrTimeout;
    private NotRespondingRunnable mAnrRunnable;

    @VisibleForTesting
    public ContentProviderClient(ContentResolver contentResolver, IContentProvider contentProvider, boolean stable) {
        this(contentResolver, contentProvider, "unknown", stable);
    }

    public ContentProviderClient(ContentResolver contentResolver, IContentProvider contentProvider, String authority, boolean stable) {
        this.mContentResolver = contentResolver;
        this.mContentProvider = contentProvider;
        this.mPackageName = contentResolver.mPackageName;
        this.mAttributionSource = contentResolver.getAttributionSource();
        this.mAuthority = authority;
        this.mStable = stable;
        this.mCloseGuard.open("ContentProviderClient.close");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.REMOVE_TASKS")
    public void setDetectNotResponding(long timeoutMillis) {
        Class<ContentProviderClient> clazz = ContentProviderClient.class;
        synchronized (ContentProviderClient.class) {
            this.mAnrTimeout = timeoutMillis;
            if (timeoutMillis > 0L) {
                if (this.mAnrRunnable == null) {
                    this.mAnrRunnable = new NotRespondingRunnable();
                }
                if (sAnrHandler == null) {
                    sAnrHandler = new Handler(Looper.getMainLooper(), null, true);
                }
                Binder.allowBlocking(this.mContentProvider.asBinder());
            } else {
                this.mAnrRunnable = null;
                Binder.defaultBlocking(this.mContentProvider.asBinder());
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    private void beforeRemote() {
        if (this.mAnrRunnable != null) {
            sAnrHandler.postDelayed(this.mAnrRunnable, this.mAnrTimeout);
        }
    }

    private void afterRemote() {
        if (this.mAnrRunnable != null) {
            sAnrHandler.removeCallbacks(this.mAnrRunnable);
        }
    }

    @Nullable
    public Cursor query(@NonNull Uri url, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) throws RemoteException {
        return this.query(url, projection, selection, selectionArgs, sortOrder, null);
    }

    @Nullable
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder, @Nullable CancellationSignal cancellationSignal) throws RemoteException {
        Bundle queryArgs = ContentResolver.createSqlQueryBundle(selection, selectionArgs, sortOrder);
        return this.query(uri, projection, queryArgs, cancellationSignal);
    }

    @Override
    @Nullable
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, Bundle queryArgs, @Nullable CancellationSignal cancellationSignal) throws RemoteException {
        Objects.requireNonNull(uri, "url");
        this.beforeRemote();
        try {
            Cursor cursor;
            ICancellationSignal remoteCancellationSignal = null;
            if (cancellationSignal != null) {
                cancellationSignal.throwIfCanceled();
                remoteCancellationSignal = this.mContentProvider.createCancellationSignal();
                cancellationSignal.setRemote(remoteCancellationSignal);
            }
            if ((cursor = this.mContentProvider.query(this.mAttributionSource, uri, projection, queryArgs, remoteCancellationSignal)) == null) {
                Cursor cursor2 = null;
                return cursor2;
            }
            CursorWrapperInner cursorWrapperInner = new CursorWrapperInner(this, cursor);
            return cursorWrapperInner;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    @Override
    @Nullable
    public String getType(@NonNull Uri url) throws RemoteException {
        Objects.requireNonNull(url, "url");
        this.beforeRemote();
        try {
            String string2 = this.mContentProvider.getType(this.mAttributionSource, url);
            return string2;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    @Override
    @Nullable
    public String[] getStreamTypes(@NonNull Uri url, @NonNull String mimeTypeFilter) throws RemoteException {
        Objects.requireNonNull(url, "url");
        Objects.requireNonNull(mimeTypeFilter, "mimeTypeFilter");
        this.beforeRemote();
        try {
            String[] stringArray = this.mContentProvider.getStreamTypes(this.mAttributionSource, url, mimeTypeFilter);
            return stringArray;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    @Override
    @Nullable
    public Uri canonicalize(@NonNull Uri url) throws RemoteException {
        Objects.requireNonNull(url, "url");
        this.beforeRemote();
        try {
            Uri uri = this.mContentProvider.canonicalize(this.mAttributionSource, url);
            return uri;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    @Override
    @Nullable
    public Uri uncanonicalize(@NonNull Uri url) throws RemoteException {
        Objects.requireNonNull(url, "url");
        this.beforeRemote();
        try {
            Uri uri = this.mContentProvider.uncanonicalize(this.mAttributionSource, url);
            return uri;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    @Override
    public boolean refresh(Uri url, @Nullable Bundle extras, @Nullable CancellationSignal cancellationSignal) throws RemoteException {
        Objects.requireNonNull(url, "url");
        this.beforeRemote();
        try {
            ICancellationSignal remoteCancellationSignal = null;
            if (cancellationSignal != null) {
                cancellationSignal.throwIfCanceled();
                remoteCancellationSignal = this.mContentProvider.createCancellationSignal();
                cancellationSignal.setRemote(remoteCancellationSignal);
            }
            boolean bl = this.mContentProvider.refresh(this.mAttributionSource, url, extras, remoteCancellationSignal);
            return bl;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    @Override
    public int checkUriPermission(@NonNull Uri uri, int uid, int modeFlags) throws RemoteException {
        Objects.requireNonNull(uri, "uri");
        this.beforeRemote();
        try {
            int n = this.mContentProvider.checkUriPermission(this.mAttributionSource, uri, uid, modeFlags);
            return n;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    @Nullable
    public Uri insert(@NonNull Uri url, @Nullable ContentValues initialValues) throws RemoteException {
        return this.insert(url, initialValues, null);
    }

    @Override
    @Nullable
    public Uri insert(@NonNull Uri url, @Nullable ContentValues initialValues, @Nullable Bundle extras) throws RemoteException {
        Objects.requireNonNull(url, "url");
        this.beforeRemote();
        try {
            Uri uri = this.mContentProvider.insert(this.mAttributionSource, url, initialValues, extras);
            return uri;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    @Override
    public int bulkInsert(@NonNull Uri url, @NonNull ContentValues[] initialValues) throws RemoteException {
        Objects.requireNonNull(url, "url");
        Objects.requireNonNull(initialValues, "initialValues");
        this.beforeRemote();
        try {
            int n = this.mContentProvider.bulkInsert(this.mAttributionSource, url, initialValues);
            return n;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    public int delete(@NonNull Uri url, @Nullable String selection, @Nullable String[] selectionArgs) throws RemoteException {
        return this.delete(url, ContentResolver.createSqlQueryBundle(selection, selectionArgs));
    }

    @Override
    public int delete(@NonNull Uri url, @Nullable Bundle extras) throws RemoteException {
        Objects.requireNonNull(url, "url");
        this.beforeRemote();
        try {
            int n = this.mContentProvider.delete(this.mAttributionSource, url, extras);
            return n;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    public int update(@NonNull Uri url, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) throws RemoteException {
        return this.update(url, values, ContentResolver.createSqlQueryBundle(selection, selectionArgs));
    }

    @Override
    public int update(@NonNull Uri url, @Nullable ContentValues values, @Nullable Bundle extras) throws RemoteException {
        Objects.requireNonNull(url, "url");
        this.beforeRemote();
        try {
            int n = this.mContentProvider.update(this.mAttributionSource, url, values, extras);
            return n;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    @Nullable
    public ParcelFileDescriptor openFile(@NonNull Uri url, @NonNull String mode) throws RemoteException, FileNotFoundException {
        return this.openFile(url, mode, null);
    }

    @Override
    @Nullable
    public ParcelFileDescriptor openFile(@NonNull Uri url, @NonNull String mode, @Nullable CancellationSignal signal) throws RemoteException, FileNotFoundException {
        Objects.requireNonNull(url, "url");
        Objects.requireNonNull(mode, "mode");
        this.beforeRemote();
        try {
            ICancellationSignal remoteSignal = null;
            if (signal != null) {
                signal.throwIfCanceled();
                remoteSignal = this.mContentProvider.createCancellationSignal();
                signal.setRemote(remoteSignal);
            }
            ParcelFileDescriptor parcelFileDescriptor = this.mContentProvider.openFile(this.mAttributionSource, url, mode, remoteSignal);
            return parcelFileDescriptor;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    @Nullable
    public AssetFileDescriptor openAssetFile(@NonNull Uri url, @NonNull String mode) throws RemoteException, FileNotFoundException {
        return this.openAssetFile(url, mode, null);
    }

    @Override
    @Nullable
    public AssetFileDescriptor openAssetFile(@NonNull Uri url, @NonNull String mode, @Nullable CancellationSignal signal) throws RemoteException, FileNotFoundException {
        Objects.requireNonNull(url, "url");
        Objects.requireNonNull(mode, "mode");
        this.beforeRemote();
        try {
            ICancellationSignal remoteSignal = null;
            if (signal != null) {
                signal.throwIfCanceled();
                remoteSignal = this.mContentProvider.createCancellationSignal();
                signal.setRemote(remoteSignal);
            }
            AssetFileDescriptor assetFileDescriptor = this.mContentProvider.openAssetFile(this.mAttributionSource, url, mode, remoteSignal);
            return assetFileDescriptor;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    @Nullable
    public AssetFileDescriptor openTypedAssetFileDescriptor(@NonNull Uri uri, @NonNull String mimeType, @Nullable Bundle opts) throws RemoteException, FileNotFoundException {
        return this.openTypedAssetFileDescriptor(uri, mimeType, opts, null);
    }

    @Nullable
    public AssetFileDescriptor openTypedAssetFileDescriptor(@NonNull Uri uri, @NonNull String mimeType, @Nullable Bundle opts, @Nullable CancellationSignal signal) throws RemoteException, FileNotFoundException {
        return this.openTypedAssetFile(uri, mimeType, opts, signal);
    }

    @Override
    @Nullable
    public AssetFileDescriptor openTypedAssetFile(@NonNull Uri uri, @NonNull String mimeTypeFilter, @Nullable Bundle opts, @Nullable CancellationSignal signal) throws RemoteException, FileNotFoundException {
        Objects.requireNonNull(uri, "uri");
        Objects.requireNonNull(mimeTypeFilter, "mimeTypeFilter");
        this.beforeRemote();
        try {
            ICancellationSignal remoteSignal = null;
            if (signal != null) {
                signal.throwIfCanceled();
                remoteSignal = this.mContentProvider.createCancellationSignal();
                signal.setRemote(remoteSignal);
            }
            AssetFileDescriptor assetFileDescriptor = this.mContentProvider.openTypedAssetFile(this.mAttributionSource, uri, mimeTypeFilter, opts, remoteSignal);
            return assetFileDescriptor;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    @NonNull
    public ContentProviderResult[] applyBatch(@NonNull ArrayList<ContentProviderOperation> operations) throws RemoteException, OperationApplicationException {
        return this.applyBatch(this.mAuthority, operations);
    }

    @Override
    @NonNull
    public ContentProviderResult[] applyBatch(@NonNull String authority, @NonNull ArrayList<ContentProviderOperation> operations) throws RemoteException, OperationApplicationException {
        Objects.requireNonNull(operations, "operations");
        this.beforeRemote();
        try {
            ContentProviderResult[] contentProviderResultArray = this.mContentProvider.applyBatch(this.mAttributionSource, authority, operations);
            return contentProviderResultArray;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    @Nullable
    public Bundle call(@NonNull String method, @Nullable String arg, @Nullable Bundle extras) throws RemoteException {
        return this.call(this.mAuthority, method, arg, extras);
    }

    @Override
    @Nullable
    public Bundle call(@NonNull String authority, @NonNull String method, @Nullable String arg, @Nullable Bundle extras) throws RemoteException {
        Objects.requireNonNull(authority, "authority");
        Objects.requireNonNull(method, "method");
        this.beforeRemote();
        try {
            Bundle bundle = this.mContentProvider.call(this.mAttributionSource, authority, method, arg, extras);
            return bundle;
        }
        catch (DeadObjectException e) {
            if (!this.mStable) {
                this.mContentResolver.unstableProviderDied(this.mContentProvider);
            }
            throw e;
        }
        finally {
            this.afterRemote();
        }
    }

    @Override
    public void close() {
        this.closeInternal();
    }

    @Deprecated
    public boolean release() {
        return this.closeInternal();
    }

    private boolean closeInternal() {
        this.mCloseGuard.close();
        if (this.mClosed.compareAndSet(false, true)) {
            this.setDetectNotResponding(0L);
            if (this.mStable) {
                return this.mContentResolver.releaseProvider(this.mContentProvider);
            }
            return this.mContentResolver.releaseUnstableProvider(this.mContentProvider);
        }
        return false;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mCloseGuard != null) {
                this.mCloseGuard.warnIfOpen();
            }
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Nullable
    public ContentProvider getLocalContentProvider() {
        return ContentProvider.coerceToLocalContentProvider(this.mContentProvider);
    }

    @Deprecated
    public static void closeQuietly(ContentProviderClient client) {
        IoUtils.closeQuietly(client);
    }

    @Deprecated
    public static void releaseQuietly(ContentProviderClient client) {
        IoUtils.closeQuietly(client);
    }

    private class NotRespondingRunnable
    implements Runnable {
        private NotRespondingRunnable() {
        }

        @Override
        public void run() {
            Log.w(ContentProviderClient.TAG, "Detected provider not responding: " + ContentProviderClient.this.mContentProvider);
            ContentProviderClient.this.mContentResolver.appNotRespondingViaProvider(ContentProviderClient.this.mContentProvider);
        }
    }

    private class CursorWrapperInner
    extends CrossProcessCursorWrapper {
        private final CloseGuard mCloseGuard = CloseGuard.get();

        CursorWrapperInner(ContentProviderClient contentProviderClient, Cursor cursor) {
            super(cursor);
            this.mCloseGuard.open("CursorWrapperInner.close");
        }

        @Override
        public void close() {
            this.mCloseGuard.close();
            super.close();
        }

        protected void finalize() throws Throwable {
            try {
                if (this.mCloseGuard != null) {
                    this.mCloseGuard.warnIfOpen();
                }
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }
}

