/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual.sensor;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

@SystemApi
@FlaggedApi(value="android.companion.virtualdevice.flags.virtual_sensor_additional_info")
public class VirtualSensorAdditionalInfo
implements Parcelable {
    private final int mType;
    @NonNull
    private final List<float[]> mValues;
    @NonNull
    public static final Parcelable.Creator<VirtualSensorAdditionalInfo> CREATOR = new Parcelable.Creator<VirtualSensorAdditionalInfo>(){

        @Override
        public VirtualSensorAdditionalInfo createFromParcel(Parcel source) {
            return new VirtualSensorAdditionalInfo(source);
        }

        public VirtualSensorAdditionalInfo[] newArray(int size) {
            return new VirtualSensorAdditionalInfo[size];
        }
    };

    private VirtualSensorAdditionalInfo(int type, @NonNull List<float[]> values) {
        this.mType = type;
        this.mValues = values;
    }

    private VirtualSensorAdditionalInfo(@NonNull Parcel parcel) {
        this.mType = parcel.readInt();
        int valuesLength = parcel.readInt();
        this.mValues = new ArrayList<float[]>(valuesLength);
        for (int i = 0; i < valuesLength; ++i) {
            this.mValues.add(parcel.createFloatArray());
        }
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int parcelableFlags) {
        parcel.writeInt(this.mType);
        parcel.writeInt(this.mValues.size());
        for (int i = 0; i < this.mValues.size(); ++i) {
            parcel.writeFloatArray(this.mValues.get(i));
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getType() {
        return this.mType;
    }

    @NonNull
    public List<float[]> getValues() {
        return this.mValues;
    }

    public static class Builder {
        private final int mType;
        @NonNull
        private final ArrayList<float[]> mValues = new ArrayList();
        private static final int TYPE_SAMPLING_PLAYLOAD_SIZE = 2;
        private static final int TYPE_UNTRACKED_DELAY_PAYLOAD_SIZE = 2;
        private static final int TYPE_INTERNAL_TEMPERATURE_PLAYLOAD_SIZE = 1;
        private static final int TYPE_VEC3_CALIBRATION_PAYLOAD_SIZE = 12;
        private static final int TYPE_SENSOR_PLACEMENT_PAYLOAD_SIZE = 12;

        public Builder(int type) {
            switch (type) {
                case 65536: 
                case 65537: 
                case 65538: 
                case 65539: 
                case 65540: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported type " + type);
                }
            }
            this.mType = type;
        }

        @NonNull
        public Builder addValues(@NonNull float[] values) {
            if (this.mValues.isEmpty()) {
                switch (this.mType) {
                    case 65536: {
                        this.assertValuesLength(values, 2);
                        break;
                    }
                    case 65540: {
                        this.assertValuesLength(values, 2);
                        break;
                    }
                    case 65537: {
                        this.assertValuesLength(values, 1);
                        break;
                    }
                    case 65538: {
                        this.assertValuesLength(values, 12);
                        break;
                    }
                    case 65539: {
                        this.assertValuesLength(values, 12);
                    }
                }
            } else if (values.length != this.mValues.getFirst().length) {
                throw new IllegalArgumentException("All payload values must have the same length");
            }
            this.mValues.add(values);
            return this;
        }

        private void assertValuesLength(float[] values, int expected) {
            if (values.length != expected) {
                throw new IllegalArgumentException("Payload values must have size " + expected + " for type " + this.mType);
            }
        }

        @NonNull
        public VirtualSensorAdditionalInfo build() {
            if (this.mValues.isEmpty()) {
                throw new IllegalArgumentException("Payload is required");
            }
            return new VirtualSensorAdditionalInfo(this.mType, this.mValues);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

