/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual.sensor;

import android.companion.virtual.sensor.VirtualSensor;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.SharedMemory;

public interface IVirtualSensorCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.companion.virtual.sensor.IVirtualSensorCallback";

    public void onConfigurationChanged(VirtualSensor var1, boolean var2, int var3, int var4) throws RemoteException;

    public void onDirectChannelCreated(int var1, SharedMemory var2) throws RemoteException;

    public void onDirectChannelDestroyed(int var1) throws RemoteException;

    public void onDirectChannelConfigured(int var1, VirtualSensor var2, int var3, int var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVirtualSensorCallback {
        static final int TRANSACTION_onConfigurationChanged = 1;
        static final int TRANSACTION_onDirectChannelCreated = 2;
        static final int TRANSACTION_onDirectChannelDestroyed = 3;
        static final int TRANSACTION_onDirectChannelConfigured = 4;

        public Stub() {
            this.attachInterface(this, IVirtualSensorCallback.DESCRIPTOR);
        }

        public static IVirtualSensorCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IVirtualSensorCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IVirtualSensorCallback) {
                return (IVirtualSensorCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onConfigurationChanged";
                }
                case 2: {
                    return "onDirectChannelCreated";
                }
                case 3: {
                    return "onDirectChannelDestroyed";
                }
                case 4: {
                    return "onDirectChannelConfigured";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IVirtualSensorCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    VirtualSensor _arg0 = data.readTypedObject(VirtualSensor.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onConfigurationChanged(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    SharedMemory _arg1 = data.readTypedObject(SharedMemory.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDirectChannelCreated(_arg0, _arg1);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDirectChannelDestroyed(_arg0);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    VirtualSensor _arg1 = data.readTypedObject(VirtualSensor.CREATOR);
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onDirectChannelConfigured(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements IVirtualSensorCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IVirtualSensorCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConfigurationChanged(VirtualSensor sensor, boolean enabled, int samplingPeriodMicros, int batchReportLatencyMicros) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IVirtualSensorCallback.DESCRIPTOR);
                    _data.writeTypedObject(sensor, 0);
                    _data.writeBoolean(enabled);
                    _data.writeInt(samplingPeriodMicros);
                    _data.writeInt(batchReportLatencyMicros);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDirectChannelCreated(int channelHandle, SharedMemory sharedMemory) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IVirtualSensorCallback.DESCRIPTOR);
                    _data.writeInt(channelHandle);
                    _data.writeTypedObject(sharedMemory, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDirectChannelDestroyed(int channelHandle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IVirtualSensorCallback.DESCRIPTOR);
                    _data.writeInt(channelHandle);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDirectChannelConfigured(int channelHandle, VirtualSensor sensor, int rateLevel, int reportToken) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IVirtualSensorCallback.DESCRIPTOR);
                    _data.writeInt(channelHandle);
                    _data.writeTypedObject(sensor, 0);
                    _data.writeInt(rateLevel);
                    _data.writeInt(reportToken);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IVirtualSensorCallback {
        @Override
        public void onConfigurationChanged(VirtualSensor sensor, boolean enabled, int samplingPeriodMicros, int batchReportLatencyMicros) throws RemoteException {
        }

        @Override
        public void onDirectChannelCreated(int channelHandle, SharedMemory sharedMemory) throws RemoteException {
        }

        @Override
        public void onDirectChannelDestroyed(int channelHandle) throws RemoteException {
        }

        @Override
        public void onDirectChannelConfigured(int channelHandle, VirtualSensor sensor, int rateLevel, int reportToken) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

