/*
 * Decompiled with CFR 0.152.
 */
package android.companion.virtual.camera;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.companion.virtual.IVirtualDevice;
import android.companion.virtual.camera.VirtualCameraConfig;
import android.os.RemoteException;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.io.Closeable;
import java.util.Objects;

@SystemApi
public class VirtualCamera
implements Closeable {
    private final IVirtualDevice mVirtualDevice;
    private final String mCameraId;
    private final VirtualCameraConfig mConfig;

    public VirtualCamera(@NonNull IVirtualDevice virtualDevice, @NonNull String cameraId, @NonNull VirtualCameraConfig config) {
        this.mVirtualDevice = Objects.requireNonNull(virtualDevice);
        this.mCameraId = Objects.requireNonNull(cameraId);
        this.mConfig = Objects.requireNonNull(config);
    }

    @NonNull
    public VirtualCameraConfig getConfig() {
        return this.mConfig;
    }

    @SuppressLint(value={"UnflaggedApi"})
    @NonNull
    public String getId() {
        return this.mCameraId;
    }

    @Override
    public void close() {
        try {
            this.mVirtualDevice.unregisterVirtualCamera(this.mConfig);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }
}

