/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.bluetooth.BluetoothDevice;
import android.content.AttributionSource;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.ParcelUuid;
import android.os.RemoteException;

public interface IBluetoothSocketManager
extends IInterface {
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public ParcelFileDescriptor connectSocket(BluetoothDevice var1, int var2, ParcelUuid var3, int var4, int var5) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public ParcelFileDescriptor connectSocketWithOffload(BluetoothDevice var1, int var2, ParcelUuid var3, int var4, int var5, int var6, String var7, long var8, long var10, int var12) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public ParcelFileDescriptor createSocketChannel(int var1, String var2, ParcelUuid var3, int var4, int var5) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public ParcelFileDescriptor createSocketChannelWithOffload(int var1, String var2, ParcelUuid var3, int var4, int var5, int var6, String var7, long var8, long var10, int var12) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public void requestMaximumTxDataLength(BluetoothDevice var1) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getL2capLocalChannelId(ParcelUuid var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getL2capRemoteChannelId(ParcelUuid var1, AttributionSource var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothSocketManager {
        public static final String DESCRIPTOR = "android.bluetooth.IBluetoothSocketManager";
        static final int TRANSACTION_connectSocket = 1;
        static final int TRANSACTION_connectSocketWithOffload = 2;
        static final int TRANSACTION_createSocketChannel = 3;
        static final int TRANSACTION_createSocketChannelWithOffload = 4;
        static final int TRANSACTION_requestMaximumTxDataLength = 5;
        static final int TRANSACTION_getL2capLocalChannelId = 6;
        static final int TRANSACTION_getL2capRemoteChannelId = 7;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBluetoothSocketManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothSocketManager) {
                return (IBluetoothSocketManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "connectSocket";
                }
                case 2: {
                    return "connectSocketWithOffload";
                }
                case 3: {
                    return "createSocketChannel";
                }
                case 4: {
                    return "createSocketChannelWithOffload";
                }
                case 5: {
                    return "requestMaximumTxDataLength";
                }
                case 6: {
                    return "getL2capLocalChannelId";
                }
                case 7: {
                    return "getL2capRemoteChannelId";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    ParcelUuid _arg2 = data.readTypedObject(ParcelUuid.CREATOR);
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    ParcelFileDescriptor _result = this.connectSocket(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    int _arg1 = data.readInt();
                    ParcelUuid _arg2 = data.readTypedObject(ParcelUuid.CREATOR);
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    String _arg6 = data.readString();
                    long _arg7 = data.readLong();
                    long _arg8 = data.readLong();
                    int _arg9 = data.readInt();
                    data.enforceNoDataAvail();
                    ParcelFileDescriptor _result = this.connectSocketWithOffload(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    ParcelUuid _arg2 = data.readTypedObject(ParcelUuid.CREATOR);
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    data.enforceNoDataAvail();
                    ParcelFileDescriptor _result = this.createSocketChannel(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    ParcelUuid _arg2 = data.readTypedObject(ParcelUuid.CREATOR);
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    int _arg5 = data.readInt();
                    String _arg6 = data.readString();
                    long _arg7 = data.readLong();
                    long _arg8 = data.readLong();
                    int _arg9 = data.readInt();
                    data.enforceNoDataAvail();
                    ParcelFileDescriptor _result = this.createSocketChannelWithOffload(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 5: {
                    BluetoothDevice _arg0 = data.readTypedObject(BluetoothDevice.CREATOR);
                    data.enforceNoDataAvail();
                    this.requestMaximumTxDataLength(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    ParcelUuid _arg0 = data.readTypedObject(ParcelUuid.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getL2capLocalChannelId(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 7: {
                    ParcelUuid _arg0 = data.readTypedObject(ParcelUuid.CREATOR);
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getL2capRemoteChannelId(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 6;
        }

        private static class Proxy
        implements IBluetoothSocketManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor connectSocket(BluetoothDevice device, int type, ParcelUuid uuid, int port, int flag) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(type);
                    _data.writeTypedObject(uuid, 0);
                    _data.writeInt(port);
                    _data.writeInt(flag);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelFileDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor connectSocketWithOffload(BluetoothDevice device, int type, ParcelUuid uuid, int port, int flag, int dataPath, String socketName, long hubId, long endpointId, int maximumPacketSize) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    _data.writeInt(type);
                    _data.writeTypedObject(uuid, 0);
                    _data.writeInt(port);
                    _data.writeInt(flag);
                    _data.writeInt(dataPath);
                    _data.writeString(socketName);
                    _data.writeLong(hubId);
                    _data.writeLong(endpointId);
                    _data.writeInt(maximumPacketSize);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelFileDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor createSocketChannel(int type, String serviceName, ParcelUuid uuid, int port, int flag) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(type);
                    _data.writeString(serviceName);
                    _data.writeTypedObject(uuid, 0);
                    _data.writeInt(port);
                    _data.writeInt(flag);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelFileDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParcelFileDescriptor createSocketChannelWithOffload(int type, String serviceName, ParcelUuid uuid, int port, int flag, int dataPath, String socketName, long hubId, long endpointId, int maximumPacketSize) throws RemoteException {
                ParcelFileDescriptor _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(type);
                    _data.writeString(serviceName);
                    _data.writeTypedObject(uuid, 0);
                    _data.writeInt(port);
                    _data.writeInt(flag);
                    _data.writeInt(dataPath);
                    _data.writeString(socketName);
                    _data.writeLong(hubId);
                    _data.writeLong(endpointId);
                    _data.writeInt(maximumPacketSize);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(ParcelFileDescriptor.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void requestMaximumTxDataLength(BluetoothDevice device) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(device, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getL2capLocalChannelId(ParcelUuid connectionUuid, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(connectionUuid, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getL2capRemoteChannelId(ParcelUuid connectionUuid, AttributionSource attributionSource) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(connectionUuid, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IBluetoothSocketManager {
        @Override
        public ParcelFileDescriptor connectSocket(BluetoothDevice device, int type, ParcelUuid uuid, int port, int flag) throws RemoteException {
            return null;
        }

        @Override
        public ParcelFileDescriptor connectSocketWithOffload(BluetoothDevice device, int type, ParcelUuid uuid, int port, int flag, int dataPath, String socketName, long hubId, long endpointId, int maximumPacketSize) throws RemoteException {
            return null;
        }

        @Override
        public ParcelFileDescriptor createSocketChannel(int type, String serviceName, ParcelUuid uuid, int port, int flag) throws RemoteException {
            return null;
        }

        @Override
        public ParcelFileDescriptor createSocketChannelWithOffload(int type, String serviceName, ParcelUuid uuid, int port, int flag, int dataPath, String socketName, long hubId, long endpointId, int maximumPacketSize) throws RemoteException {
            return null;
        }

        @Override
        public void requestMaximumTxDataLength(BluetoothDevice device) throws RemoteException {
        }

        @Override
        public int getL2capLocalChannelId(ParcelUuid connectionUuid, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public int getL2capRemoteChannelId(ParcelUuid connectionUuid, AttributionSource attributionSource) throws RemoteException {
            return 0;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

