/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.OobData;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBluetoothOobDataCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.bluetooth.IBluetoothOobDataCallback";

    public void onOobData(int var1, OobData var2) throws RemoteException;

    public void onError(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothOobDataCallback {
        static final int TRANSACTION_onOobData = 1;
        static final int TRANSACTION_onError = 2;

        public Stub() {
            this.attachInterface(this, IBluetoothOobDataCallback.DESCRIPTOR);
        }

        public static IBluetoothOobDataCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBluetoothOobDataCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothOobDataCallback) {
                return (IBluetoothOobDataCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onOobData";
                }
                case 2: {
                    return "onError";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBluetoothOobDataCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    OobData _arg1 = data.readTypedObject(OobData.CREATOR);
                    data.enforceNoDataAvail();
                    this.onOobData(_arg0, _arg1);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onError(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements IBluetoothOobDataCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBluetoothOobDataCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onOobData(int transport, OobData oobData) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothOobDataCallback.DESCRIPTOR);
                    _data.writeInt(transport);
                    _data.writeTypedObject(oobData, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(int errorCode) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IBluetoothOobDataCallback.DESCRIPTOR);
                    _data.writeInt(errorCode);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothOobDataCallback {
        @Override
        public void onOobData(int transport, OobData oobData) throws RemoteException {
        }

        @Override
        public void onError(int errorCode) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

