/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.RequiresPermission;
import android.bluetooth.IBluetoothGattServerCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertisingSetParameters;
import android.bluetooth.le.IAdvertisingSetCallback;
import android.bluetooth.le.PeriodicAdvertisingParameters;
import android.content.AttributionSource;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IBluetoothAdvertise
extends IInterface {
    public static final String DESCRIPTOR = "android.bluetooth.IBluetoothAdvertise";

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADVERTISE", "android.permission.BLUETOOTH_PRIVILEGED"}, conditional=true)
    public void startAdvertisingSet(AdvertisingSetParameters var1, AdvertiseData var2, AdvertiseData var3, PeriodicAdvertisingParameters var4, AdvertiseData var5, int var6, int var7, IBluetoothGattServerCallback var8, IAdvertisingSetCallback var9, AttributionSource var10) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void stopAdvertisingSet(IAdvertisingSetCallback var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADVERTISE", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void getOwnAddress(int var1, AttributionSource var2) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void enableAdvertisingSet(int var1, boolean var2, int var3, int var4, AttributionSource var5) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setAdvertisingData(int var1, AdvertiseData var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setScanResponseData(int var1, AdvertiseData var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_ADVERTISE", "android.permission.BLUETOOTH_PRIVILEGED"}, conditional=true)
    public void setAdvertisingParameters(int var1, AdvertisingSetParameters var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setPeriodicAdvertisingParameters(int var1, PeriodicAdvertisingParameters var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setPeriodicAdvertisingData(int var1, AdvertiseData var2, AttributionSource var3) throws RemoteException;

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public void setPeriodicAdvertisingEnable(int var1, boolean var2, AttributionSource var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetoothAdvertise {
        static final int TRANSACTION_startAdvertisingSet = 1;
        static final int TRANSACTION_stopAdvertisingSet = 2;
        static final int TRANSACTION_getOwnAddress = 3;
        static final int TRANSACTION_enableAdvertisingSet = 4;
        static final int TRANSACTION_setAdvertisingData = 5;
        static final int TRANSACTION_setScanResponseData = 6;
        static final int TRANSACTION_setAdvertisingParameters = 7;
        static final int TRANSACTION_setPeriodicAdvertisingParameters = 8;
        static final int TRANSACTION_setPeriodicAdvertisingData = 9;
        static final int TRANSACTION_setPeriodicAdvertisingEnable = 10;

        public Stub() {
            this.attachInterface(this, IBluetoothAdvertise.DESCRIPTOR);
        }

        public static IBluetoothAdvertise asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IBluetoothAdvertise.DESCRIPTOR);
            if (iin != null && iin instanceof IBluetoothAdvertise) {
                return (IBluetoothAdvertise)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "startAdvertisingSet";
                }
                case 2: {
                    return "stopAdvertisingSet";
                }
                case 3: {
                    return "getOwnAddress";
                }
                case 4: {
                    return "enableAdvertisingSet";
                }
                case 5: {
                    return "setAdvertisingData";
                }
                case 6: {
                    return "setScanResponseData";
                }
                case 7: {
                    return "setAdvertisingParameters";
                }
                case 8: {
                    return "setPeriodicAdvertisingParameters";
                }
                case 9: {
                    return "setPeriodicAdvertisingData";
                }
                case 10: {
                    return "setPeriodicAdvertisingEnable";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IBluetoothAdvertise.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    AdvertisingSetParameters _arg0 = data.readTypedObject(AdvertisingSetParameters.CREATOR);
                    AdvertiseData _arg1 = data.readTypedObject(AdvertiseData.CREATOR);
                    AdvertiseData _arg2 = data.readTypedObject(AdvertiseData.CREATOR);
                    PeriodicAdvertisingParameters _arg3 = data.readTypedObject(PeriodicAdvertisingParameters.CREATOR);
                    AdvertiseData _arg4 = data.readTypedObject(AdvertiseData.CREATOR);
                    int _arg5 = data.readInt();
                    int _arg6 = data.readInt();
                    IBluetoothGattServerCallback _arg7 = IBluetoothGattServerCallback.Stub.asInterface(data.readStrongBinder());
                    IAdvertisingSetCallback _arg8 = IAdvertisingSetCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg9 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.startAdvertisingSet(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7, _arg8, _arg9);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    IAdvertisingSetCallback _arg0 = IAdvertisingSetCallback.Stub.asInterface(data.readStrongBinder());
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.stopAdvertisingSet(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    AttributionSource _arg1 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.getOwnAddress(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    AttributionSource _arg4 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.enableAdvertisingSet(_arg0, _arg1, _arg2, _arg3, _arg4);
                    reply.writeNoException();
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    AdvertiseData _arg1 = data.readTypedObject(AdvertiseData.CREATOR);
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.setAdvertisingData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    AdvertiseData _arg1 = data.readTypedObject(AdvertiseData.CREATOR);
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.setScanResponseData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    AdvertisingSetParameters _arg1 = data.readTypedObject(AdvertisingSetParameters.CREATOR);
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.setAdvertisingParameters(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    PeriodicAdvertisingParameters _arg1 = data.readTypedObject(PeriodicAdvertisingParameters.CREATOR);
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.setPeriodicAdvertisingParameters(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    AdvertiseData _arg1 = data.readTypedObject(AdvertiseData.CREATOR);
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.setPeriodicAdvertisingData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    AttributionSource _arg2 = data.readTypedObject(AttributionSource.CREATOR);
                    data.enforceNoDataAvail();
                    this.setPeriodicAdvertisingEnable(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 9;
        }

        private static class Proxy
        implements IBluetoothAdvertise {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IBluetoothAdvertise.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, int duration, int maxExtAdvEvents, IBluetoothGattServerCallback gattServerCallback, IAdvertisingSetCallback callback, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothAdvertise.DESCRIPTOR);
                    _data.writeTypedObject(parameters, 0);
                    _data.writeTypedObject(advertiseData, 0);
                    _data.writeTypedObject(scanResponse, 0);
                    _data.writeTypedObject(periodicParameters, 0);
                    _data.writeTypedObject(periodicData, 0);
                    _data.writeInt(duration);
                    _data.writeInt(maxExtAdvEvents);
                    _data.writeStrongInterface(gattServerCallback);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopAdvertisingSet(IAdvertisingSetCallback callback, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothAdvertise.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getOwnAddress(int advertiserId, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothAdvertise.DESCRIPTOR);
                    _data.writeInt(advertiserId);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableAdvertisingSet(int advertiserId, boolean enable, int duration, int maxExtAdvEvents, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothAdvertise.DESCRIPTOR);
                    _data.writeInt(advertiserId);
                    _data.writeBoolean(enable);
                    _data.writeInt(duration);
                    _data.writeInt(maxExtAdvEvents);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAdvertisingData(int advertiserId, AdvertiseData data, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothAdvertise.DESCRIPTOR);
                    _data.writeInt(advertiserId);
                    _data.writeTypedObject(data, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setScanResponseData(int advertiserId, AdvertiseData data, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothAdvertise.DESCRIPTOR);
                    _data.writeInt(advertiserId);
                    _data.writeTypedObject(data, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAdvertisingParameters(int advertiserId, AdvertisingSetParameters parameters, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothAdvertise.DESCRIPTOR);
                    _data.writeInt(advertiserId);
                    _data.writeTypedObject(parameters, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPeriodicAdvertisingParameters(int advertiserId, PeriodicAdvertisingParameters parameters, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothAdvertise.DESCRIPTOR);
                    _data.writeInt(advertiserId);
                    _data.writeTypedObject(parameters, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPeriodicAdvertisingData(int advertiserId, AdvertiseData data, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothAdvertise.DESCRIPTOR);
                    _data.writeInt(advertiserId);
                    _data.writeTypedObject(data, 0);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPeriodicAdvertisingEnable(int advertiserId, boolean enable, AttributionSource attributionSource) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IBluetoothAdvertise.DESCRIPTOR);
                    _data.writeInt(advertiserId);
                    _data.writeBoolean(enable);
                    _data.writeTypedObject(attributionSource, 0);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IBluetoothAdvertise {
        @Override
        public void startAdvertisingSet(AdvertisingSetParameters parameters, AdvertiseData advertiseData, AdvertiseData scanResponse, PeriodicAdvertisingParameters periodicParameters, AdvertiseData periodicData, int duration, int maxExtAdvEvents, IBluetoothGattServerCallback gattServerCallback, IAdvertisingSetCallback callback, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void stopAdvertisingSet(IAdvertisingSetCallback callback, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void getOwnAddress(int advertiserId, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void enableAdvertisingSet(int advertiserId, boolean enable, int duration, int maxExtAdvEvents, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void setAdvertisingData(int advertiserId, AdvertiseData data, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void setScanResponseData(int advertiserId, AdvertiseData data, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void setAdvertisingParameters(int advertiserId, AdvertisingSetParameters parameters, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void setPeriodicAdvertisingParameters(int advertiserId, PeriodicAdvertisingParameters parameters, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void setPeriodicAdvertisingData(int advertiserId, AdvertiseData data, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public void setPeriodicAdvertisingEnable(int advertiserId, boolean enable, AttributionSource attributionSource) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

