/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresNoPermission;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.bluetooth.Attributable;
import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothA2dpSink;
import android.bluetooth.BluetoothActivityEnergyInfo;
import android.bluetooth.BluetoothAvrcpController;
import android.bluetooth.BluetoothCsipSetCoordinator;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothFrameworkInitializer;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothHapClient;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothHeadsetClient;
import android.bluetooth.BluetoothHearingAid;
import android.bluetooth.BluetoothHidDevice;
import android.bluetooth.BluetoothHidHost;
import android.bluetooth.BluetoothLeAudio;
import android.bluetooth.BluetoothLeBroadcast;
import android.bluetooth.BluetoothLeBroadcastAssistant;
import android.bluetooth.BluetoothLeCallControl;
import android.bluetooth.BluetoothMap;
import android.bluetooth.BluetoothMapClient;
import android.bluetooth.BluetoothPan;
import android.bluetooth.BluetoothPbap;
import android.bluetooth.BluetoothPbapClient;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothQualityReport;
import android.bluetooth.BluetoothSap;
import android.bluetooth.BluetoothServerSocket;
import android.bluetooth.BluetoothSocket;
import android.bluetooth.BluetoothSocketSettings;
import android.bluetooth.BluetoothUtils;
import android.bluetooth.BluetoothVolumeControl;
import android.bluetooth.CallbackWrapper;
import android.bluetooth.IBluetooth;
import android.bluetooth.IBluetoothActivityEnergyInfoListener;
import android.bluetooth.IBluetoothAdvertise;
import android.bluetooth.IBluetoothConnectionCallback;
import android.bluetooth.IBluetoothGatt;
import android.bluetooth.IBluetoothHciVendorSpecificCallback;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothManagerCallback;
import android.bluetooth.IBluetoothMetadataListener;
import android.bluetooth.IBluetoothOobDataCallback;
import android.bluetooth.IBluetoothPreferredAudioProfilesCallback;
import android.bluetooth.IBluetoothQualityReportReadyCallback;
import android.bluetooth.IBluetoothScan;
import android.bluetooth.IDistanceMeasurement;
import android.bluetooth.IncomingRfcommSocketInfo;
import android.bluetooth.OobData;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.DistanceMeasurementManager;
import android.bluetooth.le.PeriodicAdvertisingManager;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.AttributionSource;
import android.content.Context;
import android.os.Binder;
import android.os.BluetoothServiceManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IpcDataCache;
import android.os.Looper;
import android.os.ParcelUuid;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import com.android.bluetooth.jarjar.android.sysprop.BluetoothProperties;
import com.android.bluetooth.jarjar.com.android.bluetooth.flags.Flags;
import com.android.internal.annotations.GuardedBy;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;

public class BluetoothAdapter {
    private static final String TAG = BluetoothAdapter.class.getSimpleName();
    private static final String DESCRIPTOR = "android.bluetooth.BluetoothAdapter";
    private static final boolean VDBG = Log.isLoggable("bluetooth", 2);
    public static final String DEFAULT_MAC_ADDRESS = "02:00:00:00:00:00";
    public static final int ERROR = Integer.MIN_VALUE;
    public static final String ACTION_STATE_CHANGED = "android.bluetooth.adapter.action.STATE_CHANGED";
    public static final String EXTRA_STATE = "android.bluetooth.adapter.extra.STATE";
    public static final String EXTRA_PREVIOUS_STATE = "android.bluetooth.adapter.extra.PREVIOUS_STATE";
    public static final int STATE_OFF = 10;
    public static final int STATE_TURNING_ON = 11;
    public static final int STATE_ON = 12;
    public static final int STATE_TURNING_OFF = 13;
    public static final int STATE_BLE_TURNING_ON = 14;
    @SystemApi
    public static final int STATE_BLE_ON = 15;
    public static final int STATE_BLE_TURNING_OFF = 16;
    @SystemApi
    @SuppressLint(value={"ActionValue"})
    public static final String EXTRA_RFCOMM_LISTENER_ID = "android.bluetooth.adapter.extra.RFCOMM_LISTENER_ID";
    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public static final String ACTION_REQUEST_DISCOVERABLE = "android.bluetooth.adapter.action.REQUEST_DISCOVERABLE";
    public static final String EXTRA_DISCOVERABLE_DURATION = "android.bluetooth.adapter.extra.DISCOVERABLE_DURATION";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_REQUEST_ENABLE = "android.bluetooth.adapter.action.REQUEST_ENABLE";
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"ActionValue"})
    public static final String ACTION_REQUEST_DISABLE = "android.bluetooth.adapter.action.REQUEST_DISABLE";
    @SystemApi
    public static final String ACTION_REQUEST_BLE_SCAN_ALWAYS_AVAILABLE = "android.bluetooth.adapter.action.REQUEST_BLE_SCAN_ALWAYS_AVAILABLE";
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public static final String ACTION_SCAN_MODE_CHANGED = "android.bluetooth.adapter.action.SCAN_MODE_CHANGED";
    public static final String EXTRA_SCAN_MODE = "android.bluetooth.adapter.extra.SCAN_MODE";
    public static final String EXTRA_PREVIOUS_SCAN_MODE = "android.bluetooth.adapter.extra.PREVIOUS_SCAN_MODE";
    public static final int SCAN_MODE_NONE = 20;
    public static final int SCAN_MODE_CONNECTABLE = 21;
    public static final int SCAN_MODE_CONNECTABLE_DISCOVERABLE = 23;
    @SystemApi
    public static final int BT_SNOOP_LOG_MODE_DISABLED = 0;
    @SystemApi
    public static final int BT_SNOOP_LOG_MODE_FILTERED = 1;
    @SystemApi
    public static final int BT_SNOOP_LOG_MODE_FULL = 2;
    @SystemApi
    public static final int ACTIVE_DEVICE_AUDIO = 0;
    @SystemApi
    public static final int ACTIVE_DEVICE_PHONE_CALL = 1;
    @SystemApi
    public static final int ACTIVE_DEVICE_ALL = 2;
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public static final String ACTION_DISCOVERY_STARTED = "android.bluetooth.adapter.action.DISCOVERY_STARTED";
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public static final String ACTION_DISCOVERY_FINISHED = "android.bluetooth.adapter.action.DISCOVERY_FINISHED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_LOCAL_NAME_CHANGED = "android.bluetooth.adapter.action.LOCAL_NAME_CHANGED";
    public static final String EXTRA_LOCAL_NAME = "android.bluetooth.adapter.extra.LOCAL_NAME";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED";
    public static final String EXTRA_CONNECTION_STATE = "android.bluetooth.adapter.extra.CONNECTION_STATE";
    public static final String EXTRA_PREVIOUS_CONNECTION_STATE = "android.bluetooth.adapter.extra.PREVIOUS_CONNECTION_STATE";
    @SystemApi
    public static final String ACTION_BLE_STATE_CHANGED = "android.bluetooth.adapter.action.BLE_STATE_CHANGED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_BLUETOOTH_ADDRESS_CHANGED = "android.bluetooth.adapter.action.BLUETOOTH_ADDRESS_CHANGED";
    public static final String EXTRA_BLUETOOTH_ADDRESS = "android.bluetooth.adapter.extra.BLUETOOTH_ADDRESS";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_BLE_ACL_CONNECTED = "android.bluetooth.adapter.action.BLE_ACL_CONNECTED";
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public static final String ACTION_BLE_ACL_DISCONNECTED = "android.bluetooth.adapter.action.BLE_ACL_DISCONNECTED";
    public static final int STATE_DISCONNECTED = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_CONNECTED = 2;
    public static final int STATE_DISCONNECTING = 3;
    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public static final String ACTION_AUTO_ON_STATE_CHANGED = "android.bluetooth.action.AUTO_ON_STATE_CHANGED";
    @SystemApi
    public static final String EXTRA_AUTO_ON_STATE = "android.bluetooth.extra.AUTO_ON_STATE";
    @SystemApi
    public static final int AUTO_ON_STATE_DISABLED = 1;
    @SystemApi
    public static final int AUTO_ON_STATE_ENABLED = 2;
    @SystemApi
    public static final String AUDIO_MODE_OUTPUT_ONLY = "audio_mode_output_only";
    @SystemApi
    public static final String AUDIO_MODE_DUPLEX = "audio_mode_duplex";
    private final IBinder mToken = new Binder("android.bluetooth.BluetoothAdapter");
    public static final int SOCKET_CHANNEL_AUTO_STATIC_NO_SDP = -2;
    public static final Map<Integer, BiFunction<Context, BluetoothAdapter, BluetoothProfile>> PROFILE_CONSTRUCTORS = Map.ofEntries(Map.entry(1, BluetoothHeadset::new), Map.entry(2, BluetoothA2dp::new), Map.entry(11, BluetoothA2dpSink::new), Map.entry(12, BluetoothAvrcpController::new), Map.entry(4, BluetoothHidHost::new), Map.entry(5, BluetoothPan::new), Map.entry(6, BluetoothPbap::new), Map.entry(9, BluetoothMap::new), Map.entry(16, BluetoothHeadsetClient::new), Map.entry(10, BluetoothSap::new), Map.entry(17, BluetoothPbapClient::new), Map.entry(18, BluetoothMapClient::new), Map.entry(19, BluetoothHidDevice::new), Map.entry(28, BluetoothHapClient::new), Map.entry(21, BluetoothHearingAid::new), Map.entry(22, BluetoothLeAudio::new), Map.entry(26, BluetoothLeBroadcast::new), Map.entry(23, BluetoothVolumeControl::new), Map.entry(25, BluetoothCsipSetCoordinator::new), Map.entry(27, BluetoothLeCallControl::new), Map.entry(29, BluetoothLeBroadcastAssistant::new));
    private static final int ADDRESS_LENGTH = 17;
    private static BluetoothAdapter sAdapter;
    private BluetoothLeScanner mBluetoothLeScanner;
    private BluetoothLeAdvertiser mBluetoothLeAdvertiser;
    private PeriodicAdvertisingManager mPeriodicAdvertisingManager;
    private DistanceMeasurementManager mDistanceMeasurementManager;
    private final IBluetoothManager mManagerService;
    private final AttributionSource mAttributionSource;
    private final Optional<Context> mContext;
    @UnsupportedAppUsage
    @GuardedBy(value={"mServiceLock"})
    private IBluetooth mService;
    private static final ReentrantReadWriteLock sServiceLock;
    private final ReentrantReadWriteLock mServiceLock = new ReentrantReadWriteLock();
    @GuardedBy(value={"sServiceLock"})
    private static boolean sServiceRegistered;
    @GuardedBy(value={"sServiceLock"})
    private static IBluetooth sService;
    private final Object mLock = new Object();
    private final Map<LeScanCallback, ScanCallback> mLeScanClients = new HashMap<LeScanCallback, ScanCallback>();
    private final Map<BluetoothDevice, List<Pair<OnMetadataChangedListener, Executor>>> mMetadataListeners = new HashMap<BluetoothDevice, List<Pair<OnMetadataChangedListener, Executor>>>();
    private static final Object sProfileLock;
    @GuardedBy(value={"sProfileLock"})
    private final Map<BluetoothProfile, ProfileConnection> mProfileConnections = new ConcurrentHashMap<BluetoothProfile, ProfileConnection>();
    private final Handler mMainHandler = new Handler(Looper.getMainLooper());
    private final IBluetoothMetadataListener mBluetoothMetadataListener = new IBluetoothMetadataListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @RequiresNoPermission
        public void onMetadataChanged(BluetoothDevice device, int key, byte[] value) {
            Attributable.setAttributionSource(device, BluetoothAdapter.this.mAttributionSource);
            Map<BluetoothDevice, List<Pair<OnMetadataChangedListener, Executor>>> map = BluetoothAdapter.this.mMetadataListeners;
            synchronized (map) {
                if (!BluetoothAdapter.this.mMetadataListeners.containsKey(device)) {
                    return;
                }
                List<Pair<OnMetadataChangedListener, Executor>> list = BluetoothAdapter.this.mMetadataListeners.get(device);
                for (Pair<OnMetadataChangedListener, Executor> pair : list) {
                    OnMetadataChangedListener listener = (OnMetadataChangedListener)pair.first;
                    Executor executor = (Executor)pair.second;
                    BluetoothUtils.executeFromBinder(executor, () -> listener.onMetadataChanged(device, key, value));
                }
            }
        }
    };
    private static final IpcDataCache.QueryHandler<Void, Integer> sBluetoothGetSystemStateQuery;
    public static final String GET_SYSTEM_STATE_API = "BluetoothAdapter_getSystemState";
    private static final IpcDataCache<Void, Integer> sBluetoothGetSystemStateCache;
    private static final IpcDataCache.QueryHandler<IBluetooth, Boolean> sBluetoothFilteringQuery;
    private static final String FILTERING_API = "BluetoothAdapter_isOffloadedFilteringSupported";
    private static final IpcDataCache<IBluetooth, Boolean> sBluetoothFilteringCache;
    private static final IpcDataCache.QueryHandler<IBluetooth, Integer> sBluetoothGetAdapterConnectionStateQuery;
    private static final String GET_CONNECTION_API = "BluetoothAdapter_getConnectionState";
    private static final IpcDataCache<IBluetooth, Integer> sBluetoothGetAdapterConnectionStateCache;
    private static final IpcDataCache.QueryHandler<Pair<IBluetooth, Pair<AttributionSource, Integer>>, Integer> sBluetoothProfileQuery;
    private static final String PROFILE_API = "BluetoothAdapter_getProfileConnectionState";
    private static final IpcDataCache<Pair<IBluetooth, Pair<AttributionSource, Integer>>, Integer> sGetProfileConnectionStateCache;
    private static final IBluetoothManagerCallback sManagerCallback;
    private final IBluetoothManagerCallback mManagerCallback = new IBluetoothManagerCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
        @RequiresNoPermission
        public void onBluetoothServiceUp(@NonNull IBinder bluetoothService) {
            Objects.requireNonNull(bluetoothService);
            BluetoothAdapter.this.mServiceLock.writeLock().lock();
            try {
                BluetoothAdapter.this.mService = IBluetooth.Stub.asInterface(bluetoothService);
            }
            finally {
                BluetoothAdapter.this.mServiceLock.readLock().lock();
                BluetoothAdapter.this.mServiceLock.writeLock().unlock();
            }
            try {
                Object object = BluetoothAdapter.this.mMetadataListeners;
                synchronized (object) {
                    BluetoothAdapter.this.mMetadataListeners.forEach((device, pair) -> {
                        try {
                            BluetoothAdapter.this.mService.registerMetadataListener(BluetoothAdapter.this.mBluetoothMetadataListener, (BluetoothDevice)device, BluetoothAdapter.this.mAttributionSource);
                        }
                        catch (RemoteException e) {
                            Log.e(TAG, "Failed to register metadata listener", e);
                            BluetoothUtils.logRemoteException(TAG, e);
                        }
                    });
                }
                BluetoothAdapter.this.mAudioProfilesCallbackWrapper.registerToNewService(BluetoothAdapter.this.mService);
                BluetoothAdapter.this.mQualityCallbackWrapper.registerToNewService(BluetoothAdapter.this.mService);
                BluetoothAdapter.this.mBluetoothConnectionCallbackWrapper.registerToNewService(BluetoothAdapter.this.mService);
                object = BluetoothAdapter.this.mHciVendorSpecificCallbackRegistration;
                synchronized (object) {
                    try {
                        BluetoothAdapter.this.mHciVendorSpecificCallbackRegistration.registerToService(BluetoothAdapter.this.mService, BluetoothAdapter.this.mHciVendorSpecificCallbackStub);
                    }
                    catch (Exception e) {
                        Log.e(TAG, "Failed to register HCI vendor-specific callback", e);
                    }
                }
            }
            finally {
                BluetoothAdapter.this.mServiceLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @RequiresNoPermission
        public void onBluetoothServiceDown() {
            BluetoothAdapter.this.mServiceLock.writeLock().lock();
            try {
                BluetoothAdapter.this.mService = null;
                BluetoothAdapter.this.mLeScanClients.clear();
                Object object = BluetoothAdapter.this.mLock;
                synchronized (object) {
                    if (BluetoothAdapter.this.mBluetoothLeAdvertiser != null) {
                        BluetoothAdapter.this.mBluetoothLeAdvertiser.cleanup();
                    }
                    if (BluetoothAdapter.this.mBluetoothLeScanner != null) {
                        BluetoothAdapter.this.mBluetoothLeScanner.cleanup();
                    }
                    if (BluetoothAdapter.this.mDistanceMeasurementManager != null) {
                        BluetoothAdapter.this.mDistanceMeasurementManager.cleanup();
                    }
                }
            }
            finally {
                BluetoothAdapter.this.mServiceLock.writeLock().unlock();
            }
        }

        @GuardedBy(value={"sProfileLock"})
        private boolean connectAllProfileProxyLocked() {
            BluetoothAdapter.this.mProfileConnections.forEach((proxy, connection) -> {
                if (connection.mConnected) {
                    return;
                }
                IBinder binder = BluetoothAdapter.this.getProfile(connection.mProfile);
                if (binder == null) {
                    Log.e(TAG, "Failed to retrieve a binder for " + BluetoothProfile.getProfileName(connection.mProfile));
                    return;
                }
                connection.connect((BluetoothProfile)proxy, binder);
            });
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @RequiresNoPermission
        public void onBluetoothOn() {
            Object object = sProfileLock;
            synchronized (object) {
                this.connectAllProfileProxyLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @RequiresNoPermission
        public void onBluetoothOff() {
            Object object = sProfileLock;
            synchronized (object) {
                BluetoothAdapter.this.mProfileConnections.forEach((proxy, connection) -> {
                    if (connection.mConnected) {
                        connection.disconnect((BluetoothProfile)proxy);
                    }
                });
            }
        }
    };
    @GuardedBy(value={"sServiceLock"})
    private static final WeakHashMap<IBluetoothManagerCallback, Void> sProxyServiceStateCallbacks;
    private final CallbackWrapper<BluetoothConnectionCallback, IBluetooth> mBluetoothConnectionCallbackWrapper;
    private final IBluetoothConnectionCallback mBluetoothConnectionCallback = new IBluetoothConnectionCallback.Stub(){

        @Override
        @RequiresNoPermission
        public void onDeviceConnected(BluetoothDevice device) {
            Attributable.setAttributionSource(device, BluetoothAdapter.this.mAttributionSource);
            BluetoothAdapter.this.mBluetoothConnectionCallbackWrapper.forEach(cb -> cb.onDeviceConnected(device));
        }

        @Override
        @RequiresNoPermission
        public void onDeviceDisconnected(BluetoothDevice device, int hciReason) {
            Attributable.setAttributionSource(device, BluetoothAdapter.this.mAttributionSource);
            BluetoothAdapter.this.mBluetoothConnectionCallbackWrapper.forEach(cb -> cb.onDeviceDisconnected(device, hciReason));
        }
    };
    private final CallbackWrapper<PreferredAudioProfilesChangedCallback, IBluetooth> mAudioProfilesCallbackWrapper;
    private final IBluetoothPreferredAudioProfilesCallback mPreferredAudioProfilesChangedCallback = new IBluetoothPreferredAudioProfilesCallback.Stub(){

        @Override
        @RequiresNoPermission
        public void onPreferredAudioProfilesChanged(BluetoothDevice device, Bundle preferredAudioProfiles, int status) {
            BluetoothAdapter.this.mAudioProfilesCallbackWrapper.forEach(cb -> cb.onPreferredAudioProfilesChanged(device, preferredAudioProfiles, status));
        }
    };
    private final CallbackWrapper<BluetoothQualityReportReadyCallback, IBluetooth> mQualityCallbackWrapper;
    private final IBluetoothQualityReportReadyCallback mBluetoothQualityReportReadyCallback = new IBluetoothQualityReportReadyCallback.Stub(){

        @Override
        @RequiresNoPermission
        public void onBluetoothQualityReportReady(BluetoothDevice device, BluetoothQualityReport report, int status) {
            BluetoothAdapter.this.mQualityCallbackWrapper.forEach(cb -> cb.onBluetoothQualityReportReady(device, report, status));
        }
    };
    private final HciVendorSpecificCallbackRegistration mHciVendorSpecificCallbackRegistration = new HciVendorSpecificCallbackRegistration();
    private final IBluetoothHciVendorSpecificCallback mHciVendorSpecificCallbackStub = new IBluetoothHciVendorSpecificCallback.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @RequiresNoPermission
        public void onCommandStatus(int ocf, int status) {
            HciVendorSpecificCallbackRegistration hciVendorSpecificCallbackRegistration = BluetoothAdapter.this.mHciVendorSpecificCallbackRegistration;
            synchronized (hciVendorSpecificCallbackRegistration) {
                if (Flags.hciVendorSpecificExtension()) {
                    BluetoothAdapter.this.mHciVendorSpecificCallbackRegistration.execute(cb -> cb.onCommandStatus(ocf, status));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @RequiresNoPermission
        public void onCommandComplete(int ocf, byte[] returnParameters) {
            HciVendorSpecificCallbackRegistration hciVendorSpecificCallbackRegistration = BluetoothAdapter.this.mHciVendorSpecificCallbackRegistration;
            synchronized (hciVendorSpecificCallbackRegistration) {
                if (Flags.hciVendorSpecificExtension()) {
                    BluetoothAdapter.this.mHciVendorSpecificCallbackRegistration.execute(cb -> cb.onCommandComplete(ocf, returnParameters));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @RequiresNoPermission
        public void onEvent(int code, byte[] data) {
            HciVendorSpecificCallbackRegistration hciVendorSpecificCallbackRegistration = BluetoothAdapter.this.mHciVendorSpecificCallbackRegistration;
            synchronized (hciVendorSpecificCallbackRegistration) {
                if (Flags.hciVendorSpecificExtension()) {
                    BluetoothAdapter.this.mHciVendorSpecificCallbackRegistration.execute(cb -> cb.onEvent(code, data));
                }
            }
        }
    };

    @SystemApi
    @RequiresNoPermission
    @NonNull
    public static String nameForState(int state) {
        String string2;
        switch (state) {
            case 10: {
                string2 = "OFF";
                break;
            }
            case 11: {
                string2 = "TURNING_ON";
                break;
            }
            case 12: {
                string2 = "ON";
                break;
            }
            case 13: {
                string2 = "TURNING_OFF";
                break;
            }
            case 14: {
                string2 = "BLE_TURNING_ON";
                break;
            }
            case 15: {
                string2 = "BLE_ON";
                break;
            }
            case 16: {
                string2 = "BLE_TURNING_OFF";
                break;
            }
            default: {
                string2 = "?!?!? (" + state + ")";
            }
        }
        return string2;
    }

    @Deprecated
    @RequiresNoPermission
    public static synchronized BluetoothAdapter getDefaultAdapter() {
        if (sAdapter == null) {
            sAdapter = BluetoothAdapter.createAdapter(null);
        }
        return sAdapter;
    }

    public static BluetoothAdapter createAdapter(Context context) {
        BluetoothServiceManager manager = BluetoothFrameworkInitializer.getBluetoothServiceManager();
        if (manager == null) {
            Log.e(TAG, "BluetoothServiceManager is null");
            return null;
        }
        IBluetoothManager service = IBluetoothManager.Stub.asInterface(manager.getBluetoothManagerServiceRegisterer().get());
        if (service != null) {
            return new BluetoothAdapter(service, context);
        }
        Log.e(TAG, "Bluetooth service is null");
        return null;
    }

    private BluetoothAdapter(IBluetoothManager managerService, @Nullable Context context) {
        this(managerService, context, context != null ? context.getAttributionSource() : AttributionSource.myAttributionSource());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BluetoothAdapter(@NonNull IBluetoothManager managerService, @Nullable Context context, @NonNull AttributionSource source) {
        this.mManagerService = Objects.requireNonNull(managerService);
        this.mContext = Optional.ofNullable(context);
        this.mAttributionSource = Objects.requireNonNull(source);
        this.mQualityCallbackWrapper = new CallbackWrapper(this::registerBluetoothQualityReportCallbackFn, this::unregisterBluetoothQualityReportCallbackFn);
        this.mAudioProfilesCallbackWrapper = new CallbackWrapper(this::registerAudioProfilesCallbackFn, this::unregisterAudioProfilesCallbackFn);
        this.mBluetoothConnectionCallbackWrapper = new CallbackWrapper(this::registerBluetoothConnectionCallbackFn, this::unregisterBluetoothConnectionCallbackFn);
        this.mServiceLock.writeLock().lock();
        try {
            this.mService = this.registerBluetoothManagerCallback(this.mManagerCallback);
        }
        finally {
            this.mServiceLock.writeLock().unlock();
        }
    }

    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    private void enforcePermissionInFramework(String ... permissions) {
        this.mContext.ifPresent(ctx -> {
            int pid = Process.myPid();
            int uid = Process.myUid();
            for (String permission2 : permissions) {
                ctx.enforcePermission(permission2, pid, uid, null);
            }
        });
    }

    @RequiresNoPermission
    public BluetoothDevice getRemoteDevice(String address) {
        BluetoothDevice res = new BluetoothDevice(address);
        res.setAttributionSource(this.mAttributionSource);
        return res;
    }

    @RequiresNoPermission
    @NonNull
    public BluetoothDevice getRemoteLeDevice(@NonNull String address, int addressType) {
        BluetoothDevice res = new BluetoothDevice(address, addressType);
        res.setAttributionSource(this.mAttributionSource);
        return res;
    }

    @RequiresNoPermission
    public BluetoothDevice getRemoteDevice(byte[] address) {
        if (address == null || address.length != 6) {
            throw new IllegalArgumentException("Bluetooth address must have 6 bytes");
        }
        BluetoothDevice res = new BluetoothDevice(String.format(Locale.US, "%02X:%02X:%02X:%02X:%02X:%02X", address[0], address[1], address[2], address[3], address[4], address[5]));
        res.setAttributionSource(this.mAttributionSource);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresNoPermission
    public BluetoothLeAdvertiser getBluetoothLeAdvertiser() {
        if (!this.getLeAccess()) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mBluetoothLeAdvertiser == null) {
                this.mBluetoothLeAdvertiser = new BluetoothLeAdvertiser(this);
            }
            return this.mBluetoothLeAdvertiser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresNoPermission
    public PeriodicAdvertisingManager getPeriodicAdvertisingManager() {
        if (!this.getLeAccess()) {
            return null;
        }
        if (!this.isLePeriodicAdvertisingSupported()) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPeriodicAdvertisingManager == null) {
                this.mPeriodicAdvertisingManager = new PeriodicAdvertisingManager(this);
            }
            return this.mPeriodicAdvertisingManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresNoPermission
    public BluetoothLeScanner getBluetoothLeScanner() {
        if (!this.getLeAccess()) {
            return null;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mBluetoothLeScanner == null) {
                this.mBluetoothLeScanner = new BluetoothLeScanner(this);
            }
            return this.mBluetoothLeScanner;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    @Nullable
    public DistanceMeasurementManager getDistanceMeasurementManager() {
        if (!this.getLeAccess()) {
            return null;
        }
        if (this.isDistanceMeasurementSupported() != 10) {
            throw new UnsupportedOperationException("Distance measurement is unsupported");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mDistanceMeasurementManager == null) {
                this.mDistanceMeasurementManager = new DistanceMeasurementManager(this);
            }
            return this.mDistanceMeasurementManager;
        }
    }

    @RequiresNoPermission
    public boolean isEnabled() {
        return this.getState() == 12;
    }

    @SystemApi
    @RequiresNoPermission
    public boolean isLeEnabled() {
        int state = this.getLeState();
        Log.d(TAG, "isLeEnabled(): " + BluetoothAdapter.nameForState(state));
        return state == 12 || state == 15 || state == 11 || state == 13;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean disableBLE() {
        if (!this.isBleScanAlwaysAvailable()) {
            return false;
        }
        try {
            return this.mManagerService.disableBle(this.mAttributionSource, this.mToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean enableBLE() {
        if (!this.isBleScanAlwaysAvailable()) {
            return false;
        }
        try {
            return this.mManagerService.enableBle(this.mAttributionSource, this.mToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static void invalidateCache(@NonNull String api) {
        IpcDataCache.invalidateCache("bluetooth", api);
    }

    @RequiresNoPermission
    public int getState() {
        int state = sBluetoothGetSystemStateCache.query(null);
        if (state == 15 || state == 14 || state == 16) {
            if (VDBG) {
                Log.d(TAG, "Consider " + BluetoothAdapter.nameForState(state) + " state as OFF");
            }
            state = 10;
        }
        return state;
    }

    @RequiresNoPermission
    @UnsupportedAppUsage(publicAlternatives="Use {@link #getState()} instead to determine whether you can use BLE & BT classic.")
    public int getLeState() {
        int state = sBluetoothGetSystemStateCache.query(null);
        return state;
    }

    boolean getLeAccess() {
        int state = this.getLeState();
        return !Flags.returnCorrectBleState() ? state == 12 || state == 15 : state == 12 || state == 15 || state == 13 || state == 11;
    }

    @Deprecated
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean enable() {
        if (this.isEnabled()) {
            Log.d(TAG, "enable(): BT already enabled!");
            return true;
        }
        try {
            return this.mManagerService.enable(this.mAttributionSource);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public boolean disable() {
        return this.disable(true);
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"}, conditional=true)
    public boolean disable(boolean persist) {
        try {
            return this.mManagerService.disable(this.mAttributionSource, persist);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.LOCAL_MAC_ADDRESS"})
    public String getAddress() {
        try {
            return this.mManagerService.getAddress(this.mAttributionSource);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public String getName() {
        try {
            return this.mManagerService.getName(this.mAttributionSource);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADVERTISE")
    public int getNameLengthForAdvertise() {
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                int n = this.mService.getNameLengthForAdvertise(this.mAttributionSource);
                return n;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return -1;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean clearBluetooth() {
        if (Flags.factoryResetFromTheSystemServer()) {
            try {
                return this.mManagerService.factoryReset(this.mAttributionSource);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                if (Flags.gattClearCacheOnFactoryReset()) {
                    BluetoothProperties.factory_reset(true);
                }
                if (this.mService.factoryReset(this.mAttributionSource) && this.mManagerService.onFactoryReset(this.mAttributionSource)) {
                    boolean e = true;
                    return e;
                }
            }
            if (!Flags.gattClearCacheOnFactoryReset()) {
                Log.e(TAG, "factoryReset(): Setting persist.bluetooth.factoryreset to retry later");
                BluetoothProperties.factory_reset(true);
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean factoryReset() {
        return this.clearBluetooth();
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @NonNull
    public ParcelUuid[] getUuids() {
        List<ParcelUuid> parcels = this.getUuidsList();
        return parcels.toArray(new ParcelUuid[parcels.size()]);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @NonNull
    public List<ParcelUuid> getUuidsList() {
        ArrayList<ParcelUuid> defaultValue = new ArrayList<ParcelUuid>();
        if (this.getState() != 12) {
            return defaultValue;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                List<ParcelUuid> list = this.mService.getUuids(this.mAttributionSource);
                return list;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return defaultValue;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean setName(String name) {
        if (this.getState() != 12) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                boolean bl = this.mService.setName(name, this.mAttributionSource);
                return bl;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public int getScanMode() {
        if (this.getState() != 12) {
            return 20;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                int n = this.mService.getScanMode(this.mAttributionSource);
                return n;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 20;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int setScanMode(int mode) {
        if (this.getState() != 12) {
            return 1;
        }
        if (mode != 20 && mode != 21 && mode != 23) {
            throw new IllegalArgumentException("Invalid scan mode param value");
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                int n = this.mService.setScanMode(mode, this.mAttributionSource);
                return n;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    @Nullable
    public Duration getDiscoverableTimeout() {
        if (this.getState() != 12) {
            return null;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                long timeout = this.mService.getDiscoverableTimeout(this.mAttributionSource);
                Duration duration = timeout == -1L ? null : Duration.ofSeconds(timeout);
                return duration;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return null;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int setDiscoverableTimeout(@NonNull Duration timeout) {
        if (this.getState() != 12) {
            return 1;
        }
        if (timeout.toSeconds() > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Timeout in seconds must be less or equal to 2147483647");
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                int n = this.mService.setDiscoverableTimeout(timeout.toSeconds(), this.mAttributionSource);
                return n;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return Integer.MAX_VALUE;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public long getDiscoveryEndMillis() {
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                long l = this.mService.getDiscoveryEndMillis(this.mAttributionSource);
                return l;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return -1L;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean startDiscovery() {
        if (this.getState() != 12) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                boolean bl = this.mService.startDiscovery(this.mAttributionSource);
                return bl;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean cancelDiscovery() {
        if (this.getState() != 12) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                boolean bl = this.mService.cancelDiscovery(this.mAttributionSource);
                return bl;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean isDiscovering() {
        if (this.getState() != 12) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                boolean bl = this.mService.isDiscovering(this.mAttributionSource);
                return bl;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED", "android.permission.MODIFY_PHONE_STATE"})
    public boolean removeActiveDevice(int profiles) {
        if (profiles != 0 && profiles != 1 && profiles != 2) {
            Log.e(TAG, "Invalid profiles param value in removeActiveDevice");
            throw new IllegalArgumentException("Profiles must be one of BluetoothAdapter.ACTIVE_DEVICE_AUDIO, BluetoothAdapter.ACTIVE_DEVICE_PHONE_CALL, or BluetoothAdapter.ACTIVE_DEVICE_ALL");
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                Log.d(TAG, "removeActiveDevice, profiles: " + profiles);
                boolean bl = this.mService.removeActiveDevice(profiles, this.mAttributionSource);
                return bl;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED", "android.permission.MODIFY_PHONE_STATE"})
    public boolean setActiveDevice(@NonNull BluetoothDevice device, int profiles) {
        if (device == null) {
            Log.e(TAG, "setActiveDevice: Null device passed as parameter");
            throw new IllegalArgumentException("device cannot be null");
        }
        if (profiles != 0 && profiles != 1 && profiles != 2) {
            Log.e(TAG, "Invalid profiles param value in setActiveDevice");
            throw new IllegalArgumentException("Profiles must be one of BluetoothAdapter.ACTIVE_DEVICE_AUDIO, BluetoothAdapter.ACTIVE_DEVICE_PHONE_CALL, or BluetoothAdapter.ACTIVE_DEVICE_ALL");
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                Log.d(TAG, "setActiveDevice, device: " + device + ", profiles: " + profiles);
                boolean bl = this.mService.setActiveDevice(device, profiles, this.mAttributionSource);
                return bl;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    @NonNull
    public List<BluetoothDevice> getActiveDevices(int profile) {
        if (profile != 1 && profile != 2 && profile != 21 && profile != 22) {
            Log.e(TAG, "Invalid profile param value in getActiveDevices");
            throw new IllegalArgumentException("Profiles must be one of BluetoothProfile.A2DP, BluetoothProfile.HEADSET, BluetoothProfile.HEARING_AID, or BluetoothProfile.LE_AUDIO");
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                Log.d(TAG, "getActiveDevices(" + BluetoothProfile.getProfileName(profile) + ")");
                List<BluetoothDevice> list = this.mService.getActiveDevices(profile, this.mAttributionSource);
                return list;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return Collections.emptyList();
    }

    @RequiresNoPermission
    public boolean isMultipleAdvertisementSupported() {
        if (this.getState() != 12) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                boolean bl = this.mService.isMultiAdvertisementSupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @SystemApi
    @RequiresNoPermission
    public boolean isBleScanAlwaysAvailable() {
        try {
            return this.mManagerService.isBleScanAvailable();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresNoPermission
    public void disableIsOffloadedFilteringSupportedCache() {
        sBluetoothFilteringCache.disableForCurrentProcess();
    }

    public static void invalidateIsOffloadedFilteringSupportedCache() {
        BluetoothAdapter.invalidateCache(FILTERING_API);
    }

    @RequiresNoPermission
    public boolean isOffloadedFilteringSupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                boolean bl = sBluetoothFilteringCache.query(this.mService);
                return bl;
            }
        }
        catch (RuntimeException e) {
            if (!(e.getCause() instanceof RemoteException)) {
                throw e;
            }
            Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresNoPermission
    public boolean isOffloadedScanBatchingSupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                boolean bl = this.mService.isOffloadedScanBatchingSupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresNoPermission
    public boolean isLe2MPhySupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                boolean bl = this.mService.isLe2MPhySupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresNoPermission
    public boolean isLeCodedPhySupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                boolean bl = this.mService.isLeCodedPhySupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresNoPermission
    public boolean isLeExtendedAdvertisingSupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                boolean bl = this.mService.isLeExtendedAdvertisingSupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresNoPermission
    public boolean isLePeriodicAdvertisingSupported() {
        if (!this.getLeAccess()) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                boolean bl = this.mService.isLePeriodicAdvertisingSupported();
                return bl;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @RequiresNoPermission
    public int isLeAudioSupported() {
        if (!this.getLeAccess()) {
            return 1;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                int n = this.mService.isLeAudioSupported();
                return n;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 1;
    }

    @RequiresNoPermission
    public int isLeAudioBroadcastSourceSupported() {
        if (!this.getLeAccess()) {
            return 1;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                int n = this.mService.isLeAudioBroadcastSourceSupported();
                return n;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 1;
    }

    @RequiresNoPermission
    public int isLeAudioBroadcastAssistantSupported() {
        if (!this.getLeAccess()) {
            return 1;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                int n = this.mService.isLeAudioBroadcastAssistantSupported();
                return n;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 1;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int isDistanceMeasurementSupported() {
        if (!this.getLeAccess()) {
            return 1;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                int n = this.mService.isDistanceMeasurementSupported(this.mAttributionSource);
                return n;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 1;
    }

    @RequiresNoPermission
    public int getLeMaximumAdvertisingDataLength() {
        if (!this.getLeAccess()) {
            return 0;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                int n = this.mService.getLeMaximumAdvertisingDataLength();
                return n;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 0;
    }

    @RequiresNoPermission
    private boolean isHearingAidProfileSupported() {
        try {
            return this.mManagerService.isHearingAidProfileSupported();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public int getMaxConnectedAudioDevices() {
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                int n = this.mService.getMaxConnectedAudioDevices(this.mAttributionSource);
                return n;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return -1;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean isHardwareTrackingFiltersAvailable() {
        if (!this.getLeAccess()) {
            return false;
        }
        try {
            IBluetoothScan scan = this.getBluetoothScan();
            if (scan == null) {
                return false;
            }
            return scan.numHwTrackFiltersAvailable(this.mAttributionSource) != 0;
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void requestControllerActivityEnergyInfo(@NonNull Executor executor, @NonNull OnBluetoothActivityEnergyInfoCallback callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        OnBluetoothActivityEnergyInfoProxy proxy = new OnBluetoothActivityEnergyInfoProxy(executor, callback);
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                this.mService.requestActivityInfo(proxy, this.mAttributionSource);
            } else {
                proxy.onError(9);
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
            proxy.onError(Integer.MAX_VALUE);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    @NonNull
    public List<BluetoothDevice> getMostRecentlyConnectedDevices() {
        if (this.getState() != 12) {
            return Collections.emptyList();
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                List<BluetoothDevice> list = Attributable.setAttributionSource(this.mService.getMostRecentlyConnectedDevices(this.mAttributionSource), this.mAttributionSource);
                return list;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return Collections.emptyList();
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public Set<BluetoothDevice> getBondedDevices() {
        if (this.getState() != 12) {
            return BluetoothAdapter.toDeviceSet(Arrays.asList(new BluetoothDevice[0]));
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                Set<BluetoothDevice> set = BluetoothAdapter.toDeviceSet(Attributable.setAttributionSource(this.mService.getBondedDevices(this.mAttributionSource), this.mAttributionSource));
                return set;
            }
            Set<BluetoothDevice> set = BluetoothAdapter.toDeviceSet(Arrays.asList(new BluetoothDevice[0]));
            return set;
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    @NonNull
    public List<Integer> getSupportedProfiles() {
        ArrayList<Integer> supportedProfiles = new ArrayList<Integer>();
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                long supportedProfilesBitMask = this.mService.getSupportedProfiles(this.mAttributionSource);
                for (int i = 0; i <= 31; ++i) {
                    if ((supportedProfilesBitMask & (long)(1 << i)) == 0L) continue;
                    supportedProfiles.add(i);
                }
            } else if (this.isHearingAidProfileSupported()) {
                supportedProfiles.add(21);
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return supportedProfiles;
    }

    @RequiresNoPermission
    public void disableGetAdapterConnectionStateCache() {
        sBluetoothGetAdapterConnectionStateCache.disableForCurrentProcess();
    }

    public static void invalidateGetAdapterConnectionStateCache() {
        BluetoothAdapter.invalidateCache(GET_CONNECTION_API);
    }

    @SystemApi
    @RequiresNoPermission
    public int getConnectionState() {
        if (this.getState() != 12) {
            return 0;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                int n = sBluetoothGetAdapterConnectionStateCache.query(this.mService);
                return n;
            }
        }
        catch (RuntimeException e) {
            if (!(e.getCause() instanceof RemoteException)) {
                throw e;
            }
            Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 0;
    }

    @RequiresNoPermission
    public void disableGetProfileConnectionStateCache() {
        sGetProfileConnectionStateCache.disableForCurrentProcess();
    }

    public static void invalidateGetProfileConnectionStateCache() {
        BluetoothAdapter.invalidateCache(PROFILE_API);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    public int getProfileConnectionState(int profile) {
        if (this.getState() != 12) {
            return 0;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                int n = sGetProfileConnectionStateCache.query(new Pair<IBluetooth, Pair<AttributionSource, Integer>>(this.mService, new Pair<AttributionSource, Integer>(this.mAttributionSource, profile)));
                return n;
            }
        }
        catch (RuntimeException e) {
            if (!(e.getCause() instanceof RemoteException)) {
                throw e;
            }
            Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 0;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingRfcommOn(int channel) throws IOException {
        return this.listenUsingRfcommOn(channel, false, false);
    }

    @UnsupportedAppUsage
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingRfcommOn(int channel, boolean mitm, boolean min16DigitPin) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, true, true, channel, mitm, min16DigitPin);
        int errno = socket.mSocket.bindListen();
        if (channel == -2) {
            socket.setChannel(socket.mSocket.getPort());
        }
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return BluetoothAdapter.createNewRfcommSocketAndRecord(name, uuid, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int startRfcommServer(@NonNull String name, @NonNull UUID uuid, @NonNull PendingIntent pendingIntent) {
        if (!pendingIntent.isImmutable()) {
            throw new IllegalArgumentException("The provided PendingIntent is not immutable");
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                int n = this.mService.startRfcommListener(name, new ParcelUuid(uuid), pendingIntent, this.mAttributionSource);
                return n;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 9;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int stopRfcommServer(@NonNull UUID uuid) {
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                int n = this.mService.stopRfcommListener(new ParcelUuid(uuid), this.mAttributionSource);
                return n;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    @NonNull
    public BluetoothSocket retrieveConnectedRfcommSocket(@NonNull UUID uuid) {
        IncomingRfcommSocketInfo socketInfo = null;
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                socketInfo = this.mService.retrievePendingSocketForServiceRecord(new ParcelUuid(uuid), this.mAttributionSource);
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
            BluetoothSocket bluetoothSocket = null;
            return bluetoothSocket;
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        if (socketInfo == null) {
            return null;
        }
        switch (socketInfo.status) {
            case 0: {
                try {
                    return BluetoothSocket.createSocketFromOpenFd(socketInfo.pfd, socketInfo.bluetoothDevice, new ParcelUuid(uuid));
                }
                catch (IOException e) {
                    return null;
                }
            }
            case 2002: {
                throw new IllegalStateException("RFCOMM listener for UUID " + uuid + " was not registered by this app");
            }
            case 2005: {
                return null;
            }
        }
        Log.e(TAG, "Unexpected result: (" + socketInfo.status + "), from the adapter service while retrieving an rfcomm socket");
        return null;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingInsecureRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return BluetoothAdapter.createNewRfcommSocketAndRecord(name, uuid, false, false);
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingEncryptedRfcommWithServiceRecord(String name, UUID uuid) throws IOException {
        return BluetoothAdapter.createNewRfcommSocketAndRecord(name, uuid, false, true);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    private static BluetoothServerSocket createNewRfcommSocketAndRecord(String name, UUID uuid, boolean auth, boolean encrypt) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, auth, encrypt, new ParcelUuid(uuid));
        socket.setServiceName(name);
        int errno = socket.mSocket.bindListen();
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingInsecureRfcommOn(int port) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(1, false, false, port);
        int errno = socket.mSocket.bindListen();
        if (port == -2) {
            socket.setChannel(socket.mSocket.getPort());
        }
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingL2capOn(int port, boolean mitm, boolean min16DigitPin) throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(3, true, true, port, mitm, min16DigitPin);
        int errno = socket.mSocket.bindListen();
        if (port == -2) {
            int assignedChannel = socket.mSocket.getPort();
            Log.d(TAG, "listenUsingL2capOn: set assigned channel to " + assignedChannel);
            socket.setChannel(assignedChannel);
        }
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingL2capOn(int port) throws IOException {
        return this.listenUsingL2capOn(port, false, false);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public BluetoothServerSocket listenUsingInsecureL2capOn(int port) throws IOException {
        Log.d(TAG, "listenUsingInsecureL2capOn: port=" + port);
        BluetoothServerSocket socket = new BluetoothServerSocket(3, false, false, port, false, false);
        int errno = socket.mSocket.bindListen();
        if (port == -2) {
            int assignedChannel = socket.mSocket.getPort();
            Log.d(TAG, "listenUsingInsecureL2capOn: set assigned channel to " + assignedChannel);
            socket.setChannel(assignedChannel);
        }
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        return socket;
    }

    @SuppressLint(value={"AndroidFrameworkCompatChange"})
    @RequiresNoPermission
    public boolean getProfileProxy(Context context, BluetoothProfile.ServiceListener listener, int profile) {
        if (context == null || listener == null) {
            return false;
        }
        if (context.getApplicationInfo().targetSdkVersion < 31 && context.checkSelfPermission("android.permission.BLUETOOTH") != 0) {
            throw new SecurityException("Need BLUETOOTH permission");
        }
        return this.getProfileProxy(context, listener, profile, this.mMainHandler::post);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getProfileProxy(@NonNull Context context, @NonNull BluetoothProfile.ServiceListener listener, int profile, @NonNull Executor executor) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(listener);
        Objects.requireNonNull(executor);
        if (profile == 3) {
            Log.e(TAG, "getProfileProxy(): BluetoothHealth is deprecated");
            return false;
        }
        if (profile == 21 && !this.isHearingAidProfileSupported()) {
            Log.e(TAG, "getProfileProxy(): BluetoothHearingAid is not supported");
            return false;
        }
        BiFunction<Context, BluetoothAdapter, BluetoothProfile> constructor = PROFILE_CONSTRUCTORS.get(profile);
        if (constructor == null) {
            Log.e(TAG, "getProfileProxy(): Unknown profile " + profile);
            return false;
        }
        BluetoothProfile profileProxy = constructor.apply(context, this);
        ProfileConnection connection = new ProfileConnection(profile, listener, executor);
        Object object = sProfileLock;
        synchronized (object) {
            this.mProfileConnections.put(profileProxy, connection);
            IBinder binder = this.getProfile(profile);
            if (binder != null) {
                connection.connect(profileProxy, binder);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"AndroidFrameworkRequiresPermission"})
    @RequiresNoPermission
    public void closeProfileProxy(@NonNull BluetoothProfile proxy) {
        if (proxy instanceof BluetoothGatt) {
            BluetoothGatt gatt = (BluetoothGatt)proxy;
            gatt.close();
            return;
        }
        if (proxy instanceof BluetoothGattServer) {
            BluetoothGattServer gatt = (BluetoothGattServer)proxy;
            gatt.close();
            return;
        }
        if (proxy.getAdapter() != this) {
            Log.e(TAG, "closeProfileProxy(): Called on wrong instance was " + proxy.getAdapter() + " but expected " + this);
            proxy.getAdapter().closeProfileProxy(proxy);
            return;
        }
        Object object = sProfileLock;
        synchronized (object) {
            ProfileConnection connection = this.mProfileConnections.remove(proxy);
            if (connection != null) {
                if (proxy instanceof BluetoothLeCallControl) {
                    BluetoothLeCallControl callControl = (BluetoothLeCallControl)proxy;
                    callControl.unregisterBearer();
                }
                connection.disconnect(proxy);
            }
        }
    }

    @RequiresNoPermission
    public void closeProfileProxy(int unusedProfile, BluetoothProfile proxy) {
        if (proxy == null) {
            return;
        }
        this.closeProfileProxy(proxy);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    public boolean enableNoAutoConnect() {
        if (this.isEnabled()) {
            Log.d(TAG, "enableNoAutoConnect(): BT already enabled!");
            return true;
        }
        try {
            return this.mManagerService.enableNoAutoConnect(this.mAttributionSource);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public void generateLocalOobData(int transport, @NonNull Executor executor, @NonNull OobDataCallback callback) {
        if (transport != 1 && transport != 2) {
            throw new IllegalArgumentException("Invalid transport '" + transport + "'!");
        }
        Objects.requireNonNull(callback);
        if (!this.isEnabled()) {
            Log.w(TAG, "generateLocalOobData(): Adapter isn't enabled!");
            callback.onError(1);
        } else {
            this.mServiceLock.readLock().lock();
            try {
                if (this.mService != null) {
                    this.mService.generateLocalOobData(transport, new WrappedOobDataCallback(callback, executor), this.mAttributionSource);
                }
            }
            catch (RemoteException e) {
                BluetoothUtils.logRemoteException(TAG, e);
            }
            finally {
                this.mServiceLock.readLock().unlock();
            }
        }
    }

    private static Set<BluetoothDevice> toDeviceSet(List<BluetoothDevice> devices) {
        HashSet<BluetoothDevice> deviceSet = new HashSet<BluetoothDevice>(devices);
        return Collections.unmodifiableSet(deviceSet);
    }

    @SuppressLint(value={"GenericException"})
    protected void finalize() throws Throwable {
        try {
            this.removeServiceStateCallback(this.mManagerCallback);
        }
        finally {
            super.finalize();
        }
    }

    public static boolean checkBluetoothAddress(String address) {
        if (address == null || address.length() != 17) {
            return false;
        }
        block4: for (int i = 0; i < 17; ++i) {
            char c = address.charAt(i);
            switch (i % 3) {
                case 0: 
                case 1: {
                    if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F') continue block4;
                    return false;
                }
                case 2: {
                    if (c == ':') continue block4;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isAddressRandomStatic(@NonNull String address) {
        Objects.requireNonNull(address);
        return BluetoothAdapter.checkBluetoothAddress(address) && (Integer.parseInt(address.split(":")[0], 16) & 0xC0) == 192;
    }

    @UnsupportedAppUsage
    @RequiresNoPermission
    public IBluetoothManager getBluetoothManager() {
        return this.mManagerService;
    }

    @RequiresNoPermission
    public AttributionSource getAttributionSource() {
        return this.mAttributionSource;
    }

    IBluetooth getBluetoothService() {
        sServiceLock.readLock().lock();
        try {
            IBluetooth iBluetooth = sService;
            return iBluetooth;
        }
        finally {
            sServiceLock.readLock().unlock();
        }
    }

    IBluetooth registerBluetoothManagerCallback(IBluetoothManagerCallback cb) {
        Objects.requireNonNull(cb);
        sServiceLock.writeLock().lock();
        try {
            sProxyServiceStateCallbacks.put(cb, null);
            this.registerOrUnregisterAdapterLocked();
            IBluetooth iBluetooth = sService;
            return iBluetooth;
        }
        finally {
            sServiceLock.writeLock().unlock();
        }
    }

    @RequiresNoPermission
    @Nullable
    public IBluetoothGatt getBluetoothGatt() {
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                IBluetoothGatt iBluetoothGatt = IBluetoothGatt.Stub.asInterface(this.mService.getBluetoothGatt());
                return iBluetoothGatt;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return null;
    }

    @RequiresNoPermission
    @Nullable
    public IBluetoothScan getBluetoothScan() {
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                IBluetoothScan iBluetoothScan = IBluetoothScan.Stub.asInterface(this.mService.getBluetoothScan());
                return iBluetoothScan;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return null;
    }

    @RequiresNoPermission
    @Nullable
    public IBluetoothAdvertise getBluetoothAdvertise() {
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                IBluetoothAdvertise iBluetoothAdvertise = IBluetoothAdvertise.Stub.asInterface(this.mService.getBluetoothAdvertise());
                return iBluetoothAdvertise;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return null;
    }

    @RequiresNoPermission
    @Nullable
    public IDistanceMeasurement getDistanceMeasurement() {
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                IDistanceMeasurement iDistanceMeasurement = IDistanceMeasurement.Stub.asInterface(this.mService.getDistanceMeasurement());
                return iDistanceMeasurement;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return null;
    }

    @Nullable
    private IBinder getProfile(int profile) {
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                IBinder iBinder = this.mService.getProfile(profile);
                return iBinder;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return null;
    }

    void removeServiceStateCallback(IBluetoothManagerCallback cb) {
        Objects.requireNonNull(cb);
        sServiceLock.writeLock().lock();
        try {
            sProxyServiceStateCallbacks.remove(cb);
            this.registerOrUnregisterAdapterLocked();
        }
        finally {
            sServiceLock.writeLock().unlock();
        }
    }

    @GuardedBy(value={"sServiceLock"})
    private void registerOrUnregisterAdapterLocked() {
        boolean wantRegistered;
        boolean isRegistered = sServiceRegistered;
        boolean bl = wantRegistered = !sProxyServiceStateCallbacks.isEmpty();
        if (isRegistered == wantRegistered) {
            return;
        }
        if (wantRegistered) {
            try {
                sService = IBluetooth.Stub.asInterface(this.mManagerService.registerAdapter(sManagerCallback));
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
        try {
            this.mManagerService.unregisterAdapter(sManagerCallback);
            sService = null;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        sServiceRegistered = wantRegistered;
    }

    @Deprecated
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean startLeScan(LeScanCallback callback) {
        return this.startLeScan(null, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public boolean startLeScan(final UUID[] serviceUuids, final LeScanCallback callback) {
        Log.d(TAG, "startLeScan(): " + Arrays.toString(serviceUuids));
        if (callback == null) {
            Log.e(TAG, "startLeScan: null callback");
            return false;
        }
        BluetoothLeScanner scanner = this.getBluetoothLeScanner();
        if (scanner == null) {
            Log.e(TAG, "startLeScan: cannot get BluetoothLeScanner");
            return false;
        }
        Map<LeScanCallback, ScanCallback> map = this.mLeScanClients;
        synchronized (map) {
            if (this.mLeScanClients.containsKey(callback)) {
                Log.e(TAG, "LE Scan has already started");
                return false;
            }
            IBluetoothGatt iGatt = this.getBluetoothGatt();
            if (iGatt == null) {
                return false;
            }
            ScanCallback scanCallback = new ScanCallback(this){

                @Override
                @RequiresNoPermission
                public void onScanResult(int callbackType, ScanResult result) {
                    if (callbackType != 1) {
                        Log.e(TAG, "LE Scan has already started");
                        return;
                    }
                    ScanRecord scanRecord = result.getScanRecord();
                    if (scanRecord == null) {
                        return;
                    }
                    if (serviceUuids != null) {
                        ArrayList<ParcelUuid> uuids = new ArrayList<ParcelUuid>();
                        for (UUID uuid : serviceUuids) {
                            uuids.add(new ParcelUuid(uuid));
                        }
                        List<ParcelUuid> scanServiceUuids = scanRecord.getServiceUuids();
                        if (scanServiceUuids == null || !scanServiceUuids.containsAll(uuids)) {
                            Log.d(TAG, "uuids does not match");
                            return;
                        }
                    }
                    callback.onLeScan(result.getDevice(), result.getRssi(), scanRecord.getBytes());
                }
            };
            ScanSettings settings = new ScanSettings.Builder().setCallbackType(1).setScanMode(2).build();
            ArrayList<ScanFilter> filters = new ArrayList<ScanFilter>();
            if (serviceUuids != null && serviceUuids.length > 0) {
                ScanFilter filter = new ScanFilter.Builder().setServiceUuid(new ParcelUuid(serviceUuids[0])).build();
                filters.add(filter);
            }
            scanner.startScan(filters, settings, scanCallback);
            this.mLeScanClients.put(callback, scanCallback);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @RequiresPermission(value="android.permission.BLUETOOTH_SCAN")
    public void stopLeScan(LeScanCallback callback) {
        Log.d(TAG, "stopLeScan()");
        BluetoothLeScanner scanner = this.getBluetoothLeScanner();
        if (scanner == null) {
            return;
        }
        Map<LeScanCallback, ScanCallback> map = this.mLeScanClients;
        synchronized (map) {
            ScanCallback scanCallback = this.mLeScanClients.remove(callback);
            if (scanCallback == null) {
                Log.d(TAG, "scan not started yet");
                return;
            }
            scanner.stopScan(scanCallback);
        }
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @NonNull
    public BluetoothServerSocket listenUsingL2capChannel() throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(4, true, true, -2, false, false);
        int errno = socket.mSocket.bindListen();
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        int assignedPsm = socket.mSocket.getPort();
        if (assignedPsm == 0) {
            throw new IOException("Error: Unable to assign PSM value");
        }
        Log.d(TAG, "listenUsingL2capChannel: set assigned PSM to " + assignedPsm);
        socket.setChannel(assignedPsm);
        return socket;
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
    @NonNull
    public BluetoothServerSocket listenUsingInsecureL2capChannel() throws IOException {
        BluetoothServerSocket socket = new BluetoothServerSocket(4, false, false, -2, false, false);
        int errno = socket.mSocket.bindListen();
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        int assignedPsm = socket.mSocket.getPort();
        if (assignedPsm == 0) {
            throw new IOException("Error: Unable to assign PSM value");
        }
        Log.d(TAG, "listenUsingInsecureL2capChannel: set assigned PSM to " + assignedPsm);
        socket.setChannel(assignedPsm);
        return socket;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"}, conditional=true)
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.socket_settings_api")
    @NonNull
    public BluetoothServerSocket listenUsingSocketSettings(@NonNull BluetoothSocketSettings settings) throws IOException {
        int errno;
        BluetoothServerSocket socket;
        int type = settings.getSocketType();
        if (type == 1) {
            if (settings.getRfcommUuid() == null) {
                throw new IllegalArgumentException("RFCOMM server missing UUID");
            }
            socket = settings.getDataPath() == 0 ? new BluetoothServerSocket(settings.getSocketType(), settings.isAuthenticationRequired(), settings.isEncryptionRequired(), new ParcelUuid(settings.getRfcommUuid())) : new BluetoothServerSocket(settings.getSocketType(), settings.isAuthenticationRequired(), settings.isEncryptionRequired(), -1, new ParcelUuid(settings.getRfcommUuid()), false, false, settings.getDataPath(), settings.getSocketName(), settings.getHubId(), settings.getEndpointId(), settings.getRequestedMaximumPacketSize());
            socket.setServiceName(settings.getRfcommServiceName());
        } else if (type == 4) {
            socket = settings.getDataPath() == 0 ? new BluetoothServerSocket(settings.getSocketType(), settings.isAuthenticationRequired(), settings.isEncryptionRequired(), -2, false, false) : new BluetoothServerSocket(settings.getSocketType(), settings.isAuthenticationRequired(), settings.isEncryptionRequired(), -2, null, false, false, settings.getDataPath(), settings.getSocketName(), settings.getHubId(), settings.getEndpointId(), settings.getRequestedMaximumPacketSize());
        } else {
            throw new IllegalArgumentException("Error: Invalid socket type: " + type);
        }
        int n = errno = settings.getDataPath() == 0 ? socket.mSocket.bindListen() : socket.mSocket.bindListenWithOffload();
        if (errno != 0) {
            throw new IOException("Error: " + errno);
        }
        if (type == 4) {
            int assignedPsm = socket.mSocket.getPort();
            if (assignedPsm == 0) {
                throw new IOException("Error: Unable to assign PSM value");
            }
            Log.d(TAG, "listenUsingSocketSettings: set assigned PSM to " + assignedPsm);
            socket.setChannel(assignedPsm);
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean addOnMetadataChangedListener(@NonNull BluetoothDevice device, @NonNull Executor executor, @NonNull OnMetadataChangedListener listener) {
        Log.d(TAG, "addOnMetadataChangedListener(" + device + ", " + listener + ")");
        Objects.requireNonNull(device);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(listener);
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService == null) {
                Log.e(TAG, "Bluetooth is not enabled. Cannot register metadata listener");
                boolean bl = false;
                return bl;
            }
            Map<BluetoothDevice, List<Pair<OnMetadataChangedListener, Executor>>> map = this.mMetadataListeners;
            synchronized (map) {
                List<Pair<OnMetadataChangedListener, Executor>> listenerList = this.mMetadataListeners.get(device);
                if (listenerList == null) {
                    listenerList = new ArrayList<Pair<OnMetadataChangedListener, Executor>>();
                    this.mMetadataListeners.put(device, listenerList);
                } else if (listenerList.stream().anyMatch(pair -> ((OnMetadataChangedListener)pair.first).equals(listener))) {
                    throw new IllegalArgumentException("listener already registered for " + device);
                }
                Pair<OnMetadataChangedListener, Executor> listenerPair = new Pair<OnMetadataChangedListener, Executor>(listener, executor);
                listenerList.add(listenerPair);
                boolean ret = false;
                try {
                    ret = this.mService.registerMetadataListener(this.mBluetoothMetadataListener, device, this.mAttributionSource);
                }
                catch (RemoteException e) {
                    BluetoothUtils.logRemoteException(TAG, e);
                }
                finally {
                    if (!ret) {
                        listenerList.remove(listenerPair);
                        if (listenerList.isEmpty()) {
                            this.mMetadataListeners.remove(device);
                        }
                    }
                }
                boolean bl = ret;
                return bl;
            }
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean removeOnMetadataChangedListener(@NonNull BluetoothDevice device, @NonNull OnMetadataChangedListener listener) {
        Log.d(TAG, "removeOnMetadataChangedListener(" + device + ", " + listener + ")");
        Objects.requireNonNull(device);
        Objects.requireNonNull(listener);
        Map<BluetoothDevice, List<Pair<OnMetadataChangedListener, Executor>>> map = this.mMetadataListeners;
        synchronized (map) {
            block11: {
                block12: {
                    boolean bl;
                    if (!this.mMetadataListeners.containsKey(device)) {
                        throw new IllegalArgumentException("device was not registered");
                    }
                    this.mMetadataListeners.get(device).removeIf(pair -> ((OnMetadataChangedListener)pair.first).equals(listener));
                    if (!this.mMetadataListeners.get(device).isEmpty()) break block11;
                    this.mMetadataListeners.remove(device);
                    this.mServiceLock.readLock().lock();
                    try {
                        if (this.mService == null) break block12;
                        bl = this.mService.unregisterMetadataListener(this.mBluetoothMetadataListener, device, this.mAttributionSource);
                        this.mServiceLock.readLock().unlock();
                    }
                    catch (RemoteException e) {
                        boolean bl2;
                        try {
                            BluetoothUtils.logRemoteException(TAG, e);
                            bl2 = false;
                            this.mServiceLock.readLock().unlock();
                        }
                        catch (Throwable throwable) {
                            this.mServiceLock.readLock().unlock();
                            throw throwable;
                        }
                        return bl2;
                    }
                    return bl;
                }
                this.mServiceLock.readLock().unlock();
            }
            return true;
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    private void registerBluetoothConnectionCallbackFn(IBluetooth service) {
        try {
            service.registerBluetoothConnectionCallback(this.mBluetoothConnectionCallback, this.mAttributionSource);
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    private void unregisterBluetoothConnectionCallbackFn(IBluetooth service) {
        try {
            service.unregisterBluetoothConnectionCallback(this.mBluetoothConnectionCallback, this.mAttributionSource);
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean registerBluetoothConnectionCallback(@NonNull Executor executor, @NonNull BluetoothConnectionCallback callback) {
        Log.d(TAG, "registerBluetoothConnectionCallback()");
        this.enforcePermissionInFramework("android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED");
        this.mServiceLock.readLock().lock();
        try {
            this.mBluetoothConnectionCallbackWrapper.registerCallback(this.mService, callback, executor);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return true;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public boolean unregisterBluetoothConnectionCallback(@NonNull BluetoothConnectionCallback callback) {
        Log.d(TAG, "unregisterBluetoothConnectionCallback()");
        this.enforcePermissionInFramework("android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED");
        this.mServiceLock.readLock().lock();
        try {
            this.mBluetoothConnectionCallbackWrapper.unregisterCallback(this.mService, callback);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int setPreferredAudioProfiles(@NonNull BluetoothDevice device, @NonNull Bundle modeToProfileBundle) {
        Log.d(TAG, "setPreferredAudioProfiles( " + modeToProfileBundle + ", " + device + ")");
        Objects.requireNonNull(modeToProfileBundle);
        Objects.requireNonNull(device);
        if (!BluetoothAdapter.checkBluetoothAddress(device.getAddress())) {
            throw new IllegalArgumentException("device cannot have an invalid address");
        }
        if (!modeToProfileBundle.containsKey(AUDIO_MODE_OUTPUT_ONLY) && !modeToProfileBundle.containsKey(AUDIO_MODE_DUPLEX)) {
            throw new IllegalArgumentException("Bundle does not contain a key AUDIO_MODE_OUTPUT_ONLY or AUDIO_MODE_DUPLEX");
        }
        if (modeToProfileBundle.containsKey(AUDIO_MODE_OUTPUT_ONLY) && modeToProfileBundle.getInt(AUDIO_MODE_OUTPUT_ONLY) != 2 && modeToProfileBundle.getInt(AUDIO_MODE_OUTPUT_ONLY) != 22) {
            throw new IllegalArgumentException("Key AUDIO_MODE_OUTPUT_ONLY has an invalid value: " + modeToProfileBundle.getInt(AUDIO_MODE_OUTPUT_ONLY));
        }
        if (modeToProfileBundle.containsKey(AUDIO_MODE_DUPLEX) && modeToProfileBundle.getInt(AUDIO_MODE_DUPLEX) != 1 && modeToProfileBundle.getInt(AUDIO_MODE_DUPLEX) != 22) {
            throw new IllegalArgumentException("Key AUDIO_MODE_DUPLEX has an invalid value: " + modeToProfileBundle.getInt(AUDIO_MODE_DUPLEX));
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                int n = this.mService.setPreferredAudioProfiles(device, modeToProfileBundle, this.mAttributionSource);
                return n;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 1;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    @NonNull
    public Bundle getPreferredAudioProfiles(@NonNull BluetoothDevice device) {
        Log.d(TAG, "getPreferredAudioProfiles(" + device + ")");
        Objects.requireNonNull(device);
        if (!BluetoothAdapter.checkBluetoothAddress(device.getAddress())) {
            throw new IllegalArgumentException("device cannot have an invalid address");
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                Bundle bundle = this.mService.getPreferredAudioProfiles(device, this.mAttributionSource);
                return bundle;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return Bundle.EMPTY;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int notifyActiveDeviceChangeApplied(@NonNull BluetoothDevice device) {
        Log.d(TAG, "notifyActiveDeviceChangeApplied(" + device + ")");
        Objects.requireNonNull(device);
        if (!BluetoothAdapter.checkBluetoothAddress(device.getAddress())) {
            throw new IllegalArgumentException("device cannot have an invalid address");
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                int n = this.mService.notifyActiveDeviceChangeApplied(device, this.mAttributionSource);
                return n;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return Integer.MAX_VALUE;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    private void registerAudioProfilesCallbackFn(IBluetooth service) {
        try {
            service.registerPreferredAudioProfilesChangedCallback(this.mPreferredAudioProfilesChangedCallback, this.mAttributionSource);
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    private void unregisterAudioProfilesCallbackFn(IBluetooth service) {
        try {
            service.unregisterPreferredAudioProfilesChangedCallback(this.mPreferredAudioProfilesChangedCallback, this.mAttributionSource);
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int registerPreferredAudioProfilesChangedCallback(@NonNull Executor executor, @NonNull PreferredAudioProfilesChangedCallback callback) {
        Log.d(TAG, "registerPreferredAudioProfilesChangedCallback()");
        Objects.requireNonNull(callback);
        Objects.requireNonNull(executor);
        this.mServiceLock.readLock().lock();
        try {
            int status = this.mService.isDualModeAudioEnabled(this.mAttributionSource);
            if (status != 0) {
                int n = status;
                return n;
            }
            this.mAudioProfilesCallbackWrapper.registerCallback(this.mService, callback, executor);
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 0;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int unregisterPreferredAudioProfilesChangedCallback(@NonNull PreferredAudioProfilesChangedCallback callback) {
        Log.d(TAG, "unregisterPreferredAudioProfilesChangedCallback()");
        this.mServiceLock.readLock().lock();
        try {
            this.mAudioProfilesCallbackWrapper.unregisterCallback(this.mService, callback);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 0;
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    private void registerBluetoothQualityReportCallbackFn(IBluetooth service) {
        try {
            service.registerBluetoothQualityReportReadyCallback(this.mBluetoothQualityReportReadyCallback, this.mAttributionSource);
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
    }

    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    private void unregisterBluetoothQualityReportCallbackFn(IBluetooth service) {
        try {
            service.unregisterBluetoothQualityReportReadyCallback(this.mBluetoothQualityReportReadyCallback, this.mAttributionSource);
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int registerBluetoothQualityReportReadyCallback(@NonNull Executor executor, @NonNull BluetoothQualityReportReadyCallback callback) {
        Log.d(TAG, "registerBluetoothQualityReportReadyCallback()");
        this.mServiceLock.readLock().lock();
        try {
            this.mQualityCallbackWrapper.registerCallback(this.mService, callback, executor);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 0;
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_CONNECT", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int unregisterBluetoothQualityReportReadyCallback(@NonNull BluetoothQualityReportReadyCallback callback) {
        Log.d(TAG, "unregisterBluetoothQualityReportReadyCallback()");
        this.mServiceLock.readLock().lock();
        try {
            this.mQualityCallbackWrapper.unregisterCallback(this.mService, callback);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return 0;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public int setBluetoothHciSnoopLoggingMode(int mode) {
        if (mode != 0 && mode != 1 && mode != 2) {
            throw new IllegalArgumentException("Invalid Bluetooth HCI snoop log mode param value");
        }
        try {
            return this.mManagerService.setBtHciSnoopLogMode(mode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public int getBluetoothHciSnoopLoggingMode() {
        try {
            return this.mManagerService.getBtHciSnoopLogMode();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public boolean isAutoOnSupported() {
        try {
            return this.mManagerService.isAutoOnSupported();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public boolean isAutoOnEnabled() {
        try {
            return this.mManagerService.isAutoOnEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void setAutoOnEnabled(boolean status) {
        try {
            this.mManagerService.setAutoOnEnabled(status);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_PRIVILEGED"})
    public int getOffloadedTransportDiscoveryDataScanSupported() {
        if (!this.getLeAccess()) {
            return 1;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                int n = this.mService.getOffloadedTransportDiscoveryDataScanSupported(this.mAttributionSource);
                return n;
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.hci_vendor_specific_extension")
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void registerBluetoothHciVendorSpecificCallback(@NonNull Set<Integer> eventCodeSet, @NonNull Executor executor, @NonNull BluetoothHciVendorSpecificCallback callback) {
        Log.d(TAG, "registerBluetoothHciVendorSpecificCallback()");
        Objects.requireNonNull(eventCodeSet);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        if (eventCodeSet.stream().anyMatch(n -> n < 0 || n >= 82 && n < 96 || n > 255)) {
            throw new IllegalArgumentException("Event code not in valid range");
        }
        this.mServiceLock.readLock().lock();
        try {
            HciVendorSpecificCallbackRegistration hciVendorSpecificCallbackRegistration = this.mHciVendorSpecificCallbackRegistration;
            synchronized (hciVendorSpecificCallbackRegistration) {
                if (this.mHciVendorSpecificCallbackRegistration.isSet()) {
                    throw new IllegalArgumentException("Only one registration allowed");
                }
                this.mHciVendorSpecificCallbackRegistration.set(callback, eventCodeSet, executor);
                try {
                    this.mHciVendorSpecificCallbackRegistration.registerToService(this.mService, this.mHciVendorSpecificCallbackStub);
                }
                catch (Exception e) {
                    this.mHciVendorSpecificCallbackRegistration.reset();
                    throw e;
                }
            }
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.hci_vendor_specific_extension")
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void unregisterBluetoothHciVendorSpecificCallback(@NonNull BluetoothHciVendorSpecificCallback callback) {
        Log.d(TAG, "unregisterBluetoothHciVendorSpecificCallback()");
        Objects.requireNonNull(callback);
        this.mServiceLock.readLock().lock();
        try {
            HciVendorSpecificCallbackRegistration hciVendorSpecificCallbackRegistration = this.mHciVendorSpecificCallbackRegistration;
            synchronized (hciVendorSpecificCallbackRegistration) {
                if (!this.mHciVendorSpecificCallbackRegistration.isSet(callback)) {
                    throw new IllegalArgumentException("Callback not registered");
                }
                HciVendorSpecificCallbackRegistration.unregisterFromService(this.mService, this.mHciVendorSpecificCallbackStub);
                this.mHciVendorSpecificCallbackRegistration.reset();
            }
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.hci_vendor_specific_extension")
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public void sendBluetoothHciVendorSpecificCommand(int ocf, @NonNull byte[] parameters) {
        Log.d(TAG, "sendBluetoothHciVendorSpecificCommand()");
        int getVendorCapabilitiesOcf = 339;
        if (ocf < 0 || ocf >= 336 && ocf < 352 && ocf != getVendorCapabilitiesOcf || ocf > 1023) {
            throw new IllegalArgumentException("Opcode command value not in valid range");
        }
        Objects.requireNonNull(parameters);
        if (parameters.length > 255) {
            throw new IllegalArgumentException("Parameters size is too big");
        }
        this.mServiceLock.readLock().lock();
        try {
            if (!this.mHciVendorSpecificCallbackRegistration.isSet()) {
                throw new IllegalStateException("No Callback registered");
            }
            if (this.mService != null) {
                this.mService.sendHciVendorSpecificCommand(ocf, parameters, this.mHciVendorSpecificCallbackStub);
            }
        }
        catch (RemoteException e) {
            BluetoothUtils.logRemoteException(TAG, e);
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.socket_settings_api")
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public boolean isLeCocSocketOffloadSupported() {
        if (!this.isEnabled()) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                boolean bl = this.mService.isLeCocSocketOffloadSupported(this.mAttributionSource);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.socket_settings_api")
    @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
    public boolean isRfcommSocketOffloadSupported() {
        if (!this.isEnabled()) {
            return false;
        }
        this.mServiceLock.readLock().lock();
        try {
            if (this.mService != null) {
                boolean bl = this.mService.isRfcommSocketOffloadSupported(this.mAttributionSource);
                return bl;
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, ((Object)e).toString() + "\n" + Log.getStackTraceString(new Throwable()));
        }
        finally {
            this.mServiceLock.readLock().unlock();
        }
        return false;
    }

    static {
        sServiceLock = new ReentrantReadWriteLock();
        sProfileLock = new Object();
        sBluetoothGetSystemStateQuery = new IpcDataCache.QueryHandler<Void, Integer>(){

            @Override
            @RequiresNoPermission
            public Integer apply(Void query) {
                try {
                    IBluetoothManager service = IBluetoothManager.Stub.asInterface(BluetoothFrameworkInitializer.getBluetoothServiceManager().getBluetoothManagerServiceRegisterer().get());
                    return service.getState();
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }

            @Override
            @RequiresNoPermission
            public boolean shouldBypassCache(Void query) {
                return false;
            }
        };
        sBluetoothGetSystemStateCache = new IpcDataCache<Void, Integer>(1, "system_server", GET_SYSTEM_STATE_API, GET_SYSTEM_STATE_API, sBluetoothGetSystemStateQuery);
        sBluetoothFilteringQuery = new IpcDataCache.QueryHandler<IBluetooth, Boolean>(){

            @Override
            @RequiresNoPermission
            public Boolean apply(IBluetooth serviceQuery) {
                try {
                    return serviceQuery.isOffloadedFilteringSupported();
                }
                catch (RemoteException e) {
                    throw e.rethrowAsRuntimeException();
                }
            }

            @Override
            @RequiresNoPermission
            public boolean shouldBypassCache(IBluetooth serviceQuery) {
                return false;
            }
        };
        sBluetoothFilteringCache = new BluetoothCache<IBluetooth, Boolean>(FILTERING_API, sBluetoothFilteringQuery);
        sBluetoothGetAdapterConnectionStateQuery = new IpcDataCache.QueryHandler<IBluetooth, Integer>(){

            @Override
            @RequiresNoPermission
            public Integer apply(IBluetooth serviceQuery) {
                try {
                    return serviceQuery.getAdapterConnectionState();
                }
                catch (RemoteException e) {
                    throw e.rethrowAsRuntimeException();
                }
            }

            @Override
            @RequiresNoPermission
            public boolean shouldBypassCache(IBluetooth serviceQuery) {
                return false;
            }
        };
        sBluetoothGetAdapterConnectionStateCache = new BluetoothCache<IBluetooth, Integer>(GET_CONNECTION_API, sBluetoothGetAdapterConnectionStateQuery);
        sBluetoothProfileQuery = new IpcDataCache.QueryHandler<Pair<IBluetooth, Pair<AttributionSource, Integer>>, Integer>(){

            @Override
            @RequiresPermission(value="android.permission.BLUETOOTH_CONNECT")
            public Integer apply(Pair<IBluetooth, Pair<AttributionSource, Integer>> pairQuery) {
                IBluetooth service = (IBluetooth)pairQuery.first;
                AttributionSource source = (AttributionSource)((Pair)pairQuery.second).first;
                Integer profile = (Integer)((Pair)pairQuery.second).second;
                try {
                    return service.getProfileConnectionState(profile, source);
                }
                catch (RemoteException e) {
                    throw e.rethrowAsRuntimeException();
                }
            }

            @Override
            @RequiresNoPermission
            public boolean shouldBypassCache(Pair<IBluetooth, Pair<AttributionSource, Integer>> pairQuery) {
                return false;
            }
        };
        sGetProfileConnectionStateCache = new BluetoothCache<Pair<IBluetooth, Pair<AttributionSource, Integer>>, Integer>(PROFILE_API, sBluetoothProfileQuery);
        sManagerCallback = new IBluetoothManagerCallback.Stub(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @RequiresNoPermission
            public void onBluetoothServiceUp(IBinder bluetoothService) {
                Log.d(TAG, "onBluetoothServiceUp: " + bluetoothService);
                sServiceLock.writeLock().lock();
                try {
                    sService = IBluetooth.Stub.asInterface(bluetoothService);
                    for (IBluetoothManagerCallback cb : sProxyServiceStateCallbacks.keySet()) {
                        try {
                            cb.onBluetoothServiceUp(bluetoothService);
                        }
                        catch (RemoteException e) {
                            BluetoothUtils.logRemoteException(TAG, e);
                        }
                    }
                }
                finally {
                    sServiceLock.writeLock().unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @RequiresNoPermission
            public void onBluetoothServiceDown() {
                Log.d(TAG, "onBluetoothServiceDown");
                sServiceLock.writeLock().lock();
                try {
                    sService = null;
                    for (IBluetoothManagerCallback cb : sProxyServiceStateCallbacks.keySet()) {
                        try {
                            cb.onBluetoothServiceDown();
                        }
                        catch (RemoteException e) {
                            BluetoothUtils.logRemoteException(TAG, e);
                        }
                    }
                }
                finally {
                    sServiceLock.writeLock().unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @RequiresNoPermission
            public void onBluetoothOn() {
                Log.d(TAG, "onBluetoothOn");
                sServiceLock.readLock().lock();
                try {
                    for (IBluetoothManagerCallback cb : sProxyServiceStateCallbacks.keySet()) {
                        try {
                            cb.onBluetoothOn();
                        }
                        catch (RemoteException e) {
                            BluetoothUtils.logRemoteException(TAG, e);
                        }
                    }
                }
                finally {
                    sServiceLock.readLock().unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @RequiresNoPermission
            public void onBluetoothOff() {
                Log.d(TAG, "onBluetoothOff");
                sServiceLock.readLock().lock();
                try {
                    for (IBluetoothManagerCallback cb : sProxyServiceStateCallbacks.keySet()) {
                        try {
                            cb.onBluetoothOff();
                        }
                        catch (RemoteException e) {
                            BluetoothUtils.logRemoteException(TAG, e);
                        }
                    }
                }
                finally {
                    sServiceLock.readLock().unlock();
                }
            }
        };
        sProxyServiceStateCallbacks = new WeakHashMap();
    }

    private static class HciVendorSpecificCallbackRegistration {
        private BluetoothHciVendorSpecificCallback mCallback;
        private Executor mExecutor;
        private Set<Integer> mEventCodeSet;

        private HciVendorSpecificCallbackRegistration() {
        }

        void set(BluetoothHciVendorSpecificCallback callback, Set<Integer> eventCodeSet, Executor executor) {
            this.mCallback = callback;
            this.mEventCodeSet = eventCodeSet;
            this.mExecutor = executor;
        }

        void reset() {
            this.mCallback = null;
            this.mEventCodeSet = null;
            this.mExecutor = null;
        }

        boolean isSet() {
            return this.mCallback != null;
        }

        boolean isSet(BluetoothHciVendorSpecificCallback callback) {
            return this.isSet() && callback == this.mCallback;
        }

        @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
        void registerToService(IBluetooth service, IBluetoothHciVendorSpecificCallback stub) {
            if (service == null || !this.isSet()) {
                return;
            }
            int[] eventCodes = this.mEventCodeSet.stream().mapToInt(i -> i).toArray();
            try {
                service.registerHciVendorSpecificCallback(stub, eventCodes);
            }
            catch (RemoteException e) {
                BluetoothUtils.logRemoteException(TAG, e);
            }
        }

        @RequiresPermission(value="android.permission.BLUETOOTH_PRIVILEGED")
        static void unregisterFromService(IBluetooth service, IBluetoothHciVendorSpecificCallback stub) {
            if (service == null) {
                return;
            }
            try {
                service.unregisterHciVendorSpecificCallback(stub);
            }
            catch (RemoteException e) {
                BluetoothUtils.logRemoteException(TAG, e);
            }
        }

        void execute(Consumer<BluetoothHciVendorSpecificCallback> consumer) {
            BluetoothHciVendorSpecificCallback callback = this.mCallback;
            if (callback == null) {
                return;
            }
            BluetoothUtils.executeFromBinder(this.mExecutor, () -> consumer.accept(callback));
        }
    }

    private static class OnBluetoothActivityEnergyInfoProxy
    extends IBluetoothActivityEnergyInfoListener.Stub {
        private final Object mLock = new Object();
        @Nullable
        @GuardedBy(value={"mLock"})
        private Executor mExecutor;
        @Nullable
        @GuardedBy(value={"mLock"})
        private OnBluetoothActivityEnergyInfoCallback mCallback;

        OnBluetoothActivityEnergyInfoProxy(Executor executor, OnBluetoothActivityEnergyInfoCallback callback) {
            this.mExecutor = executor;
            this.mCallback = callback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @RequiresNoPermission
        public void onBluetoothActivityEnergyInfoAvailable(BluetoothActivityEnergyInfo info) {
            OnBluetoothActivityEnergyInfoCallback callback;
            Executor executor;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mExecutor == null || this.mCallback == null) {
                    return;
                }
                executor = this.mExecutor;
                callback = this.mCallback;
                this.mExecutor = null;
                this.mCallback = null;
            }
            if (info == null) {
                BluetoothUtils.executeFromBinder(executor, () -> callback.onBluetoothActivityEnergyInfoError(11));
            } else {
                BluetoothUtils.executeFromBinder(executor, () -> callback.onBluetoothActivityEnergyInfoAvailable(info));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequiresNoPermission
        public void onError(int errorCode) {
            OnBluetoothActivityEnergyInfoCallback callback;
            Executor executor;
            Object object = this.mLock;
            synchronized (object) {
                if (this.mExecutor == null || this.mCallback == null) {
                    return;
                }
                executor = this.mExecutor;
                callback = this.mCallback;
                this.mExecutor = null;
                this.mCallback = null;
            }
            BluetoothUtils.executeFromBinder(executor, () -> callback.onBluetoothActivityEnergyInfoError(errorCode));
        }
    }

    @SystemApi
    public static interface OnBluetoothActivityEnergyInfoCallback {
        public void onBluetoothActivityEnergyInfoAvailable(@NonNull BluetoothActivityEnergyInfo var1);

        public void onBluetoothActivityEnergyInfoError(int var1);
    }

    private static class ProfileConnection {
        private final int mProfile;
        private final BluetoothProfile.ServiceListener mListener;
        private final Executor mExecutor;
        @GuardedBy(value={"BluetoothAdapter.sProfileLock"})
        boolean mConnected = false;

        ProfileConnection(int profile, BluetoothProfile.ServiceListener listener, Executor executor) {
            this.mProfile = profile;
            this.mListener = listener;
            this.mExecutor = executor;
        }

        @GuardedBy(value={"BluetoothAdapter.sProfileLock"})
        void connect(BluetoothProfile proxy, IBinder binder) {
            Log.d(TAG, BluetoothProfile.getProfileName(this.mProfile) + " connected");
            this.mConnected = true;
            proxy.onServiceConnected(binder);
            BluetoothUtils.executeFromBinder(this.mExecutor, () -> this.mListener.onServiceConnected(this.mProfile, proxy));
        }

        @GuardedBy(value={"BluetoothAdapter.sProfileLock"})
        void disconnect(BluetoothProfile proxy) {
            Log.d(TAG, BluetoothProfile.getProfileName(this.mProfile) + " disconnected");
            this.mConnected = false;
            proxy.onServiceDisconnected();
            BluetoothUtils.executeFromBinder(this.mExecutor, () -> this.mListener.onServiceDisconnected(this.mProfile));
        }
    }

    @SystemApi
    public static interface OobDataCallback {
        public void onOobData(int var1, @NonNull OobData var2);

        public void onError(int var1);
    }

    private static class WrappedOobDataCallback
    extends IBluetoothOobDataCallback.Stub {
        private final OobDataCallback mCallback;
        private final Executor mExecutor;

        WrappedOobDataCallback(@NonNull OobDataCallback callback, @NonNull Executor executor) {
            Objects.requireNonNull(callback);
            Objects.requireNonNull(executor);
            this.mCallback = callback;
            this.mExecutor = executor;
        }

        @Override
        public void onOobData(int transport, @NonNull OobData oobData) {
            BluetoothUtils.executeFromBinder(this.mExecutor, () -> this.mCallback.onOobData(transport, oobData));
        }

        @Override
        public void onError(int errorCode) {
            BluetoothUtils.executeFromBinder(this.mExecutor, () -> this.mCallback.onError(errorCode));
        }
    }

    public static interface LeScanCallback {
        public void onLeScan(BluetoothDevice var1, int var2, byte[] var3);
    }

    @SystemApi
    public static interface OnMetadataChangedListener {
        public void onMetadataChanged(@NonNull BluetoothDevice var1, int var2, @Nullable byte[] var3);
    }

    @SystemApi
    @FlaggedApi(value="com.android.bluetooth.jarjar.com.android.bluetooth.flags.hci_vendor_specific_extension")
    public static interface BluetoothHciVendorSpecificCallback {
        public void onCommandStatus(int var1, int var2);

        public void onCommandComplete(int var1, @NonNull byte[] var2);

        public void onEvent(int var1, @NonNull byte[] var2);
    }

    private static class BluetoothCache<Q, R>
    extends IpcDataCache<Q, R> {
        BluetoothCache(String api, IpcDataCache.QueryHandler query) {
            super(8, "bluetooth", api, api, query);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface GetOffloadedTransportDiscoveryDataScanSupportedReturnValues {
    }

    @SystemApi
    public static interface BluetoothQualityReportReadyCallback {
        @SystemApi
        public void onBluetoothQualityReportReady(@NonNull BluetoothDevice var1, @NonNull BluetoothQualityReport var2, int var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UnRegisterBluetoothQualityReportReadyCallbackReturnValues {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RegisterBluetoothQualityReportReadyCallbackReturnValues {
    }

    @SystemApi
    public static interface PreferredAudioProfilesChangedCallback {
        @SystemApi
        public void onPreferredAudioProfilesChanged(@NonNull BluetoothDevice var1, @NonNull Bundle var2, int var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface UnRegisterPreferredAudioProfilesCallbackReturnValues {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RegisterPreferredAudioProfilesCallbackReturnValues {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface NotifyActiveDeviceChangeAppliedReturnValues {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetPreferredAudioProfilesReturnValues {
    }

    @SystemApi
    public static abstract class BluetoothConnectionCallback {
        public void onDeviceConnected(@NonNull BluetoothDevice device) {
        }

        public void onDeviceDisconnected(@NonNull BluetoothDevice device, int reason) {
        }

        @NonNull
        public static String disconnectReasonToString(int reason) {
            String string2;
            switch (reason) {
                case 0x7FFFFFFF: {
                    string2 = "Reason unknown";
                    break;
                }
                case 1100: {
                    string2 = "Local request";
                    break;
                }
                case 1101: {
                    string2 = "Remote request";
                    break;
                }
                case 1102: {
                    string2 = "Local error";
                    break;
                }
                case 1103: {
                    string2 = "Remote error";
                    break;
                }
                case 1104: {
                    string2 = "Timeout";
                    break;
                }
                case 1105: {
                    string2 = "Security";
                    break;
                }
                case 1106: {
                    string2 = "System policy";
                    break;
                }
                case 1107: {
                    string2 = "Resource constrained";
                    break;
                }
                case 1108: {
                    string2 = "Connection already exists";
                    break;
                }
                case 1109: {
                    string2 = "Bad parameters";
                    break;
                }
                default: {
                    string2 = "Unrecognized disconnect reason: " + reason;
                }
            }
            return string2;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface DisconnectReason {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OobError {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LeFeatureReturnValues {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BluetoothActivityEnergyInfoCallbackError {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectionState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ActiveDeviceProfile {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ActiveDeviceUse {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SetSnoopLogModeStatusCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BluetoothSnoopLogMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScanModeStatusCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ScanMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RfcommListenerResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AdapterState {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface InternalAdapterState {
    }
}

