/*
 * Decompiled with CFR 0.152.
 */
package android.app.wearable;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.app.compat.CompatChanges;
import android.app.wearable.IWearableSensingCallback;
import android.app.wearable.IWearableSensingManager;
import android.app.wearable.WearableConnection;
import android.app.wearable.WearableSensingDataRequest;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.ParcelFileDescriptor;
import android.os.PersistableBundle;
import android.os.RemoteCallback;
import android.os.RemoteException;
import android.os.SharedMemory;
import android.util.Slog;
import com.android.internal.infra.AndroidFuture;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

@SystemApi
public class WearableSensingManager {
    public static final String STATUS_RESPONSE_BUNDLE_KEY = "android.app.wearable.WearableSensingStatusBundleKey";
    public static final String EXTRA_WEARABLE_SENSING_DATA_REQUEST = "android.app.wearable.extra.WEARABLE_SENSING_DATA_REQUEST";
    public static final int CONNECTION_ID_INVALID = -1;
    private static final int CONNECTION_ID_PLACEHOLDER = -2;
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_SUCCESS = 1;
    @Deprecated
    public static final int STATUS_UNSUPPORTED = 2;
    public static final int STATUS_SERVICE_UNAVAILABLE = 3;
    public static final int STATUS_WEARABLE_UNAVAILABLE = 4;
    public static final int STATUS_ACCESS_DENIED = 5;
    public static final int STATUS_UNSUPPORTED_OPERATION = 6;
    public static final int STATUS_CHANNEL_ERROR = 7;
    public static final int STATUS_UNSUPPORTED_DATA_TYPE = 8;
    @FlaggedApi(value="android.app.wearable.enable_concurrent_wearable_connections")
    public static final int STATUS_MAX_CONCURRENT_CONNECTIONS_EXCEEDED = 9;
    static final long ALLOW_WEARABLE_SENSING_SERVICE_FILE_READ = 330701114L;
    private static final String TAG = WearableSensingManager.class.getSimpleName();
    private final Context mContext;
    private final IWearableSensingManager mService;
    private final Map<WearableConnection, Integer> mWearableConnectionIdMap = new ConcurrentHashMap<WearableConnection, Integer>();

    @Nullable
    public static WearableSensingDataRequest getDataRequestFromIntent(@NonNull Intent intent) {
        return intent.getParcelableExtra(EXTRA_WEARABLE_SENSING_DATA_REQUEST, WearableSensingDataRequest.class);
    }

    public WearableSensingManager(Context context, IWearableSensingManager service) {
        this.mContext = context;
        this.mService = service;
    }

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    @FlaggedApi(value="android.app.wearable.enable_concurrent_wearable_connections")
    public int getAvailableConnectionCount() {
        try {
            return this.mService.getAvailableConnectionCount();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @FlaggedApi(value="android.app.wearable.enable_concurrent_wearable_connections")
    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    public void provideConnection(@NonNull ParcelFileDescriptor wearableConnection, @NonNull Executor executor, @NonNull Consumer<Integer> statusConsumer) {
        RemoteCallback statusCallback = WearableSensingManager.createStatusCallback(executor, statusConsumer);
        try {
            this.mService.provideConnection(wearableConnection, this.createWearableSensingCallback(executor), statusCallback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    @FlaggedApi(value="android.app.wearable.enable_concurrent_wearable_connections")
    public void provideConnection(@NonNull WearableConnection wearableConnection, @NonNull Executor executor) {
        RemoteCallback statusCallback = WearableSensingManager.createStatusCallback(executor, statusCode -> {
            if (!this.mWearableConnectionIdMap.containsKey(wearableConnection)) {
                Slog.i(TAG, "Surpassed status callback for removed connection " + wearableConnection);
                return;
            }
            if (statusCode == 1) {
                wearableConnection.onConnectionAccepted();
            } else {
                this.mWearableConnectionIdMap.remove(wearableConnection);
                wearableConnection.onError((int)statusCode);
            }
        });
        try {
            this.mWearableConnectionIdMap.put(wearableConnection, -2);
            int connectionId = this.mService.provideConcurrentConnection(wearableConnection.getConnection(), wearableConnection.getMetadata(), this.createWearableSensingCallback(executor), statusCallback);
            this.mWearableConnectionIdMap.put(wearableConnection, connectionId);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    @FlaggedApi(value="android.app.wearable.enable_concurrent_wearable_connections")
    public void removeConnection(@NonNull WearableConnection wearableConnection) {
        Integer connectionId = this.mWearableConnectionIdMap.remove(wearableConnection);
        if (connectionId == null || connectionId == -1) {
            throw new NoSuchElementException("The provided connection was never provided or was already removed.");
        }
        if (connectionId == -2) {
            throw new IllegalStateException("Attempt to remove connection before provideConnection returns. The connection will not be removed.");
        }
        try {
            if (!this.mService.removeConnection(connectionId)) {
                throw new NoSuchElementException("The provided connection was never provided or was already removed.");
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    @FlaggedApi(value="android.app.wearable.enable_concurrent_wearable_connections")
    public void removeAllConnections() {
        this.mWearableConnectionIdMap.clear();
        try {
            this.mService.removeAllConnections();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    @FlaggedApi(value="android.app.wearable.enable_provide_read_only_pfd")
    public void provideReadOnlyParcelFileDescriptor(@NonNull ParcelFileDescriptor parcelFileDescriptor, @NonNull PersistableBundle metadata, @NonNull Executor executor, @NonNull Consumer<Integer> statusConsumer) {
        RemoteCallback statusCallback = WearableSensingManager.createStatusCallback(executor, statusConsumer);
        try {
            this.mService.provideReadOnlyParcelFileDescriptor(parcelFileDescriptor, metadata, statusCallback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    public void provideDataStream(@NonNull ParcelFileDescriptor parcelFileDescriptor, @NonNull Executor executor, @NonNull Consumer<Integer> statusConsumer) {
        RemoteCallback statusCallback = WearableSensingManager.createStatusCallback(executor, statusConsumer);
        IWearableSensingCallback wearableSensingCallback = null;
        if (CompatChanges.isChangeEnabled(330701114L)) {
            wearableSensingCallback = this.createWearableSensingCallback(executor);
        }
        try {
            this.mService.provideDataStream(parcelFileDescriptor, wearableSensingCallback, statusCallback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    public void provideData(@NonNull PersistableBundle data, @Nullable SharedMemory sharedMemory, @NonNull Executor executor, @NonNull Consumer<Integer> statusConsumer) {
        try {
            RemoteCallback callback = WearableSensingManager.createStatusCallback(executor, statusConsumer);
            this.mService.provideData(data, sharedMemory, callback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    public void registerDataRequestObserver(int dataType, @NonNull PendingIntent dataRequestPendingIntent, @NonNull Executor executor, @NonNull Consumer<Integer> statusConsumer) {
        try {
            RemoteCallback statusCallback = WearableSensingManager.createStatusCallback(executor, statusConsumer);
            this.mService.registerDataRequestObserver(dataType, dataRequestPendingIntent, statusCallback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    public void unregisterDataRequestObserver(int dataType, @NonNull PendingIntent dataRequestPendingIntent, @NonNull Executor executor, @NonNull Consumer<Integer> statusConsumer) {
        try {
            RemoteCallback statusCallback = WearableSensingManager.createStatusCallback(executor, statusConsumer);
            this.mService.unregisterDataRequestObserver(dataType, dataRequestPendingIntent, statusCallback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.app.wearable.enable_hotword_wearable_sensing_api")
    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    public void startHotwordRecognition(@Nullable ComponentName targetVisComponentName, @NonNull Executor executor, @NonNull Consumer<Integer> statusConsumer) {
        try {
            this.mService.startHotwordRecognition(targetVisComponentName, WearableSensingManager.createStatusCallback(executor, statusConsumer));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @FlaggedApi(value="android.app.wearable.enable_hotword_wearable_sensing_api")
    @RequiresPermission(value="android.permission.MANAGE_WEARABLE_SENSING_SERVICE")
    public void stopHotwordRecognition(@NonNull Executor executor, @NonNull Consumer<Integer> statusConsumer) {
        try {
            this.mService.stopHotwordRecognition(WearableSensingManager.createStatusCallback(executor, statusConsumer));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private static RemoteCallback createStatusCallback(Executor executor, Consumer<Integer> statusConsumer) {
        return new RemoteCallback(result -> {
            int status = result.getInt(STATUS_RESPONSE_BUNDLE_KEY);
            long identity = Binder.clearCallingIdentity();
            try {
                executor.execute(() -> statusConsumer.accept(status));
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        });
    }

    private IWearableSensingCallback createWearableSensingCallback(final Executor executor) {
        return new IWearableSensingCallback.Stub(){

            @Override
            public void openFile(String filename, AndroidFuture<ParcelFileDescriptor> future) {
                Slog.d(TAG, "IWearableSensingCallback#openFile " + filename);
                Binder.withCleanCallingIdentity(() -> executor.execute(() -> {
                    File file = new File(WearableSensingManager.this.mContext.getFilesDir(), filename);
                    ParcelFileDescriptor pfd = null;
                    try {
                        pfd = ParcelFileDescriptor.open(file, 0x10000000);
                        Slog.d(TAG, "Successfully opened a file with ParcelFileDescriptor.");
                    }
                    catch (FileNotFoundException e) {
                        Slog.e(TAG, "Cannot open file.", e);
                    }
                    finally {
                        future.complete(pfd);
                        if (pfd != null) {
                            try {
                                pfd.close();
                            }
                            catch (IOException ex) {
                                Slog.e(TAG, "Error closing ParcelFileDescriptor.", ex);
                            }
                        }
                    }
                }));
            }
        };
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StatusCode {
    }
}

