/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.app.usage.ExternalStorageStats;
import android.app.usage.IStorageStatsManager;
import android.app.usage.StorageStats;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.os.ParcelableException;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.storage.CrateInfo;
import android.os.storage.StorageManager;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.UUID;

public class StorageStatsManager {
    private final Context mContext;
    private final IStorageStatsManager mService;

    public StorageStatsManager(Context context, IStorageStatsManager service) {
        this.mContext = Objects.requireNonNull(context);
        this.mService = Objects.requireNonNull(service);
    }

    public boolean isQuotaSupported(@NonNull UUID storageUuid) {
        try {
            return this.mService.isQuotaSupported(StorageManager.convert(storageUuid), this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public boolean isQuotaSupported(String uuid) {
        return this.isQuotaSupported(StorageManager.convert(uuid));
    }

    public boolean isReservedSupported(@NonNull UUID storageUuid) {
        try {
            return this.mService.isReservedSupported(StorageManager.convert(storageUuid), this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public long getTotalBytes(@NonNull UUID storageUuid) throws IOException {
        try {
            return this.mService.getTotalBytes(StorageManager.convert(storageUuid), this.mContext.getOpPackageName());
        }
        catch (ParcelableException e) {
            e.maybeRethrow(IOException.class);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public long getTotalBytes(String uuid) throws IOException {
        return this.getTotalBytes(StorageManager.convert(uuid));
    }

    public long getFreeBytes(@NonNull UUID storageUuid) throws IOException {
        try {
            return this.mService.getFreeBytes(StorageManager.convert(storageUuid), this.mContext.getOpPackageName());
        }
        catch (ParcelableException e) {
            e.maybeRethrow(IOException.class);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public long getFreeBytes(String uuid) throws IOException {
        return this.getFreeBytes(StorageManager.convert(uuid));
    }

    public long getCacheBytes(@NonNull UUID storageUuid) throws IOException {
        try {
            return this.mService.getCacheBytes(StorageManager.convert(storageUuid), this.mContext.getOpPackageName());
        }
        catch (ParcelableException e) {
            e.maybeRethrow(IOException.class);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public long getCacheBytes(String uuid) throws IOException {
        return this.getCacheBytes(StorageManager.convert(uuid));
    }

    @NonNull
    public StorageStats queryStatsForPackage(@NonNull UUID storageUuid, @NonNull String packageName, @NonNull UserHandle user) throws PackageManager.NameNotFoundException, IOException {
        try {
            return this.mService.queryStatsForPackage(StorageManager.convert(storageUuid), packageName, user.getIdentifier(), this.mContext.getOpPackageName());
        }
        catch (ParcelableException e) {
            e.maybeRethrow(PackageManager.NameNotFoundException.class);
            e.maybeRethrow(IOException.class);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public StorageStats queryStatsForPackage(String uuid, String packageName, UserHandle user) throws PackageManager.NameNotFoundException, IOException {
        return this.queryStatsForPackage(StorageManager.convert(uuid), packageName, user);
    }

    @NonNull
    public StorageStats queryStatsForUid(@NonNull UUID storageUuid, int uid) throws IOException {
        try {
            return this.mService.queryStatsForUid(StorageManager.convert(storageUuid), uid, this.mContext.getOpPackageName());
        }
        catch (ParcelableException e) {
            e.maybeRethrow(IOException.class);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public StorageStats queryStatsForUid(String uuid, int uid) throws IOException {
        return this.queryStatsForUid(StorageManager.convert(uuid), uid);
    }

    @NonNull
    public StorageStats queryStatsForUser(@NonNull UUID storageUuid, @NonNull UserHandle user) throws IOException {
        try {
            return this.mService.queryStatsForUser(StorageManager.convert(storageUuid), user.getIdentifier(), this.mContext.getOpPackageName());
        }
        catch (ParcelableException e) {
            e.maybeRethrow(IOException.class);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public StorageStats queryStatsForUser(String uuid, UserHandle user) throws IOException {
        return this.queryStatsForUser(StorageManager.convert(uuid), user);
    }

    @NonNull
    public ExternalStorageStats queryExternalStatsForUser(@NonNull UUID storageUuid, @NonNull UserHandle user) throws IOException {
        try {
            return this.mService.queryExternalStatsForUser(StorageManager.convert(storageUuid), user.getIdentifier(), this.mContext.getOpPackageName());
        }
        catch (ParcelableException e) {
            e.maybeRethrow(IOException.class);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public ExternalStorageStats queryExternalStatsForUser(String uuid, UserHandle user) throws IOException {
        return this.queryExternalStatsForUser(StorageManager.convert(uuid), user);
    }

    public long getCacheQuotaBytes(String volumeUuid, int uid) {
        try {
            return this.mService.getCacheQuotaBytes(volumeUuid, uid, this.mContext.getOpPackageName());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public Collection<CrateInfo> queryCratesForUid(@NonNull UUID storageUuid, int uid) throws IOException, PackageManager.NameNotFoundException {
        try {
            ParceledListSlice crateInfoList = this.mService.queryCratesForUid(StorageManager.convert(storageUuid), uid, this.mContext.getOpPackageName());
            return Objects.requireNonNull(crateInfoList).getList();
        }
        catch (ParcelableException e) {
            e.maybeRethrow(PackageManager.NameNotFoundException.class);
            e.maybeRethrow(IOException.class);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @NonNull
    public Collection<CrateInfo> queryCratesForPackage(@NonNull UUID storageUuid, @NonNull String packageName, @NonNull UserHandle user) throws PackageManager.NameNotFoundException, IOException {
        try {
            ParceledListSlice crateInfoList = this.mService.queryCratesForPackage(StorageManager.convert(storageUuid), packageName, user.getIdentifier(), this.mContext.getOpPackageName());
            return Objects.requireNonNull(crateInfoList).getList();
        }
        catch (ParcelableException e) {
            e.maybeRethrow(PackageManager.NameNotFoundException.class);
            e.maybeRethrow(IOException.class);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_CRATES")
    @NonNull
    public Collection<CrateInfo> queryCratesForUser(@NonNull UUID storageUuid, @NonNull UserHandle user) throws PackageManager.NameNotFoundException, IOException {
        try {
            ParceledListSlice crateInfoList = this.mService.queryCratesForUser(StorageManager.convert(storageUuid), user.getIdentifier(), this.mContext.getOpPackageName());
            return Objects.requireNonNull(crateInfoList).getList();
        }
        catch (ParcelableException e) {
            e.maybeRethrow(PackageManager.NameNotFoundException.class);
            e.maybeRethrow(IOException.class);
            throw new RuntimeException(e);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }
}

