/*
 * Decompiled with CFR 0.152.
 */
package android.app.time;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.ShellCommand;
import java.io.PrintWriter;
import java.util.Objects;

@SystemApi
public class TimeZoneState
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<TimeZoneState> CREATOR = new Parcelable.Creator<TimeZoneState>(){

        @Override
        public TimeZoneState createFromParcel(Parcel in) {
            return TimeZoneState.createFromParcel(in);
        }

        public TimeZoneState[] newArray(int size) {
            return new TimeZoneState[size];
        }
    };
    @NonNull
    private final String mId;
    private final boolean mUserShouldConfirmId;

    public TimeZoneState(@NonNull String id2, boolean userShouldConfirmId) {
        this.mId = Objects.requireNonNull(id2);
        this.mUserShouldConfirmId = userShouldConfirmId;
    }

    private static TimeZoneState createFromParcel(Parcel in) {
        String zoneId = in.readString8();
        boolean userShouldConfirmId = in.readBoolean();
        return new TimeZoneState(zoneId, userShouldConfirmId);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString8(this.mId);
        dest.writeBoolean(this.mUserShouldConfirmId);
    }

    @Nullable
    public static TimeZoneState parseCommandLineArgs(@NonNull ShellCommand cmd) {
        String opt;
        String zoneIdString = null;
        Boolean userShouldConfirmId = null;
        block8: while ((opt = cmd.getNextArg()) != null) {
            switch (opt) {
                case "--zone_id": {
                    zoneIdString = cmd.getNextArgRequired();
                    continue block8;
                }
                case "--user_should_confirm_id": {
                    userShouldConfirmId = Boolean.parseBoolean(cmd.getNextArgRequired());
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unknown option: " + opt);
        }
        if (zoneIdString == null) {
            throw new IllegalArgumentException("No zoneId specified.");
        }
        if (userShouldConfirmId == null) {
            throw new IllegalArgumentException("No userShouldConfirmId specified.");
        }
        return new TimeZoneState(zoneIdString, userShouldConfirmId);
    }

    public static void printCommandLineOpts(@NonNull PrintWriter pw) {
        pw.println("TimeZoneState options:");
        pw.println("  --zone_id {<Olson ID>}");
        pw.println("  --user_should_confirm_id {true|false}");
        pw.println();
        pw.println("See " + TimeZoneState.class.getName() + " for more information");
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    public boolean getUserShouldConfirmId() {
        return this.mUserShouldConfirmId;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeZoneState that = (TimeZoneState)o;
        return Objects.equals(this.mId, that.mId) && this.mUserShouldConfirmId == that.mUserShouldConfirmId;
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mUserShouldConfirmId);
    }

    public String toString() {
        return "TimeZoneState{mZoneId=" + this.mId + ", mUserShouldConfirmId=" + this.mUserShouldConfirmId + '}';
    }
}

