/*
 * Decompiled with CFR 0.152.
 */
package android.app.time;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.app.time.TimeCapabilities;
import android.app.time.TimeConfiguration;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class TimeCapabilitiesAndConfig
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<TimeCapabilitiesAndConfig> CREATOR = new Parcelable.Creator<TimeCapabilitiesAndConfig>(){

        @Override
        public TimeCapabilitiesAndConfig createFromParcel(Parcel source) {
            return TimeCapabilitiesAndConfig.readFromParcel(source);
        }

        public TimeCapabilitiesAndConfig[] newArray(int size) {
            return new TimeCapabilitiesAndConfig[size];
        }
    };
    @NonNull
    private final TimeCapabilities mCapabilities;
    @NonNull
    private final TimeConfiguration mConfiguration;

    public TimeCapabilitiesAndConfig(@NonNull TimeCapabilities timeCapabilities, @NonNull TimeConfiguration timeConfiguration) {
        this.mCapabilities = Objects.requireNonNull(timeCapabilities);
        this.mConfiguration = Objects.requireNonNull(timeConfiguration);
    }

    @NonNull
    private static TimeCapabilitiesAndConfig readFromParcel(Parcel in) {
        TimeCapabilities capabilities = in.readParcelable(null, TimeCapabilities.class);
        TimeConfiguration configuration = in.readParcelable(null, TimeConfiguration.class);
        return new TimeCapabilitiesAndConfig(capabilities, configuration);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeParcelable(this.mCapabilities, flags);
        dest.writeParcelable(this.mConfiguration, flags);
    }

    @NonNull
    public TimeCapabilities getCapabilities() {
        return this.mCapabilities;
    }

    @NonNull
    public TimeConfiguration getConfiguration() {
        return this.mConfiguration;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeCapabilitiesAndConfig that = (TimeCapabilitiesAndConfig)o;
        return this.mCapabilities.equals(that.mCapabilities) && this.mConfiguration.equals(that.mConfiguration);
    }

    public int hashCode() {
        return Objects.hash(this.mCapabilities, this.mConfiguration);
    }

    public String toString() {
        return "TimeCapabilitiesAndConfig{mCapabilities=" + this.mCapabilities + ", mConfiguration=" + this.mConfiguration + '}';
    }
}

