/*
 * Decompiled with CFR 0.152.
 */
package android.app.time;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.text.TextUtils;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

public class DetectorStatusTypes {
    public static final int DETECTOR_STATUS_UNKNOWN = 0;
    public static final int DETECTOR_STATUS_NOT_SUPPORTED = 1;
    public static final int DETECTOR_STATUS_NOT_RUNNING = 2;
    public static final int DETECTOR_STATUS_RUNNING = 3;
    public static final int DETECTION_ALGORITHM_STATUS_UNKNOWN = 0;
    public static final int DETECTION_ALGORITHM_STATUS_NOT_SUPPORTED = 1;
    public static final int DETECTION_ALGORITHM_STATUS_NOT_RUNNING = 2;
    public static final int DETECTION_ALGORITHM_STATUS_RUNNING = 3;

    private DetectorStatusTypes() {
    }

    public static int requireValidDetectorStatus(int detectorStatus) {
        if (detectorStatus < 0 || detectorStatus > 3) {
            throw new IllegalArgumentException("Invalid detector status: " + detectorStatus);
        }
        return detectorStatus;
    }

    @NonNull
    public static String detectorStatusToString(int detectorStatus) {
        switch (detectorStatus) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "NOT_SUPPORTED";
            }
            case 2: {
                return "NOT_RUNNING";
            }
            case 3: {
                return "RUNNING";
            }
        }
        throw new IllegalArgumentException("Unknown status: " + detectorStatus);
    }

    public static int detectorStatusFromString(@Nullable String detectorStatusString) {
        if (TextUtils.isEmpty(detectorStatusString)) {
            throw new IllegalArgumentException("Empty status: " + detectorStatusString);
        }
        switch (detectorStatusString) {
            case "UNKNOWN": {
                return 0;
            }
            case "NOT_SUPPORTED": {
                return 1;
            }
            case "NOT_RUNNING": {
                return 2;
            }
            case "RUNNING": {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unknown status: " + detectorStatusString);
    }

    public static int requireValidDetectionAlgorithmStatus(int detectionAlgorithmStatus) {
        if (detectionAlgorithmStatus < 0 || detectionAlgorithmStatus > 3) {
            throw new IllegalArgumentException("Invalid detection algorithm: " + detectionAlgorithmStatus);
        }
        return detectionAlgorithmStatus;
    }

    @NonNull
    public static String detectionAlgorithmStatusToString(int detectorAlgorithmStatus) {
        switch (detectorAlgorithmStatus) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "NOT_SUPPORTED";
            }
            case 2: {
                return "NOT_RUNNING";
            }
            case 3: {
                return "RUNNING";
            }
        }
        throw new IllegalArgumentException("Unknown status: " + detectorAlgorithmStatus);
    }

    public static int detectionAlgorithmStatusFromString(@Nullable String detectorAlgorithmStatusString) {
        if (TextUtils.isEmpty(detectorAlgorithmStatusString)) {
            throw new IllegalArgumentException("Empty status: " + detectorAlgorithmStatusString);
        }
        switch (detectorAlgorithmStatusString) {
            case "UNKNOWN": {
                return 0;
            }
            case "NOT_SUPPORTED": {
                return 1;
            }
            case "NOT_RUNNING": {
                return 2;
            }
            case "RUNNING": {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unknown status: " + detectorAlgorithmStatusString);
    }

    @Target(value={ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DetectionAlgorithmStatus {
    }

    @Target(value={ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DetectorStatus {
    }
}

