/*
 * Decompiled with CFR 0.152.
 */
package android.app.servertransaction;

import android.annotation.NonNull;
import android.app.ActivityThread;
import android.app.ClientTransactionHandler;
import android.app.servertransaction.ActivityLifecycleItem;
import android.app.servertransaction.ClientTransaction;
import android.app.servertransaction.ClientTransactionItem;
import android.app.servertransaction.PendingTransactionActions;
import android.app.servertransaction.TransactionExecutorHelper;
import android.os.IBinder;
import android.os.Trace;
import android.util.IntArray;
import android.util.Slog;
import com.android.internal.annotations.VisibleForTesting;
import java.util.List;

public class TransactionExecutor {
    private static final boolean DEBUG_RESOLVER = false;
    private static final String TAG = "TransactionExecutor";
    private final ClientTransactionHandler mTransactionHandler;
    private final PendingTransactionActions mPendingActions = new PendingTransactionActions();
    private final TransactionExecutorHelper mHelper = new TransactionExecutorHelper();

    public TransactionExecutor(@NonNull ClientTransactionHandler clientTransactionHandler) {
        this.mTransactionHandler = clientTransactionHandler;
    }

    public void execute(@NonNull ClientTransaction transaction) {
        Trace.traceBegin(32L, "clientTransactionExecuted");
        try {
            this.executeTransactionItems(transaction);
        }
        catch (Exception e) {
            Slog.e(TAG, "Failed to execute the transaction: " + TransactionExecutorHelper.transactionToString(transaction, this.mTransactionHandler));
            throw e;
        }
        finally {
            Trace.traceEnd(32L);
        }
        this.mPendingActions.clear();
    }

    @VisibleForTesting
    public void executeTransactionItems(@NonNull ClientTransaction transaction) {
        List<ClientTransactionItem> items = transaction.getTransactionItems();
        int size = items.size();
        for (int i = 0; i < size; ++i) {
            ClientTransactionItem item = items.get(i);
            if (item.isActivityLifecycleItem()) {
                this.executeLifecycleItem(transaction, (ActivityLifecycleItem)item);
                continue;
            }
            this.executeNonLifecycleItem(transaction, item, TransactionExecutorHelper.shouldExcludeLastLifecycleState(items, i));
        }
    }

    private void executeNonLifecycleItem(@NonNull ClientTransaction transaction, @NonNull ClientTransactionItem item, boolean shouldExcludeLastLifecycleState) {
        int closestPreExecutionState;
        IBinder token = item.getActivityToken();
        ActivityThread.ActivityClientRecord r = this.mTransactionHandler.getActivityClient(token);
        if (token != null && r == null && this.mTransactionHandler.getActivitiesToBeDestroyed().containsKey(token)) {
            Slog.w(TAG, "Skip pre-destroyed transaction item:\n" + item);
            return;
        }
        int postExecutionState = item.getPostExecutionState();
        if (item.shouldHaveDefinedPreExecutionState() && (closestPreExecutionState = this.mHelper.getClosestPreExecutionState(r, postExecutionState)) != -1) {
            this.cycleToPath(r, closestPreExecutionState, transaction);
        }
        item.execute(this.mTransactionHandler, this.mPendingActions);
        item.postExecute(this.mTransactionHandler, this.mPendingActions);
        if (r == null) {
            r = this.mTransactionHandler.getActivityClient(token);
        }
        if (postExecutionState != -1 && r != null) {
            this.cycleToPath(r, postExecutionState, shouldExcludeLastLifecycleState, transaction);
        }
    }

    private void executeLifecycleItem(@NonNull ClientTransaction transaction, @NonNull ActivityLifecycleItem lifecycleItem) {
        IBinder token = lifecycleItem.getActivityToken();
        ActivityThread.ActivityClientRecord r = this.mTransactionHandler.getActivityClient(token);
        if (r == null) {
            if (this.mTransactionHandler.getActivitiesToBeDestroyed().get(token) == lifecycleItem) {
                lifecycleItem.postExecute(this.mTransactionHandler, this.mPendingActions);
            }
            return;
        }
        this.cycleToPath(r, lifecycleItem.getTargetState(), true, transaction);
        lifecycleItem.execute(this.mTransactionHandler, this.mPendingActions);
        lifecycleItem.postExecute(this.mTransactionHandler, this.mPendingActions);
    }

    @VisibleForTesting
    public void cycleToPath(ActivityThread.ActivityClientRecord r, int finish, ClientTransaction transaction) {
        this.cycleToPath(r, finish, false, transaction);
    }

    private void cycleToPath(ActivityThread.ActivityClientRecord r, int finish, boolean excludeLastState, ClientTransaction transaction) {
        int start = r.getLifecycleState();
        IntArray path = this.mHelper.getLifecyclePath(start, finish, excludeLastState);
        this.performLifecycleSequence(r, path, transaction);
    }

    private void performLifecycleSequence(ActivityThread.ActivityClientRecord r, IntArray path, ClientTransaction transaction) {
        int size = path.size();
        block9: for (int i = 0; i < size; ++i) {
            int state = path.get(i);
            switch (state) {
                case 1: {
                    this.mTransactionHandler.handleLaunchActivity(r, this.mPendingActions, -1, null);
                    continue block9;
                }
                case 2: {
                    this.mTransactionHandler.handleStartActivity(r, this.mPendingActions, null);
                    continue block9;
                }
                case 3: {
                    this.mTransactionHandler.handleResumeActivity(r, false, r.isForward, false, "LIFECYCLER_RESUME_ACTIVITY");
                    continue block9;
                }
                case 4: {
                    this.mTransactionHandler.handlePauseActivity(r, false, false, false, this.mPendingActions, "LIFECYCLER_PAUSE_ACTIVITY");
                    continue block9;
                }
                case 5: {
                    this.mTransactionHandler.handleStopActivity(r, this.mPendingActions, false, "LIFECYCLER_STOP_ACTIVITY");
                    continue block9;
                }
                case 6: {
                    this.mTransactionHandler.handleDestroyActivity(r, false, false, "performLifecycleSequence. cycling to:" + path.get(size - 1));
                    continue block9;
                }
                case 7: {
                    this.mTransactionHandler.performRestartActivity(r, false);
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected lifecycle state: " + state);
                }
            }
        }
    }
}

