/*
 * Decompiled with CFR 0.152.
 */
package android.app.servertransaction;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityThread;
import android.app.ClientTransactionHandler;
import android.app.ResultInfo;
import android.app.servertransaction.ActivityTransactionItem;
import android.app.servertransaction.PendingTransactionActions;
import android.content.res.CompatibilityInfo;
import android.os.IBinder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Trace;
import android.util.MergedConfiguration;
import android.window.ActivityWindowInfo;
import com.android.internal.content.ReferrerIntent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ActivityRelaunchItem
extends ActivityTransactionItem {
    private static final String TAG = "ActivityRelaunchItem";
    @Nullable
    private final List<ResultInfo> mPendingResults;
    @Nullable
    private final List<ReferrerIntent> mPendingNewIntents;
    @NonNull
    private final MergedConfiguration mConfig;
    @NonNull
    private final ActivityWindowInfo mActivityWindowInfo;
    private final int mConfigChanges;
    private final boolean mPreserveWindow;
    @Nullable
    private ActivityThread.ActivityClientRecord mActivityClientRecord;
    @NonNull
    public static final Parcelable.Creator<ActivityRelaunchItem> CREATOR = new Parcelable.Creator<ActivityRelaunchItem>(){

        @Override
        public ActivityRelaunchItem createFromParcel(@NonNull Parcel in) {
            return new ActivityRelaunchItem(in);
        }

        public ActivityRelaunchItem[] newArray(int size) {
            return new ActivityRelaunchItem[size];
        }
    };

    public ActivityRelaunchItem(@NonNull IBinder activityToken, @Nullable List<ResultInfo> pendingResults, @Nullable List<ReferrerIntent> pendingNewIntents, int configChanges, @NonNull MergedConfiguration config, boolean preserveWindow, @NonNull ActivityWindowInfo activityWindowInfo) {
        super(activityToken);
        this.mPendingResults = pendingResults != null ? new ArrayList<ResultInfo>(pendingResults) : null;
        this.mPendingNewIntents = pendingNewIntents != null ? new ArrayList<ReferrerIntent>(pendingNewIntents) : null;
        this.mConfig = new MergedConfiguration(config);
        this.mActivityWindowInfo = new ActivityWindowInfo(activityWindowInfo);
        this.mConfigChanges = configChanges;
        this.mPreserveWindow = preserveWindow;
    }

    @Override
    public void preExecute(@NonNull ClientTransactionHandler client) {
        if (!client.isExecutingLocalTransaction()) {
            CompatibilityInfo.applyOverrideIfNeeded(this.mConfig);
        }
        this.mActivityClientRecord = client.prepareRelaunchActivity(this.getActivityToken(), this.mPendingResults, this.mPendingNewIntents, this.mConfigChanges, this.mConfig, this.mPreserveWindow, this.mActivityWindowInfo);
    }

    @Override
    public void execute(@NonNull ClientTransactionHandler client, @NonNull ActivityThread.ActivityClientRecord r, @NonNull PendingTransactionActions pendingActions) {
        if (this.mActivityClientRecord == null) {
            return;
        }
        Trace.traceBegin(64L, "activityRestart");
        client.handleRelaunchActivity(this.mActivityClientRecord, pendingActions);
        Trace.traceEnd(64L);
    }

    @Override
    public void postExecute(@NonNull ClientTransactionHandler client, @NonNull PendingTransactionActions pendingActions) {
        ActivityThread.ActivityClientRecord r = this.getActivityClientRecord(client);
        client.reportRelaunch(r);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeTypedList(this.mPendingResults, flags);
        dest.writeTypedList(this.mPendingNewIntents, flags);
        dest.writeTypedObject(this.mConfig, flags);
        dest.writeTypedObject(this.mActivityWindowInfo, flags);
        dest.writeInt(this.mConfigChanges);
        dest.writeBoolean(this.mPreserveWindow);
    }

    private ActivityRelaunchItem(@NonNull Parcel in) {
        super(in);
        this.mPendingResults = in.createTypedArrayList(ResultInfo.CREATOR);
        this.mPendingNewIntents = in.createTypedArrayList(ReferrerIntent.CREATOR);
        this.mConfig = Objects.requireNonNull(in.readTypedObject(MergedConfiguration.CREATOR));
        this.mActivityWindowInfo = Objects.requireNonNull(in.readTypedObject(ActivityWindowInfo.CREATOR));
        this.mConfigChanges = in.readInt();
        this.mPreserveWindow = in.readBoolean();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        ActivityRelaunchItem other = (ActivityRelaunchItem)o;
        return Objects.equals(this.mPendingResults, other.mPendingResults) && Objects.equals(this.mPendingNewIntents, other.mPendingNewIntents) && Objects.equals(this.mConfig, other.mConfig) && Objects.equals(this.mActivityWindowInfo, other.mActivityWindowInfo) && this.mConfigChanges == other.mConfigChanges && this.mPreserveWindow == other.mPreserveWindow;
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + super.hashCode();
        result = 31 * result + Objects.hashCode(this.mPendingResults);
        result = 31 * result + Objects.hashCode(this.mPendingNewIntents);
        result = 31 * result + Objects.hashCode(this.mConfig);
        result = 31 * result + Objects.hashCode(this.mActivityWindowInfo);
        result = 31 * result + this.mConfigChanges;
        result = 31 * result + (this.mPreserveWindow ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return "ActivityRelaunchItem{" + super.toString() + ",pendingResults=" + this.mPendingResults + ",pendingNewIntents=" + this.mPendingNewIntents + ",config=" + this.mConfig + ",activityWindowInfo=" + this.mActivityWindowInfo + ",configChanges=" + this.mConfigChanges + ",preserveWindow=" + this.mPreserveWindow + "}";
    }
}

