/*
 * Decompiled with CFR 0.152.
 */
package android.app.search;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.app.search.SearchAction;
import android.appwidget.AppWidgetProviderInfo;
import android.content.pm.ShortcutInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class SearchTarget
implements Parcelable {
    public static final int RESULT_TYPE_APPLICATION = 1;
    public static final int RESULT_TYPE_SHORTCUT = 2;
    public static final int RESULT_TYPE_SLICE = 4;
    public static final int RESULT_TYPE_WIDGETS = 8;
    public static final String LAYOUT_TYPE_ICON = "icon";
    public static final String LAYOUT_TYPE_ICON_ROW = "icon_row";
    public static final String LAYOUT_TYPE_SHORT_ICON_ROW = "short_icon_row";
    private final int mResultType;
    @NonNull
    private final String mLayoutType;
    @NonNull
    private final String mId;
    @Nullable
    private String mParentId;
    private final float mScore;
    private final boolean mHidden;
    @NonNull
    private final String mPackageName;
    @NonNull
    private final UserHandle mUserHandle;
    @Nullable
    private final SearchAction mSearchAction;
    @Nullable
    private final ShortcutInfo mShortcutInfo;
    @Nullable
    private final AppWidgetProviderInfo mAppWidgetProviderInfo;
    @Nullable
    private final Uri mSliceUri;
    @NonNull
    private final Bundle mExtras;
    @NonNull
    public static final Parcelable.Creator<SearchTarget> CREATOR = new Parcelable.Creator<SearchTarget>(){

        @Override
        public SearchTarget createFromParcel(Parcel parcel) {
            return new SearchTarget(parcel);
        }

        public SearchTarget[] newArray(int size) {
            return new SearchTarget[size];
        }
    };

    private SearchTarget(Parcel parcel) {
        this.mResultType = parcel.readInt();
        this.mLayoutType = parcel.readString();
        this.mId = parcel.readString();
        this.mParentId = parcel.readString();
        this.mScore = parcel.readFloat();
        this.mHidden = parcel.readBoolean();
        this.mPackageName = parcel.readString();
        this.mUserHandle = UserHandle.of(parcel.readInt());
        this.mSearchAction = parcel.readTypedObject(SearchAction.CREATOR);
        this.mShortcutInfo = parcel.readTypedObject(ShortcutInfo.CREATOR);
        this.mAppWidgetProviderInfo = parcel.readTypedObject(AppWidgetProviderInfo.CREATOR);
        this.mSliceUri = parcel.readTypedObject(Uri.CREATOR);
        this.mExtras = parcel.readBundle(this.getClass().getClassLoader());
    }

    private SearchTarget(int resultType, @NonNull String layoutType, @NonNull String id2, @Nullable String parentId, float score, boolean hidden, @NonNull String packageName, @NonNull UserHandle userHandle, @Nullable SearchAction action, @Nullable ShortcutInfo shortcutInfo, @Nullable Uri sliceUri, @Nullable AppWidgetProviderInfo appWidgetProviderInfo, @NonNull Bundle extras) {
        this.mResultType = resultType;
        this.mLayoutType = Objects.requireNonNull(layoutType);
        this.mId = Objects.requireNonNull(id2);
        this.mParentId = parentId;
        this.mScore = score;
        this.mHidden = hidden;
        this.mPackageName = Objects.requireNonNull(packageName);
        this.mUserHandle = Objects.requireNonNull(userHandle);
        this.mSearchAction = action;
        this.mShortcutInfo = shortcutInfo;
        this.mAppWidgetProviderInfo = appWidgetProviderInfo;
        this.mSliceUri = sliceUri;
        this.mExtras = extras != null ? extras : new Bundle();
    }

    public int getResultType() {
        return this.mResultType;
    }

    @NonNull
    public String getLayoutType() {
        return this.mLayoutType;
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    @NonNull
    public String getParentId() {
        return this.mParentId;
    }

    public float getScore() {
        return this.mScore;
    }

    @Deprecated
    public boolean shouldHide() {
        return this.mHidden;
    }

    public boolean isHidden() {
        return this.mHidden;
    }

    @NonNull
    public String getPackageName() {
        return this.mPackageName;
    }

    @NonNull
    public UserHandle getUserHandle() {
        return this.mUserHandle;
    }

    @Nullable
    public ShortcutInfo getShortcutInfo() {
        return this.mShortcutInfo;
    }

    @Nullable
    public AppWidgetProviderInfo getAppWidgetProviderInfo() {
        return this.mAppWidgetProviderInfo;
    }

    @Nullable
    public Uri getSliceUri() {
        return this.mSliceUri;
    }

    @Nullable
    public SearchAction getSearchAction() {
        return this.mSearchAction;
    }

    @NonNull
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        parcel.writeInt(this.mResultType);
        parcel.writeString(this.mLayoutType);
        parcel.writeString(this.mId);
        parcel.writeString(this.mParentId);
        parcel.writeFloat(this.mScore);
        parcel.writeBoolean(this.mHidden);
        parcel.writeString(this.mPackageName);
        parcel.writeInt(this.mUserHandle.getIdentifier());
        parcel.writeTypedObject(this.mSearchAction, flags);
        parcel.writeTypedObject(this.mShortcutInfo, flags);
        parcel.writeTypedObject(this.mAppWidgetProviderInfo, flags);
        parcel.writeTypedObject(this.mSliceUri, flags);
        parcel.writeBundle(this.mExtras);
    }

    @SystemApi
    public static class Builder {
        private int mResultType;
        @NonNull
        private String mLayoutType;
        @NonNull
        private String mId;
        @Nullable
        private String mParentId;
        private float mScore;
        private boolean mHidden;
        @NonNull
        private String mPackageName;
        @NonNull
        private UserHandle mUserHandle;
        @Nullable
        private SearchAction mSearchAction;
        @Nullable
        private ShortcutInfo mShortcutInfo;
        @Nullable
        private Uri mSliceUri;
        @Nullable
        private AppWidgetProviderInfo mAppWidgetProviderInfo;
        @NonNull
        private Bundle mExtras;

        public Builder(int resultType, @NonNull String layoutType, @NonNull String id2) {
            this.mId = id2;
            this.mLayoutType = Objects.requireNonNull(layoutType);
            this.mResultType = resultType;
            this.mScore = 1.0f;
            this.mHidden = false;
        }

        @NonNull
        public Builder setParentId(@NonNull String parentId) {
            this.mParentId = Objects.requireNonNull(parentId);
            return this;
        }

        @NonNull
        public Builder setPackageName(@NonNull String packageName) {
            this.mPackageName = Objects.requireNonNull(packageName);
            return this;
        }

        @NonNull
        public Builder setUserHandle(@NonNull UserHandle userHandle) {
            this.mUserHandle = Objects.requireNonNull(userHandle);
            return this;
        }

        @NonNull
        public Builder setShortcutInfo(@NonNull ShortcutInfo shortcutInfo) {
            this.mShortcutInfo = Objects.requireNonNull(shortcutInfo);
            if (this.mPackageName != null && !this.mPackageName.equals(shortcutInfo.getPackage())) {
                throw new IllegalStateException("SearchTarget packageName is different from shortcut's packageName");
            }
            this.mPackageName = shortcutInfo.getPackage();
            return this;
        }

        @NonNull
        public Builder setAppWidgetProviderInfo(@NonNull AppWidgetProviderInfo appWidgetProviderInfo) {
            this.mAppWidgetProviderInfo = Objects.requireNonNull(appWidgetProviderInfo);
            if (this.mPackageName != null && !this.mPackageName.equals(appWidgetProviderInfo.provider.getPackageName())) {
                throw new IllegalStateException("SearchTarget packageName is different from appWidgetProviderInfo's packageName");
            }
            return this;
        }

        @NonNull
        public Builder setSliceUri(@NonNull Uri sliceUri) {
            this.mSliceUri = sliceUri;
            return this;
        }

        @NonNull
        public Builder setSearchAction(@Nullable SearchAction searchAction) {
            this.mSearchAction = searchAction;
            return this;
        }

        @NonNull
        public Builder setExtras(@NonNull Bundle extras) {
            this.mExtras = Objects.requireNonNull(extras);
            return this;
        }

        @NonNull
        public Builder setScore(float score) {
            this.mScore = score;
            return this;
        }

        @NonNull
        public Builder setHidden(boolean hidden) {
            this.mHidden = hidden;
            return this;
        }

        @Deprecated
        @NonNull
        public Builder setShouldHide(boolean shouldHide) {
            this.mHidden = shouldHide;
            return this;
        }

        @NonNull
        public SearchTarget build() {
            return new SearchTarget(this.mResultType, this.mLayoutType, this.mId, this.mParentId, this.mScore, this.mHidden, this.mPackageName, this.mUserHandle, this.mSearchAction, this.mShortcutInfo, this.mSliceUri, this.mAppWidgetProviderInfo, this.mExtras);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SearchLayoutType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SearchResultType {
    }
}

