/*
 * Decompiled with CFR 0.152.
 */
package android.app.search;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.content.Intent;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import android.text.TextUtils;
import java.util.Objects;

@SystemApi
public class SearchAction
implements Parcelable {
    private static final String TAG = "SearchAction";
    @NonNull
    private String mId;
    @Nullable
    private final Icon mIcon;
    @NonNull
    private final CharSequence mTitle;
    @Nullable
    private final CharSequence mSubtitle;
    @Nullable
    private final CharSequence mContentDescription;
    @Nullable
    private final PendingIntent mPendingIntent;
    @Nullable
    private final Intent mIntent;
    @Nullable
    private final UserHandle mUserHandle;
    @Nullable
    private final Bundle mExtras;
    @NonNull
    public static final Parcelable.Creator<SearchAction> CREATOR = new Parcelable.Creator<SearchAction>(){

        @Override
        public SearchAction createFromParcel(Parcel in) {
            return new SearchAction(in);
        }

        public SearchAction[] newArray(int size) {
            return new SearchAction[size];
        }
    };

    SearchAction(Parcel in) {
        this.mId = in.readString();
        this.mTitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mIcon = in.readTypedObject(Icon.CREATOR);
        this.mSubtitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mContentDescription = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
        this.mPendingIntent = in.readTypedObject(PendingIntent.CREATOR);
        this.mIntent = in.readTypedObject(Intent.CREATOR);
        this.mUserHandle = in.readTypedObject(UserHandle.CREATOR);
        this.mExtras = in.readTypedObject(Bundle.CREATOR);
    }

    private SearchAction(@NonNull String id2, @NonNull CharSequence title, @Nullable Icon icon, @Nullable CharSequence subtitle, @Nullable CharSequence contentDescription, @Nullable PendingIntent pendingIntent, @Nullable Intent intent, @Nullable UserHandle userHandle, @Nullable Bundle extras) {
        this.mId = Objects.requireNonNull(id2);
        this.mTitle = Objects.requireNonNull(title);
        this.mIcon = icon;
        this.mSubtitle = subtitle;
        this.mContentDescription = contentDescription;
        this.mPendingIntent = pendingIntent;
        this.mIntent = intent;
        this.mUserHandle = userHandle;
        Bundle bundle = this.mExtras = extras != null ? extras : new Bundle();
        if (this.mPendingIntent == null && this.mIntent == null) {
            throw new IllegalStateException("At least one type of intent should be available.");
        }
        if (this.mPendingIntent != null && this.mIntent != null) {
            throw new IllegalStateException("Only one type of intent should be available.");
        }
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    @Nullable
    public Icon getIcon() {
        return this.mIcon;
    }

    @NonNull
    public CharSequence getTitle() {
        return this.mTitle;
    }

    @Nullable
    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    @Nullable
    public CharSequence getContentDescription() {
        return this.mContentDescription;
    }

    @Nullable
    public PendingIntent getPendingIntent() {
        return this.mPendingIntent;
    }

    @Nullable
    public Intent getIntent() {
        return this.mIntent;
    }

    @Nullable
    public UserHandle getUserHandle() {
        return this.mUserHandle;
    }

    @SuppressLint(value={"NullableCollection"})
    @Nullable
    public Bundle getExtras() {
        return this.mExtras;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SearchAction)) {
            return false;
        }
        SearchAction that = (SearchAction)o;
        return this.mId.equals(that.mId) && this.mTitle.equals(that.mTitle);
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mTitle);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeString(this.mId);
        TextUtils.writeToParcel(this.mTitle, out, flags);
        out.writeTypedObject(this.mIcon, flags);
        TextUtils.writeToParcel(this.mSubtitle, out, flags);
        TextUtils.writeToParcel(this.mContentDescription, out, flags);
        out.writeTypedObject(this.mPendingIntent, flags);
        out.writeTypedObject(this.mIntent, flags);
        out.writeTypedObject(this.mUserHandle, flags);
        out.writeTypedObject(this.mExtras, flags);
    }

    public String toString() {
        String str = "id=" + this.mId + " title=" + this.mTitle + " contentDescription=" + this.mContentDescription + " subtitle=" + this.mSubtitle + " icon=" + this.mIcon + " pendingIntent=" + (this.mPendingIntent == null ? "" : this.mPendingIntent.getIntent()) + " intent=" + this.mIntent + " userHandle=" + this.mUserHandle;
        return str;
    }

    @SystemApi
    public static class Builder {
        @NonNull
        private String mId;
        @NonNull
        private CharSequence mTitle;
        @Nullable
        private Icon mIcon;
        @Nullable
        private CharSequence mSubtitle;
        @Nullable
        private CharSequence mContentDescription;
        @Nullable
        private PendingIntent mPendingIntent;
        @Nullable
        private Intent mIntent;
        @Nullable
        private UserHandle mUserHandle;
        @Nullable
        private Bundle mExtras;

        public Builder(@NonNull String id2, @NonNull String title) {
            this.mId = Objects.requireNonNull(id2);
            this.mTitle = Objects.requireNonNull(title);
        }

        @NonNull
        public Builder setIcon(@Nullable Icon icon) {
            this.mIcon = icon;
            return this;
        }

        @NonNull
        public Builder setSubtitle(@Nullable CharSequence subtitle) {
            this.mSubtitle = subtitle;
            return this;
        }

        @NonNull
        public Builder setContentDescription(@Nullable CharSequence contentDescription) {
            this.mContentDescription = contentDescription;
            return this;
        }

        @NonNull
        public Builder setPendingIntent(@Nullable PendingIntent pendingIntent) {
            this.mPendingIntent = pendingIntent;
            return this;
        }

        @NonNull
        public Builder setUserHandle(@Nullable UserHandle userHandle) {
            this.mUserHandle = userHandle;
            return this;
        }

        @NonNull
        public Builder setIntent(@Nullable Intent intent) {
            this.mIntent = intent;
            return this;
        }

        @NonNull
        public Builder setExtras(@SuppressLint(value={"NullableCollection"}) @Nullable Bundle extras) {
            this.mExtras = extras;
            return this;
        }

        @NonNull
        public SearchAction build() {
            return new SearchAction(this.mId, this.mTitle, this.mIcon, this.mSubtitle, this.mContentDescription, this.mPendingIntent, this.mIntent, this.mUserHandle, this.mExtras);
        }
    }
}

