/*
 * Decompiled with CFR 0.152.
 */
package android.app.sdksandbox;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.sdksandbox.SdkLevel;
import android.app.sdksandbox.SdkSandboxSystemServiceRegistry;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.ApplicationInfo;
import android.content.res.AssetManager;
import android.content.res.Resources;
import com.android.internal.annotations.VisibleForTesting;
import java.io.File;

public class SandboxedSdkContext
extends ContextWrapper {
    private final Resources mResources;
    private final AssetManager mAssets;
    private final String mClientPackageName;
    private final String mSdkName;
    private final ApplicationInfo mSdkProviderInfo;
    @Nullable
    private final File mCeDataDir;
    @Nullable
    private final File mDeDataDir;
    private final SdkSandboxSystemServiceRegistry mSdkSandboxSystemServiceRegistry;
    private final ClassLoader mClassLoader;
    private final boolean mIsCustomizedSdkContextEnabled = SdkLevel.isAtLeastU();

    public SandboxedSdkContext(@NonNull Context baseContext, @NonNull ClassLoader classLoader, @NonNull String clientPackageName, @NonNull ApplicationInfo info, @NonNull String sdkName, @Nullable String sdkCeDataDir, @Nullable String sdkDeDataDir) {
        this(baseContext, classLoader, clientPackageName, info, sdkName, sdkCeDataDir, sdkDeDataDir, SdkSandboxSystemServiceRegistry.getInstance());
    }

    @VisibleForTesting
    public SandboxedSdkContext(@NonNull Context baseContext, @NonNull ClassLoader classLoader, @NonNull String clientPackageName, @NonNull ApplicationInfo info, @NonNull String sdkName, @Nullable String sdkCeDataDir, @Nullable String sdkDeDataDir, SdkSandboxSystemServiceRegistry sdkSandboxSystemServiceRegistry) {
        super(baseContext);
        this.mClientPackageName = clientPackageName;
        this.mSdkName = sdkName;
        this.mSdkProviderInfo = info;
        Resources resources = null;
        try {
            resources = baseContext.getPackageManager().getResourcesForApplication(info);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resources != null) {
            this.mResources = resources;
            this.mAssets = resources.getAssets();
        } else {
            this.mResources = null;
            this.mAssets = null;
        }
        this.mCeDataDir = sdkCeDataDir != null ? new File(sdkCeDataDir) : null;
        this.mDeDataDir = sdkDeDataDir != null ? new File(sdkDeDataDir) : null;
        this.mSdkSandboxSystemServiceRegistry = sdkSandboxSystemServiceRegistry;
        this.mClassLoader = classLoader;
    }

    @Override
    @NonNull
    public Context createCredentialProtectedStorageContext() {
        Context newBaseContext = this.getBaseContext().createCredentialProtectedStorageContext();
        return this.createContextWithNewBase(newBaseContext);
    }

    @Override
    @NonNull
    public Context createDeviceProtectedStorageContext() {
        Context newBaseContext = this.getBaseContext().createDeviceProtectedStorageContext();
        return this.createContextWithNewBase(newBaseContext);
    }

    @NonNull
    public SandboxedSdkContext createContextWithNewBase(@NonNull Context newBaseContext) {
        return new SandboxedSdkContext(newBaseContext, this.mClassLoader, this.mClientPackageName, this.mSdkProviderInfo, this.mSdkName, this.mCeDataDir != null ? ((Object)this.mCeDataDir).toString() : null, this.mDeDataDir != null ? ((Object)this.mDeDataDir).toString() : null);
    }

    @NonNull
    public String getSdkName() {
        return this.mSdkName;
    }

    @NonNull
    public String getSdkPackageName() {
        return this.mSdkProviderInfo.packageName;
    }

    @NonNull
    public String getClientPackageName() {
        return this.mClientPackageName;
    }

    @Override
    @Nullable
    public Resources getResources() {
        if (this.mIsCustomizedSdkContextEnabled) {
            return this.getBaseContext().getResources();
        }
        return this.mResources;
    }

    @Override
    @Nullable
    public AssetManager getAssets() {
        if (this.mIsCustomizedSdkContextEnabled) {
            return this.getBaseContext().getAssets();
        }
        return this.mAssets;
    }

    @Override
    @Nullable
    public File getDataDir() {
        if (this.mIsCustomizedSdkContextEnabled) {
            return this.getBaseContext().getDataDir();
        }
        File res = null;
        if (this.isCredentialProtectedStorage()) {
            res = this.mCeDataDir;
        } else if (this.isDeviceProtectedStorage()) {
            res = this.mDeDataDir;
        }
        if (res == null) {
            throw new RuntimeException("No data directory found for sdk: " + this.getSdkName());
        }
        return res;
    }

    @Override
    @Nullable
    public Object getSystemService(String name) {
        if (name == null) {
            return null;
        }
        Object service = this.getBaseContext().getSystemService(name);
        SdkSandboxSystemServiceRegistry.ServiceMutator serviceMutator = this.mSdkSandboxSystemServiceRegistry.getServiceMutator(name);
        if (serviceMutator != null) {
            service = serviceMutator.setContext(service, this);
        }
        return service;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.mIsCustomizedSdkContextEnabled) {
            return this.getBaseContext().getClassLoader();
        }
        return this.mClassLoader;
    }
}

