/*
 * Decompiled with CFR 0.152.
 */
package android.app.role;

import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.app.role.IRoleController;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteCallback;
import android.permission.jarjar.com.android.internal.annotations.GuardedBy;
import android.permission.jarjar.com.android.internal.infra.AndroidFuture;
import android.permission.jarjar.com.android.internal.infra.ServiceConnector;
import android.util.Log;
import android.util.SparseArray;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class RoleControllerManager {
    public static final String KEY_RESULT = RoleControllerManager.class.getName() + ".key.RESULT";
    public static final String KEY_EXCEPTION = RoleControllerManager.class.getName() + ".key.EXCEPTION";
    private static final String LOG_TAG = RoleControllerManager.class.getSimpleName();
    private static final long REQUEST_TIMEOUT_MILLIS = 15000L;
    private static volatile ComponentName sRemoteServiceComponentName;
    private static final Object sRemoteServicesLock;
    @GuardedBy(value={"sRemoteServicesLock"})
    private static final SparseArray<ServiceConnector<IRoleController>> sRemoteServices;
    @NonNull
    private final ServiceConnector<IRoleController> mRemoteService;

    public static void initializeRemoteServiceComponentName(@NonNull Context context) {
        sRemoteServiceComponentName = RoleControllerManager.getRemoteServiceComponentName(context);
    }

    @NonNull
    public static RoleControllerManager createWithInitializedRemoteServiceComponentName(@NonNull Handler handler, @NonNull Context context) {
        return new RoleControllerManager(sRemoteServiceComponentName, handler, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RoleControllerManager(@NonNull ComponentName remoteServiceComponentName, final @NonNull Handler handler, @NonNull Context context) {
        Object object = sRemoteServicesLock;
        synchronized (object) {
            int userId = context.getUser().getIdentifier();
            ServiceConnector.Impl<IRoleController> remoteService = sRemoteServices.get(userId);
            if (remoteService == null) {
                remoteService = new ServiceConnector.Impl<IRoleController>(context.getApplicationContext(), new Intent("android.app.role.RoleControllerService").setComponent(remoteServiceComponentName), 0, userId, IRoleController.Stub::asInterface){

                    @Override
                    protected Handler getJobHandler() {
                        return handler;
                    }
                };
                sRemoteServices.put(userId, (ServiceConnector<IRoleController>)remoteService);
            }
            this.mRemoteService = remoteService;
        }
    }

    public RoleControllerManager(@NonNull Context context) {
        this(RoleControllerManager.getRemoteServiceComponentName(context), new Handler(Looper.getMainLooper()), context);
    }

    @NonNull
    private static ComponentName getRemoteServiceComponentName(@NonNull Context context) {
        Intent intent = new Intent("android.app.role.RoleControllerService");
        PackageManager packageManager = context.getPackageManager();
        intent.setPackage(packageManager.getPermissionControllerPackageName());
        ServiceInfo serviceInfo = packageManager.resolveService((Intent)intent, (int)0).serviceInfo;
        return new ComponentName(serviceInfo.packageName, serviceInfo.name);
    }

    public void grantDefaultRoles(@NonNull Executor executor, @NonNull Consumer<Boolean> callback) {
        AndroidFuture<Boolean> operation = this.mRemoteService.postAsync(service -> {
            AndroidFuture<Boolean> future = new AndroidFuture<Boolean>();
            service.grantDefaultRoles(this.createBooleanRemoteCallback(future));
            return future;
        });
        this.propagateCallback(operation, "grantDefaultRoles", executor, callback);
    }

    public void onAddRoleHolder(@NonNull String roleName, @NonNull String packageName, int flags, @NonNull RemoteCallback callback) {
        AndroidFuture<Boolean> operation = this.mRemoteService.postAsync(service -> {
            AndroidFuture<Boolean> future = new AndroidFuture<Boolean>();
            service.onAddRoleHolder(roleName, packageName, flags, this.createBooleanRemoteCallback(future));
            return future;
        });
        this.propagateCallback(operation, "onAddRoleHolder", callback);
    }

    public void onRemoveRoleHolder(@NonNull String roleName, @NonNull String packageName, int flags, @NonNull RemoteCallback callback) {
        AndroidFuture<Boolean> operation = this.mRemoteService.postAsync(service -> {
            AndroidFuture<Boolean> future = new AndroidFuture<Boolean>();
            service.onRemoveRoleHolder(roleName, packageName, flags, this.createBooleanRemoteCallback(future));
            return future;
        });
        this.propagateCallback(operation, "onRemoveRoleHolder", callback);
    }

    public void onClearRoleHolders(@NonNull String roleName, int flags, @NonNull RemoteCallback callback) {
        AndroidFuture<Boolean> operation = this.mRemoteService.postAsync(service -> {
            AndroidFuture<Boolean> future = new AndroidFuture<Boolean>();
            service.onClearRoleHolders(roleName, flags, this.createBooleanRemoteCallback(future));
            return future;
        });
        this.propagateCallback(operation, "onClearRoleHolders", callback);
    }

    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    public void isApplicationVisibleForRole(@NonNull String roleName, @NonNull String packageName, @NonNull Executor executor, @NonNull Consumer<Boolean> callback) {
        AndroidFuture<Boolean> operation = this.mRemoteService.postAsync(service -> {
            AndroidFuture<Boolean> future = new AndroidFuture<Boolean>();
            service.isApplicationVisibleForRole(roleName, packageName, this.createBooleanRemoteCallback(future));
            return future;
        });
        this.propagateCallback(operation, "isApplicationVisibleForRole", executor, callback);
    }

    @RequiresPermission(value="android.permission.MANAGE_ROLE_HOLDERS")
    public void isRoleVisible(@NonNull String roleName, @NonNull Executor executor, @NonNull Consumer<Boolean> callback) {
        AndroidFuture<Boolean> operation = this.mRemoteService.postAsync(service -> {
            AndroidFuture<Boolean> future = new AndroidFuture<Boolean>();
            service.isRoleVisible(roleName, this.createBooleanRemoteCallback(future));
            return future;
        });
        this.propagateCallback(operation, "isRoleVisible", executor, callback);
    }

    public void getLegacyFallbackDisabledRoles(@NonNull Executor executor, @NonNull Consumer<List<String>> callback) {
        ((AndroidFuture)this.mRemoteService.postAsync(service -> {
            AndroidFuture future = new AndroidFuture();
            service.getLegacyFallbackDisabledRoles(new RemoteCallback(result -> {
                Exception exception = (Exception)result.getSerializable(KEY_EXCEPTION);
                if (exception != null) {
                    future.completeExceptionally(exception);
                } else {
                    future.complete(result.getStringArrayList(KEY_RESULT));
                }
            }));
            return future;
        }).orTimeout(15000L, TimeUnit.MILLISECONDS)).whenComplete((res, err) -> executor.execute(() -> {
            long token = Binder.clearCallingIdentity();
            try {
                if (err != null) {
                    Log.e(LOG_TAG, "Error calling getLegacyFallbackDisabledRoles()", err);
                    callback.accept(null);
                } else {
                    callback.accept((List<String>)res);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }));
    }

    @NonNull
    private RemoteCallback createBooleanRemoteCallback(@NonNull AndroidFuture<Boolean> future) {
        return new RemoteCallback(result -> {
            Exception exception = (Exception)result.getSerializable(KEY_EXCEPTION);
            if (exception != null) {
                future.completeExceptionally(exception);
            } else {
                future.complete(result.getBoolean(KEY_RESULT));
            }
        });
    }

    private void propagateCallback(AndroidFuture<Boolean> operation, String opName, @NonNull Executor executor, Consumer<Boolean> destination) {
        ((AndroidFuture)operation.orTimeout(15000L, TimeUnit.MILLISECONDS)).whenComplete((res, err) -> executor.execute(() -> {
            long token = Binder.clearCallingIdentity();
            try {
                if (err != null) {
                    Log.e(LOG_TAG, "Error calling " + opName + "()", err);
                    destination.accept(false);
                } else {
                    destination.accept((Boolean)res);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }));
    }

    private void propagateCallback(AndroidFuture<Boolean> operation, String opName, RemoteCallback destination) {
        ((AndroidFuture)operation.orTimeout(15000L, TimeUnit.MILLISECONDS)).whenComplete((res, err) -> {
            long token = Binder.clearCallingIdentity();
            try {
                if (err != null) {
                    Log.e(LOG_TAG, "Error calling " + opName + "()", err);
                    destination.sendResult(null);
                } else {
                    destination.sendResult(res != false ? Bundle.EMPTY : null);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        });
    }

    static {
        sRemoteServicesLock = new Object();
        sRemoteServices = new SparseArray();
    }
}

