/*
 * Decompiled with CFR 0.152.
 */
package android.app.role;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteCallback;
import android.os.RemoteException;

public interface IRoleController
extends IInterface {
    public static final String DESCRIPTOR = "android.app.role.IRoleController";

    public void grantDefaultRoles(RemoteCallback var1) throws RemoteException;

    public void onAddRoleHolder(String var1, String var2, int var3, RemoteCallback var4) throws RemoteException;

    public void onRemoveRoleHolder(String var1, String var2, int var3, RemoteCallback var4) throws RemoteException;

    public void onClearRoleHolders(String var1, int var2, RemoteCallback var3) throws RemoteException;

    public void isApplicationQualifiedForRole(String var1, String var2, RemoteCallback var3) throws RemoteException;

    public void isApplicationVisibleForRole(String var1, String var2, RemoteCallback var3) throws RemoteException;

    public void isRoleVisible(String var1, RemoteCallback var2) throws RemoteException;

    public void getLegacyFallbackDisabledRoles(RemoteCallback var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRoleController {
        static final int TRANSACTION_grantDefaultRoles = 1;
        static final int TRANSACTION_onAddRoleHolder = 2;
        static final int TRANSACTION_onRemoveRoleHolder = 3;
        static final int TRANSACTION_onClearRoleHolders = 4;
        static final int TRANSACTION_isApplicationQualifiedForRole = 5;
        static final int TRANSACTION_isApplicationVisibleForRole = 6;
        static final int TRANSACTION_isRoleVisible = 7;
        static final int TRANSACTION_getLegacyFallbackDisabledRoles = 8;

        public Stub() {
            this.attachInterface(this, IRoleController.DESCRIPTOR);
        }

        public static IRoleController asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRoleController.DESCRIPTOR);
            if (iin != null && iin instanceof IRoleController) {
                return (IRoleController)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "grantDefaultRoles";
                }
                case 2: {
                    return "onAddRoleHolder";
                }
                case 3: {
                    return "onRemoveRoleHolder";
                }
                case 4: {
                    return "onClearRoleHolders";
                }
                case 5: {
                    return "isApplicationQualifiedForRole";
                }
                case 6: {
                    return "isApplicationVisibleForRole";
                }
                case 7: {
                    return "isRoleVisible";
                }
                case 8: {
                    return "getLegacyFallbackDisabledRoles";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRoleController.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    RemoteCallback _arg0 = data.readTypedObject(RemoteCallback.CREATOR);
                    this.grantDefaultRoles(_arg0);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    RemoteCallback _arg3 = data.readTypedObject(RemoteCallback.CREATOR);
                    this.onAddRoleHolder(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    RemoteCallback _arg3 = data.readTypedObject(RemoteCallback.CREATOR);
                    this.onRemoveRoleHolder(_arg0, _arg1, _arg2, _arg3);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    RemoteCallback _arg2 = data.readTypedObject(RemoteCallback.CREATOR);
                    this.onClearRoleHolders(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    RemoteCallback _arg2 = data.readTypedObject(RemoteCallback.CREATOR);
                    this.isApplicationQualifiedForRole(_arg0, _arg1, _arg2);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    RemoteCallback _arg2 = data.readTypedObject(RemoteCallback.CREATOR);
                    this.isApplicationVisibleForRole(_arg0, _arg1, _arg2);
                    break;
                }
                case 7: {
                    String _arg0 = data.readString();
                    RemoteCallback _arg1 = data.readTypedObject(RemoteCallback.CREATOR);
                    this.isRoleVisible(_arg0, _arg1);
                    break;
                }
                case 8: {
                    RemoteCallback _arg0 = data.readTypedObject(RemoteCallback.CREATOR);
                    this.getLegacyFallbackDisabledRoles(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 7;
        }

        private static class Proxy
        implements IRoleController {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRoleController.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantDefaultRoles(RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleController.DESCRIPTOR);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAddRoleHolder(String roleName, String packageName, int flags, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleController.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeString(packageName);
                    _data.writeInt(flags);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRemoveRoleHolder(String roleName, String packageName, int flags, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleController.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeString(packageName);
                    _data.writeInt(flags);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onClearRoleHolders(String roleName, int flags, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleController.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeInt(flags);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void isApplicationQualifiedForRole(String roleName, String packageName, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleController.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeString(packageName);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void isApplicationVisibleForRole(String roleName, String packageName, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleController.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeString(packageName);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void isRoleVisible(String roleName, RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleController.DESCRIPTOR);
                    _data.writeString(roleName);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getLegacyFallbackDisabledRoles(RemoteCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IRoleController.DESCRIPTOR);
                    _data.writeTypedObject(callback, 0);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRoleController {
        @Override
        public void grantDefaultRoles(RemoteCallback callback) throws RemoteException {
        }

        @Override
        public void onAddRoleHolder(String roleName, String packageName, int flags, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public void onRemoveRoleHolder(String roleName, String packageName, int flags, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public void onClearRoleHolders(String roleName, int flags, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public void isApplicationQualifiedForRole(String roleName, String packageName, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public void isApplicationVisibleForRole(String roleName, String packageName, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public void isRoleVisible(String roleName, RemoteCallback callback) throws RemoteException {
        }

        @Override
        public void getLegacyFallbackDisabledRoles(RemoteCallback callback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

