/*
 * Decompiled with CFR 0.152.
 */
package android.app.jank;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.app.jank.AppJankStats;
import android.app.jank.StateTracker;
import android.util.Log;
import android.util.Pools;
import android.view.SurfaceControl;
import com.android.internal.util.FrameworkStatsLog;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@FlaggedApi(value="android.app.jank.detailed_app_jank_metrics_api")
public class JankDataProcessor {
    private static final String TAG = "JankDataProcessor";
    private static final boolean DEBUG_LOGGING = false;
    private static final int MAX_IN_MEMORY_STATS = 25;
    private static final int LOG_BATCH_FREQUENCY = 50;
    private int mCurrentBatchCount = 0;
    private StateTracker mStateTracker = null;
    private ArrayList<StateTracker.StateData> mPendingStates = new ArrayList();
    private Pools.SimplePool<PendingJankStat> mPendingJankStatsPool = new Pools.SimplePool(25);
    private HashMap<String, PendingJankStat> mPendingJankStats = new HashMap();

    public JankDataProcessor(@NonNull StateTracker stateTracker) {
        this.mStateTracker = stateTracker;
    }

    public void processJankData(List<SurfaceControl.JankData> jankData, String activityName, int appUid) {
        this.mStateTracker.retrieveAllStates(this.mPendingStates);
        for (int i = 0; i < jankData.size(); ++i) {
            SurfaceControl.JankData frame = jankData.get(i);
            for (int j = 0; j < this.mPendingStates.size(); ++j) {
                StateTracker.StateData pendingState = this.mPendingStates.get(j);
                if (frame.getVsyncId() < pendingState.mVsyncIdStart || frame.getVsyncId() > pendingState.mVsyncIdEnd) continue;
                this.recordFrameCount(frame, pendingState, activityName, appUid);
                pendingState.mProcessed = true;
            }
        }
        this.incrementBatchCountAndMaybeLogStats();
        this.jankDataProcessingComplete();
    }

    public void mergeJankStats(AppJankStats jankStats, String activityName) {
        String stateKey = this.mStateTracker.getStateKey(jankStats.getWidgetCategory(), jankStats.getWidgetId(), jankStats.getWidgetState());
        if (this.mPendingJankStats.containsKey(stateKey)) {
            this.mergeExistingStat(stateKey, jankStats);
        } else {
            this.mergeNewStat(stateKey, activityName, jankStats);
        }
        this.incrementBatchCountAndMaybeLogStats();
    }

    private void mergeExistingStat(String stateKey, AppJankStats jankStat) {
        PendingJankStat pendingStat = this.mPendingJankStats.get(stateKey);
        pendingStat.mJankyFrames += jankStat.getJankyFrameCount();
        pendingStat.mTotalFrames += jankStat.getTotalFrameCount();
        this.mergeOverrunHistograms(pendingStat.mFrameOverrunBuckets, jankStat.getRelativeFrameTimeHistogram().getBucketCounters());
    }

    private void mergeNewStat(String stateKey, String activityName, AppJankStats jankStats) {
        if (this.mPendingJankStats.size() > 25) {
            return;
        }
        PendingJankStat pendingStat = this.mPendingJankStatsPool.acquire();
        if (pendingStat == null) {
            pendingStat = new PendingJankStat();
        }
        pendingStat.clearStats();
        pendingStat.mActivityName = activityName;
        pendingStat.mUid = jankStats.getUid();
        pendingStat.mWidgetId = jankStats.getWidgetId();
        pendingStat.mWidgetCategory = jankStats.getWidgetCategory();
        pendingStat.mWidgetState = jankStats.getWidgetState();
        pendingStat.mTotalFrames = jankStats.getTotalFrameCount();
        pendingStat.mJankyFrames = jankStats.getJankyFrameCount();
        this.mergeOverrunHistograms(pendingStat.mFrameOverrunBuckets, jankStats.getRelativeFrameTimeHistogram().getBucketCounters());
        this.mPendingJankStats.put(stateKey, pendingStat);
    }

    private void mergeOverrunHistograms(int[] mergeTarget, int[] mergeSource) {
        if (mergeTarget.length != mergeSource.length) {
            return;
        }
        for (int i = 0; i < mergeTarget.length; ++i) {
            int n = i;
            mergeTarget[n] = mergeTarget[n] + mergeSource[i];
        }
    }

    private void incrementBatchCountAndMaybeLogStats() {
        ++this.mCurrentBatchCount;
        if (this.mCurrentBatchCount >= 50) {
            this.logMetricCounts();
        }
    }

    @VisibleForTesting
    public HashMap<String, PendingJankStat> getPendingJankStats() {
        return this.mPendingJankStats;
    }

    private void jankDataProcessingComplete() {
        this.mStateTracker.stateProcessingComplete();
        this.mPendingStates.clear();
    }

    private void recordFrameCount(SurfaceControl.JankData frameData, StateTracker.StateData stateData, String activityName, int appUid) {
        PendingJankStat jankStats = this.mPendingJankStats.get(stateData.mStateDataKey);
        if (jankStats == null) {
            if (this.mPendingJankStats.size() > 25) {
                return;
            }
            jankStats = this.mPendingJankStatsPool.acquire();
            if (jankStats == null) {
                jankStats = new PendingJankStat();
            }
            jankStats.clearStats();
            jankStats.mActivityName = activityName;
            jankStats.mUid = appUid;
            this.mPendingJankStats.put(stateData.mStateDataKey, jankStats);
        }
        if (jankStats.processedVsyncId == frameData.getVsyncId()) {
            return;
        }
        ++jankStats.mTotalFrames;
        if ((frameData.getJankType() & 2) != 0) {
            ++jankStats.mJankyFrames;
        }
        jankStats.recordFrameOverrun(frameData.getActualAppFrameTimeNanos());
        jankStats.processedVsyncId = frameData.getVsyncId();
    }

    public void logMetricCounts() {
        try {
            this.mPendingJankStats.values().forEach(stat -> {
                FrameworkStatsLog.write(950, stat.getUid(), stat.getActivityName(), stat.getWidgetId(), stat.getRefreshRate(), this.widgetCategoryToInt(stat.getWidgetCategory()), this.widgetStateToInt(stat.getWidgetState()), stat.getTotalFrames(), stat.getJankyFrames(), stat.getFrameOverrunBuckets());
                Log.d(stat.mActivityName, stat.toString());
                this.mPendingJankStatsPool.release((PendingJankStat)stat);
            });
            this.mPendingJankStats.clear();
            this.mCurrentBatchCount = 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int widgetCategoryToInt(String widgetCategory) {
        switch (widgetCategory) {
            case "scroll": {
                return 2;
            }
            case "animation": {
                return 2;
            }
            case "media": {
                return 3;
            }
            case "navigation": {
                return 4;
            }
            case "keyboard": {
                return 5;
            }
            case "other": {
                return 6;
            }
        }
        return 0;
    }

    private int widgetStateToInt(String widgetState) {
        switch (widgetState) {
            case "none": {
                return 1;
            }
            case "scrolling": {
                return 2;
            }
            case "flinging": {
                return 3;
            }
            case "swiping": {
                return 4;
            }
            case "dragging": {
                return 5;
            }
            case "zooming": {
                return 6;
            }
            case "animating": {
                return 7;
            }
            case "playback": {
                return 8;
            }
            case "tapping": {
                return 9;
            }
            case "predictive_back": {
                return 10;
            }
        }
        return 0;
    }

    public static class PendingJankStat {
        private static final int NANOS_PER_MS = 1000000;
        public long processedVsyncId = -1L;
        private int mUid;
        private String mActivityName;
        private String mWidgetId;
        private String mWidgetCategory;
        private String mWidgetState;
        private long mTotalFrames;
        private long mJankyFrames;
        private int mRefreshRate;
        private static final int[] sFrameOverrunHistogramBounds = new int[]{Integer.MIN_VALUE, -200, -150, -100, -90, -80, -70, -60, -50, -40, -30, -25, -20, -18, -16, -14, -12, -10, -8, -6, -4, -2, 0, 2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 25, 30, 40, 50, 60, 70, 80, 90, 100, 150, 200, 300, 400, 500, 600, 700, 800, 900, 1000, Integer.MAX_VALUE};
        private final int[] mFrameOverrunBuckets = new int[sFrameOverrunHistogramBounds.length - 1];

        public long getProcessedVsyncId() {
            return this.processedVsyncId;
        }

        public void setProcessedVsyncId(long processedVsyncId) {
            this.processedVsyncId = processedVsyncId;
        }

        public int getUid() {
            return this.mUid;
        }

        public void setUid(int uid) {
            this.mUid = uid;
        }

        public String getActivityName() {
            return this.mActivityName;
        }

        public void setActivityName(String activityName) {
            this.mActivityName = activityName;
        }

        public String getWidgetId() {
            return this.mWidgetId;
        }

        public void setWidgetId(String widgetId) {
            this.mWidgetId = widgetId;
        }

        public String getWidgetCategory() {
            return this.mWidgetCategory;
        }

        public void setWidgetCategory(String widgetCategory) {
            this.mWidgetCategory = widgetCategory;
        }

        public String getWidgetState() {
            return this.mWidgetState;
        }

        public void setWidgetState(String widgetState) {
            this.mWidgetState = widgetState;
        }

        public long getTotalFrames() {
            return this.mTotalFrames;
        }

        public void setTotalFrames(long totalFrames) {
            this.mTotalFrames = totalFrames;
        }

        public long getJankyFrames() {
            return this.mJankyFrames;
        }

        public void setJankyFrames(long jankyFrames) {
            this.mJankyFrames = jankyFrames;
        }

        public int[] getFrameOverrunBuckets() {
            return this.mFrameOverrunBuckets;
        }

        public int getRefreshRate() {
            return this.mRefreshRate;
        }

        public void setRefreshRate(int refreshRate) {
            this.mRefreshRate = refreshRate;
        }

        public void recordFrameOverrun(long frameTimeNano) {
            try {
                int frameTimeMillis = (int)frameTimeNano / 1000000;
                int n = this.indexForFrameOverrun(frameTimeMillis);
                this.mFrameOverrunBuckets[n] = this.mFrameOverrunBuckets[n] + 1;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }

        public void clearStats() {
            this.mUid = -1;
            this.mActivityName = "";
            this.processedVsyncId = -1L;
            this.mJankyFrames = 0L;
            this.mTotalFrames = 0L;
            this.mWidgetCategory = "";
            this.mWidgetState = "";
            this.mRefreshRate = 0;
            this.clearHistogram();
        }

        private void clearHistogram() {
            for (int i = 0; i < this.mFrameOverrunBuckets.length; ++i) {
                this.mFrameOverrunBuckets[i] = 0;
            }
        }

        private int indexForFrameOverrun(int overrunTime) {
            if (overrunTime < 20) {
                if (overrunTime >= -20) {
                    return (overrunTime + 20) / 2 + 12;
                }
                if (overrunTime >= -30) {
                    return (overrunTime + 30) / 5 + 10;
                }
                if (overrunTime >= -100) {
                    return (overrunTime + 100) / 10 + 3;
                }
                if (overrunTime >= -200) {
                    return (overrunTime + 200) / 50 + 1;
                }
                return 0;
            }
            if (overrunTime < 30) {
                return (overrunTime - 20) / 5 + 32;
            }
            if (overrunTime < 100) {
                return (overrunTime - 30) / 10 + 34;
            }
            if (overrunTime < 200) {
                return (overrunTime - 50) / 100 + 41;
            }
            if (overrunTime <= 1000) {
                return (overrunTime - 200) / 100 + 43;
            }
            return this.mFrameOverrunBuckets.length - 1;
        }
    }
}

