/*
 * Decompiled with CFR 0.152.
 */
package android.app.contentsuggestions;

import android.app.contentsuggestions.ClassificationsRequest;
import android.app.contentsuggestions.IClassificationsCallback;
import android.app.contentsuggestions.ISelectionsCallback;
import android.app.contentsuggestions.SelectionsRequest;
import android.graphics.Bitmap;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.android.internal.os.IResultReceiver;

public interface IContentSuggestionsManager
extends IInterface {
    public static final String DESCRIPTOR = "android.app.contentsuggestions.IContentSuggestionsManager";

    public void provideContextImage(int var1, int var2, Bundle var3) throws RemoteException;

    public void provideContextBitmap(int var1, Bitmap var2, Bundle var3) throws RemoteException;

    public void suggestContentSelections(int var1, SelectionsRequest var2, ISelectionsCallback var3) throws RemoteException;

    public void classifyContentSelections(int var1, ClassificationsRequest var2, IClassificationsCallback var3) throws RemoteException;

    public void notifyInteraction(int var1, String var2, Bundle var3) throws RemoteException;

    public void isEnabled(int var1, IResultReceiver var2) throws RemoteException;

    public void resetTemporaryService(int var1) throws RemoteException;

    public void setTemporaryService(int var1, String var2, int var3) throws RemoteException;

    public void setDefaultServiceEnabled(int var1, boolean var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IContentSuggestionsManager {
        static final int TRANSACTION_provideContextImage = 1;
        static final int TRANSACTION_provideContextBitmap = 2;
        static final int TRANSACTION_suggestContentSelections = 3;
        static final int TRANSACTION_classifyContentSelections = 4;
        static final int TRANSACTION_notifyInteraction = 5;
        static final int TRANSACTION_isEnabled = 6;
        static final int TRANSACTION_resetTemporaryService = 7;
        static final int TRANSACTION_setTemporaryService = 8;
        static final int TRANSACTION_setDefaultServiceEnabled = 9;

        public Stub() {
            this.attachInterface(this, IContentSuggestionsManager.DESCRIPTOR);
        }

        public static IContentSuggestionsManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IContentSuggestionsManager.DESCRIPTOR);
            if (iin != null && iin instanceof IContentSuggestionsManager) {
                return (IContentSuggestionsManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "provideContextImage";
                }
                case 2: {
                    return "provideContextBitmap";
                }
                case 3: {
                    return "suggestContentSelections";
                }
                case 4: {
                    return "classifyContentSelections";
                }
                case 5: {
                    return "notifyInteraction";
                }
                case 6: {
                    return "isEnabled";
                }
                case 7: {
                    return "resetTemporaryService";
                }
                case 8: {
                    return "setTemporaryService";
                }
                case 9: {
                    return "setDefaultServiceEnabled";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IContentSuggestionsManager.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.provideContextImage(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    Bitmap _arg1 = data.readTypedObject(Bitmap.CREATOR);
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.provideContextBitmap(_arg0, _arg1, _arg2);
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    SelectionsRequest _arg1 = data.readTypedObject(SelectionsRequest.CREATOR);
                    ISelectionsCallback _arg2 = ISelectionsCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.suggestContentSelections(_arg0, _arg1, _arg2);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    ClassificationsRequest _arg1 = data.readTypedObject(ClassificationsRequest.CREATOR);
                    IClassificationsCallback _arg2 = IClassificationsCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.classifyContentSelections(_arg0, _arg1, _arg2);
                    break;
                }
                case 5: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    Bundle _arg2 = data.readTypedObject(Bundle.CREATOR);
                    data.enforceNoDataAvail();
                    this.notifyInteraction(_arg0, _arg1, _arg2);
                    break;
                }
                case 6: {
                    int _arg0 = data.readInt();
                    IResultReceiver _arg1 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.isEnabled(_arg0, _arg1);
                    break;
                }
                case 7: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.resetTemporaryService(_arg0);
                    break;
                }
                case 8: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.setTemporaryService(_arg0, _arg1, _arg2);
                    break;
                }
                case 9: {
                    int _arg0 = data.readInt();
                    boolean _arg1 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.setDefaultServiceEnabled(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 8;
        }

        private static class Proxy
        implements IContentSuggestionsManager {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IContentSuggestionsManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void provideContextImage(int userId, int taskId, Bundle imageContextRequestExtras) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContentSuggestionsManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeInt(taskId);
                    _data.writeTypedObject(imageContextRequestExtras, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void provideContextBitmap(int userId, Bitmap bitmap, Bundle imageContextRequestExtras) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContentSuggestionsManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeTypedObject(bitmap, 0);
                    _data.writeTypedObject(imageContextRequestExtras, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void suggestContentSelections(int userId, SelectionsRequest request, ISelectionsCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContentSuggestionsManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void classifyContentSelections(int userId, ClassificationsRequest request, IClassificationsCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContentSuggestionsManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyInteraction(int userId, String requestId, Bundle interaction) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContentSuggestionsManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(requestId);
                    _data.writeTypedObject(interaction, 0);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void isEnabled(int userId, IResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContentSuggestionsManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeStrongInterface(receiver);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void resetTemporaryService(int userId) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContentSuggestionsManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setTemporaryService(int userId, String serviceName, int duration) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContentSuggestionsManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeString(serviceName);
                    _data.writeInt(duration);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDefaultServiceEnabled(int userId, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IContentSuggestionsManager.DESCRIPTOR);
                    _data.writeInt(userId);
                    _data.writeBoolean(enabled);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IContentSuggestionsManager {
        @Override
        public void provideContextImage(int userId, int taskId, Bundle imageContextRequestExtras) throws RemoteException {
        }

        @Override
        public void provideContextBitmap(int userId, Bitmap bitmap, Bundle imageContextRequestExtras) throws RemoteException {
        }

        @Override
        public void suggestContentSelections(int userId, SelectionsRequest request, ISelectionsCallback callback) throws RemoteException {
        }

        @Override
        public void classifyContentSelections(int userId, ClassificationsRequest request, IClassificationsCallback callback) throws RemoteException {
        }

        @Override
        public void notifyInteraction(int userId, String requestId, Bundle interaction) throws RemoteException {
        }

        @Override
        public void isEnabled(int userId, IResultReceiver receiver) throws RemoteException {
        }

        @Override
        public void resetTemporaryService(int userId) throws RemoteException {
        }

        @Override
        public void setTemporaryService(int userId, String serviceName, int duration) throws RemoteException {
        }

        @Override
        public void setDefaultServiceEnabled(int userId, boolean enabled) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

