/*
 * Decompiled with CFR 0.152.
 */
package android.app.compat;

import android.annotation.NonNull;
import android.app.PropertyInvalidatedCache;
import android.app.compat.ChangeIdStateQuery;
import android.os.Binder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.ravenwood.annotation.RavenwoodKeepWholeClass;
import android.ravenwood.annotation.RavenwoodReplace;
import com.android.internal.compat.IPlatformCompat;

@RavenwoodKeepWholeClass
public class ChangeIdStateCache
extends PropertyInvalidatedCache<ChangeIdStateQuery, Boolean> {
    private static final String CACHE_MODULE = "system_server";
    private static final String CACHE_API = "is_compat_change_enabled";
    private static final int MAX_ENTRIES = 2048;
    private static boolean sDisabled = ChangeIdStateCache.getDefaultDisabled();
    private volatile IPlatformCompat mPlatformCompat;

    @RavenwoodReplace
    private static boolean getDefaultDisabled() {
        return false;
    }

    private static boolean getDefaultDisabled$ravenwood() {
        return true;
    }

    public ChangeIdStateCache() {
        super(new PropertyInvalidatedCache.Args(CACHE_MODULE).maxEntries(2048).isolateUids(false).cacheNulls(false).api(CACHE_API), CACHE_API, null);
    }

    public static void disable() {
        sDisabled = true;
    }

    public static void invalidate() {
        if (!sDisabled) {
            PropertyInvalidatedCache.invalidateCache(CACHE_MODULE, CACHE_API);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    IPlatformCompat getPlatformCompatService() {
        IPlatformCompat platformCompat = this.mPlatformCompat;
        if (platformCompat == null) {
            ChangeIdStateCache changeIdStateCache = this;
            synchronized (changeIdStateCache) {
                platformCompat = this.mPlatformCompat;
                if (platformCompat == null) {
                    platformCompat = IPlatformCompat.Stub.asInterface(ServiceManager.getService("platform_compat"));
                    if (platformCompat == null) {
                        throw new RuntimeException("Could not get PlatformCompatService instance!");
                    }
                    this.mPlatformCompat = platformCompat;
                }
            }
        }
        return platformCompat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean recompute(ChangeIdStateQuery query) {
        long token;
        block7: {
            block6: {
                token = Binder.clearCallingIdentity();
                if (query.type != 0) break block6;
                Boolean bl = this.getPlatformCompatService().isChangeEnabledByPackageName(query.changeId, query.packageName, query.userId);
                Binder.restoreCallingIdentity(token);
                return bl;
            }
            if (query.type != 1) break block7;
            Boolean bl = this.getPlatformCompatService().isChangeEnabledByUid(query.changeId, query.uid);
            Binder.restoreCallingIdentity(token);
            return bl;
        }
        try {
            try {
                throw new IllegalArgumentException("Invalid query type: " + query.type);
            }
            catch (RemoteException e) {
                e.rethrowFromSystemServer();
                Binder.restoreCallingIdentity(token);
            }
        }
        catch (Throwable throwable) {
            Binder.restoreCallingIdentity(token);
            throw throwable;
        }
        throw new IllegalStateException("Could not recompute value!");
    }
}

