/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.util;

import android.app.appsearch.AppSearchSchema;
import android.app.appsearch.InternalSetSchemaResponse;
import android.app.appsearch.Migrator;
import android.app.appsearch.SetSchemaResponse;
import android.app.appsearch.exceptions.AppSearchException;
import android.util.ArrayMap;
import android.util.ArraySet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.NonNull;

public class SchemaMigrationUtil {
    private SchemaMigrationUtil() {
    }

    public static @NonNull Map<String, Migrator> getActiveMigrators(@NonNull Set<AppSearchSchema> existingSchemas, @NonNull Map<String, Migrator> migrators, int currentVersion, int finalVersion) {
        if (currentVersion == finalVersion) {
            return Collections.emptyMap();
        }
        ArraySet<String> existingTypes = new ArraySet<String>(existingSchemas.size());
        for (AppSearchSchema schema : existingSchemas) {
            existingTypes.add(schema.getSchemaType());
        }
        ArrayMap<String, Migrator> activeMigrators = new ArrayMap<String, Migrator>();
        for (Map.Entry<String, Migrator> entry : migrators.entrySet()) {
            String schemaType = entry.getKey();
            Migrator migrator = entry.getValue();
            if (!existingTypes.contains(schemaType) || !migrator.shouldMigrate(currentVersion, finalVersion)) continue;
            activeMigrators.put(schemaType, migrator);
        }
        return activeMigrators;
    }

    public static void checkDeletedAndIncompatibleAfterMigration(@NonNull InternalSetSchemaResponse internalSetSchemaResponse, @NonNull Set<String> activeMigrators) throws AppSearchException {
        if (internalSetSchemaResponse.isSuccess()) {
            return;
        }
        SetSchemaResponse setSchemaResponse = internalSetSchemaResponse.getSetSchemaResponse();
        ArraySet<String> unmigratedIncompatibleTypes = new ArraySet<String>(setSchemaResponse.getIncompatibleTypes());
        unmigratedIncompatibleTypes.removeAll(activeMigrators);
        ArraySet<String> unmigratedDeletedTypes = new ArraySet<String>(setSchemaResponse.getDeletedTypes());
        unmigratedDeletedTypes.removeAll(activeMigrators);
        if (!unmigratedIncompatibleTypes.isEmpty() || !unmigratedDeletedTypes.isEmpty()) {
            throw new AppSearchException(7, internalSetSchemaResponse.getErrorMessage());
        }
    }
}

