/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.aidl;

import android.annotation.NonNull;
import android.app.appsearch.AppSearchBlobHandle;
import android.app.appsearch.aidl.AppSearchAttributionSource;
import android.app.appsearch.aidl.OpenBlobForWriteAidlRequestCreator;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.UserHandle;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SafeParcelable.Class(creator="OpenBlobForWriteAidlRequestCreator")
public class OpenBlobForWriteAidlRequest
extends AbstractSafeParcelable {
    @NonNull
    public static final Parcelable.Creator<OpenBlobForWriteAidlRequest> CREATOR = new OpenBlobForWriteAidlRequestCreator();
    @NonNull
    @SafeParcelable.Field(id=1, getter="getCallerAttributionSource")
    private final AppSearchAttributionSource mCallerAttributionSource;
    @NonNull
    @SafeParcelable.Field(id=2, getter="getCallingDatabaseName")
    private final String mCallingDatabaseName;
    @NonNull
    @SafeParcelable.Field(id=3, getter="getBlobHandles")
    private final List<AppSearchBlobHandle> mBlobHandles;
    @NonNull
    @SafeParcelable.Field(id=4, getter="getUserHandle")
    private final UserHandle mUserHandle;
    @SafeParcelable.Field(id=5, getter="getBinderCallStartTimeMillis")
    private final long mBinderCallStartTimeMillis;

    @SafeParcelable.Constructor
    public OpenBlobForWriteAidlRequest(@SafeParcelable.Param(id=1) @NonNull AppSearchAttributionSource callerAttributionSource, @SafeParcelable.Param(id=2) @NonNull String callingDatabaseName, @SafeParcelable.Param(id=3) @NonNull List<AppSearchBlobHandle> blobHandles, @SafeParcelable.Param(id=4) @NonNull UserHandle userHandle, @SafeParcelable.Param(id=5) long binderCallStartTimeMillis) {
        this.mCallerAttributionSource = Objects.requireNonNull(callerAttributionSource);
        this.mCallingDatabaseName = Objects.requireNonNull(callingDatabaseName);
        this.mBlobHandles = Objects.requireNonNull(blobHandles);
        this.mUserHandle = Objects.requireNonNull(userHandle);
        this.mBinderCallStartTimeMillis = binderCallStartTimeMillis;
    }

    @NonNull
    public AppSearchAttributionSource getCallerAttributionSource() {
        return this.mCallerAttributionSource;
    }

    @NonNull
    public String getCallingDatabaseName() {
        return this.mCallingDatabaseName;
    }

    @NonNull
    public List<AppSearchBlobHandle> getBlobHandles() {
        return Collections.unmodifiableList(this.mBlobHandles);
    }

    @NonNull
    public UserHandle getUserHandle() {
        return this.mUserHandle;
    }

    public long getBinderCallStartTimeMillis() {
        return this.mBinderCallStartTimeMillis;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        OpenBlobForWriteAidlRequestCreator.writeToParcel(this, dest, flags);
    }
}

