/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch.aidl;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.appsearch.AppSearchBatchResult;
import android.app.appsearch.AppSearchBlobHandle;
import android.app.appsearch.AppSearchResult;
import android.app.appsearch.ParcelableUtil;
import android.app.appsearch.aidl.AppSearchBatchResultParcelV2Creator;
import android.app.appsearch.aidl.AppSearchResultParcelV2;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import java.util.Map;
import java.util.Objects;

@SafeParcelable.Class(creator="AppSearchBatchResultParcelV2Creator", creatorIsFinal=false)
public class AppSearchBatchResultParcelV2<KeyType, ValueType>
extends AbstractSafeParcelable {
    private static final String TAG = "AppSearchBatchResultPar";
    @NonNull
    public static final Parcelable.Creator<AppSearchBatchResultParcelV2> CREATOR = new AppSearchBatchResultParcelV2Creator(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AppSearchBatchResultParcelV2 createFromParcel(Parcel in) {
            int writeParcelModel = in.readInt();
            switch (writeParcelModel) {
                case 1: {
                    byte[] dataBlob = Objects.requireNonNull(ParcelableUtil.readBlob(in));
                    Parcel unmarshallParcel = Parcel.obtain();
                    try {
                        unmarshallParcel.unmarshall(dataBlob, 0, dataBlob.length);
                        unmarshallParcel.setDataPosition(0);
                        AppSearchBatchResultParcelV2<?, ?> appSearchBatchResultParcelV2 = AppSearchBatchResultParcelV2.directlyReadFromParcel(unmarshallParcel);
                        return appSearchBatchResultParcelV2;
                    }
                    finally {
                        unmarshallParcel.recycle();
                    }
                }
                case 2: {
                    return AppSearchBatchResultParcelV2.directlyReadFromParcel(in);
                }
            }
            throw new UnsupportedOperationException("Cannot write AppSearchBatchResultParcelV2 to Parcel with unknown model: " + writeParcelModel);
        }
    };
    @NonNull
    private static final Parcelable.Creator<AppSearchBatchResultParcelV2> CREATOR_WITHOUT_BLOB = new AppSearchBatchResultParcelV2Creator();
    @SafeParcelable.Field(id=1)
    int mWriteParcelModel;
    @SafeParcelable.Field(id=2)
    @NonNull
    final String mKeyClassName;
    @SafeParcelable.Field(id=3)
    @NonNull
    final Bundle mKeyBundle;
    @SafeParcelable.Field(id=4)
    @NonNull
    final Bundle mAppSearchResultValueBundle;
    @Nullable
    private AppSearchBatchResult<KeyType, ValueType> mResultCached;

    static AppSearchBatchResultParcelV2<?, ?> directlyReadFromParcel(@NonNull Parcel data) {
        return CREATOR_WITHOUT_BLOB.createFromParcel(data);
    }

    static void directlyWriteToParcel(@NonNull AppSearchBatchResultParcelV2<?, ?> result, @NonNull Parcel data, int flags) {
        AppSearchBatchResultParcelV2Creator.writeToParcel(result, data, flags);
    }

    @SafeParcelable.Constructor
    AppSearchBatchResultParcelV2(@SafeParcelable.Param(id=1) int writeParcelModel, @SafeParcelable.Param(id=2) String keyClassName, @SafeParcelable.Param(id=3) Bundle keyBundle, @SafeParcelable.Param(id=4) Bundle appSearchResultValueBundle) {
        this.mWriteParcelModel = writeParcelModel;
        this.mKeyClassName = keyClassName;
        this.mKeyBundle = keyBundle;
        this.mAppSearchResultValueBundle = appSearchResultValueBundle;
        ClassLoader classLoader = AppSearchResultParcelV2.class.getClassLoader();
        this.mKeyBundle.setClassLoader(classLoader);
        this.mAppSearchResultValueBundle.setClassLoader(classLoader);
    }

    @NonNull
    @FlaggedApi(value="com.android.appsearch.flags.enable_blob_store")
    public static AppSearchBatchResultParcelV2<AppSearchBlobHandle, ParcelFileDescriptor> fromBlobHandleToPfd(@NonNull AppSearchBatchResult<AppSearchBlobHandle, ParcelFileDescriptor> result) {
        Bundle keyAppSearchResultBundle = new Bundle();
        Bundle valueAppSearchResultBundle = new Bundle();
        int i = 0;
        for (Map.Entry<AppSearchBlobHandle, AppSearchResult<ParcelFileDescriptor>> entry : result.getAll().entrySet()) {
            AppSearchResultParcelV2<ParcelFileDescriptor> valueAppSearchBinderResultParcel = entry.getValue().isSuccess() ? AppSearchResultParcelV2.fromParcelFileDescriptor(entry.getValue().getResultValue()) : AppSearchResultParcelV2.fromFailedResult(entry.getValue());
            keyAppSearchResultBundle.putParcelable(String.valueOf(i), entry.getKey());
            valueAppSearchResultBundle.putParcelable(String.valueOf(i), valueAppSearchBinderResultParcel);
            ++i;
        }
        return new AppSearchBatchResultParcelV2<AppSearchBlobHandle, ParcelFileDescriptor>(2, AppSearchBlobHandle.class.getName(), keyAppSearchResultBundle, valueAppSearchResultBundle);
    }

    @NonNull
    @FlaggedApi(value="com.android.appsearch.flags.enable_blob_store")
    public static AppSearchBatchResultParcelV2<AppSearchBlobHandle, Void> fromBlobHandleToVoid(@NonNull AppSearchBatchResult<AppSearchBlobHandle, Void> result) {
        Bundle keyAppSearchResultBundle = new Bundle();
        Bundle valueAppSearchResultBundle = new Bundle();
        int i = 0;
        for (Map.Entry<AppSearchBlobHandle, AppSearchResult<Void>> entry : result.getAll().entrySet()) {
            AppSearchResultParcelV2 valueAppSearchResultParcel = entry.getValue().isSuccess() ? AppSearchResultParcelV2.fromVoid() : AppSearchResultParcelV2.fromFailedResult(entry.getValue());
            keyAppSearchResultBundle.putParcelable(String.valueOf(i), entry.getKey());
            valueAppSearchResultBundle.putParcelable(String.valueOf(i), valueAppSearchResultParcel);
            ++i;
        }
        return new AppSearchBatchResultParcelV2<AppSearchBlobHandle, Void>(1, AppSearchBlobHandle.class.getName(), keyAppSearchResultBundle, valueAppSearchResultBundle);
    }

    @NonNull
    public AppSearchBatchResult<KeyType, ValueType> getResult() {
        if (this.mResultCached == null) {
            AppSearchBatchResult.Builder builder = new AppSearchBatchResult.Builder();
            for (String key : this.mKeyBundle.keySet()) {
                Object keyType = this.mKeyBundle.getParcelable(key);
                AppSearchResultParcelV2 valueTypeResult = (AppSearchResultParcelV2)this.mAppSearchResultValueBundle.getParcelable(key);
                if (keyType == null) {
                    throw new IllegalArgumentException("AppSearchResultParcelV2's key type doesn't match.");
                }
                if (valueTypeResult == null) {
                    builder.setResult(keyType, AppSearchResult.newFailedResult(2, "Cannot read value parcelable from bundle."));
                    continue;
                }
                builder.setResult(keyType, valueTypeResult.getResult());
            }
            this.mResultCached = builder.build();
        }
        return this.mResultCached;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mWriteParcelModel);
        switch (this.mWriteParcelModel) {
            case 1: {
                byte[] bytes;
                Parcel data = Parcel.obtain();
                try {
                    AppSearchBatchResultParcelV2.directlyWriteToParcel(this, data, flags);
                    bytes = data.marshall();
                }
                finally {
                    data.recycle();
                }
                ParcelableUtil.writeBlob(dest, bytes);
                break;
            }
            case 2: {
                AppSearchBatchResultParcelV2.directlyWriteToParcel(this, dest, flags);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot read AppSearchBatchResultParcelV2 from Parcel with unknown model: " + this.mWriteParcelModel);
            }
        }
    }
}

