/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.appsearch.AppSearchResult;
import android.app.appsearch.MigrationFailureCreator;
import android.app.appsearch.SetSchemaResponseCreator;
import android.app.appsearch.annotation.CanIgnoreReturnValue;
import android.app.appsearch.internal.util.Preconditions;
import android.app.appsearch.safeparcel.AbstractSafeParcelable;
import android.app.appsearch.safeparcel.SafeParcelable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@SafeParcelable.Class(creator="SetSchemaResponseCreator")
public class SetSchemaResponse
extends AbstractSafeParcelable {
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    @NonNull
    public static final Parcelable.Creator<SetSchemaResponse> CREATOR = new SetSchemaResponseCreator();
    @SafeParcelable.Field(id=1)
    final List<String> mDeletedTypes;
    @SafeParcelable.Field(id=2)
    final List<String> mIncompatibleTypes;
    @SafeParcelable.Field(id=3)
    final List<String> mMigratedTypes;
    private final List<MigrationFailure> mMigrationFailures;
    @Nullable
    private Set<String> mDeletedTypesCached;
    @Nullable
    private Set<String> mMigratedTypesCached;
    @Nullable
    private Set<String> mIncompatibleTypesCached;

    @SafeParcelable.Constructor
    SetSchemaResponse(@SafeParcelable.Param(id=1) @NonNull List<String> deletedTypes, @SafeParcelable.Param(id=2) @NonNull List<String> incompatibleTypes, @SafeParcelable.Param(id=3) @NonNull List<String> migratedTypes) {
        this.mDeletedTypes = deletedTypes;
        this.mIncompatibleTypes = incompatibleTypes;
        this.mMigratedTypes = migratedTypes;
        this.mMigrationFailures = Collections.emptyList();
    }

    SetSchemaResponse(@NonNull List<String> deletedTypes, @NonNull List<String> incompatibleTypes, @NonNull List<String> migratedTypes, @NonNull List<MigrationFailure> migrationFailures) {
        this.mDeletedTypes = deletedTypes;
        this.mIncompatibleTypes = incompatibleTypes;
        this.mMigratedTypes = migratedTypes;
        this.mMigrationFailures = Objects.requireNonNull(migrationFailures);
    }

    @NonNull
    public List<MigrationFailure> getMigrationFailures() {
        return Collections.unmodifiableList(this.mMigrationFailures);
    }

    @NonNull
    public Set<String> getDeletedTypes() {
        if (this.mDeletedTypesCached == null) {
            this.mDeletedTypesCached = new ArraySet<String>((Collection)Objects.requireNonNull(this.mDeletedTypes));
        }
        return Collections.unmodifiableSet(this.mDeletedTypesCached);
    }

    @NonNull
    public Set<String> getMigratedTypes() {
        if (this.mMigratedTypesCached == null) {
            this.mMigratedTypesCached = new ArraySet<String>((Collection)Objects.requireNonNull(this.mMigratedTypes));
        }
        return Collections.unmodifiableSet(this.mMigratedTypesCached);
    }

    @NonNull
    public Set<String> getIncompatibleTypes() {
        if (this.mIncompatibleTypesCached == null) {
            this.mIncompatibleTypesCached = new ArraySet<String>((Collection)Objects.requireNonNull(this.mIncompatibleTypes));
        }
        return Collections.unmodifiableSet(this.mIncompatibleTypesCached);
    }

    @Override
    @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        SetSchemaResponseCreator.writeToParcel(this, dest, flags);
    }

    @SafeParcelable.Class(creator="MigrationFailureCreator")
    public static class MigrationFailure
    extends AbstractSafeParcelable {
        @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
        @NonNull
        public static final Parcelable.Creator<MigrationFailure> CREATOR = new MigrationFailureCreator();
        @SafeParcelable.Field(id=1, getter="getNamespace")
        private final String mNamespace;
        @SafeParcelable.Field(id=2, getter="getDocumentId")
        private final String mDocumentId;
        @SafeParcelable.Field(id=3, getter="getSchemaType")
        private final String mSchemaType;
        @SafeParcelable.Field(id=4)
        @Nullable
        final String mErrorMessage;
        @SafeParcelable.Field(id=5)
        final int mResultCode;

        @SafeParcelable.Constructor
        MigrationFailure(@SafeParcelable.Param(id=1) @NonNull String namespace, @SafeParcelable.Param(id=2) @NonNull String documentId, @SafeParcelable.Param(id=3) @NonNull String schemaType, @SafeParcelable.Param(id=4) @Nullable String errorMessage, @SafeParcelable.Param(id=5) int resultCode) {
            this.mNamespace = namespace;
            this.mDocumentId = documentId;
            this.mSchemaType = schemaType;
            this.mErrorMessage = errorMessage;
            this.mResultCode = resultCode;
        }

        public MigrationFailure(@NonNull String namespace, @NonNull String documentId, @NonNull String schemaType, @NonNull AppSearchResult<?> failedResult) {
            this.mNamespace = namespace;
            this.mDocumentId = documentId;
            this.mSchemaType = schemaType;
            Objects.requireNonNull(failedResult);
            Preconditions.checkArgument(!failedResult.isSuccess(), "failedResult was actually successful");
            this.mErrorMessage = failedResult.getErrorMessage();
            this.mResultCode = failedResult.getResultCode();
        }

        @NonNull
        public String getNamespace() {
            return this.mNamespace;
        }

        @NonNull
        public String getDocumentId() {
            return this.mDocumentId;
        }

        @NonNull
        public String getSchemaType() {
            return this.mSchemaType;
        }

        @NonNull
        public AppSearchResult<Void> getAppSearchResult() {
            return AppSearchResult.newFailedResult(this.mResultCode, this.mErrorMessage);
        }

        @NonNull
        public String toString() {
            return "MigrationFailure { schemaType: " + this.getSchemaType() + ", namespace: " + this.getNamespace() + ", documentId: " + this.getDocumentId() + ", appSearchResult: " + this.getAppSearchResult().toString() + "}";
        }

        @Override
        @FlaggedApi(value="com.android.appsearch.flags.enable_safe_parcelable_2")
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            MigrationFailureCreator.writeToParcel(this, dest, flags);
        }
    }

    public static class Builder {
        private List<MigrationFailure> mMigrationFailures = new ArrayList<MigrationFailure>();
        private ArrayList<String> mDeletedTypes = new ArrayList();
        private ArrayList<String> mMigratedTypes = new ArrayList();
        private ArrayList<String> mIncompatibleTypes = new ArrayList();
        private boolean mBuilt = false;

        public Builder(@NonNull SetSchemaResponse setSchemaResponse) {
            Objects.requireNonNull(setSchemaResponse);
            this.mDeletedTypes.addAll(setSchemaResponse.getDeletedTypes());
            this.mIncompatibleTypes.addAll(setSchemaResponse.getIncompatibleTypes());
            this.mMigratedTypes.addAll(setSchemaResponse.getMigratedTypes());
            this.mMigrationFailures.addAll(setSchemaResponse.getMigrationFailures());
        }

        public Builder() {
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addMigrationFailures(@NonNull Collection<MigrationFailure> migrationFailures) {
            Objects.requireNonNull(migrationFailures);
            this.resetIfBuilt();
            this.mMigrationFailures.addAll(migrationFailures);
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addMigrationFailure(@NonNull MigrationFailure migrationFailure) {
            Objects.requireNonNull(migrationFailure);
            this.resetIfBuilt();
            this.mMigrationFailures.add(migrationFailure);
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addDeletedTypes(@NonNull Collection<String> deletedTypes) {
            Objects.requireNonNull(deletedTypes);
            this.resetIfBuilt();
            this.mDeletedTypes.addAll(deletedTypes);
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addDeletedType(@NonNull String deletedType) {
            Objects.requireNonNull(deletedType);
            this.resetIfBuilt();
            this.mDeletedTypes.add(deletedType);
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addIncompatibleTypes(@NonNull Collection<String> incompatibleTypes) {
            Objects.requireNonNull(incompatibleTypes);
            this.resetIfBuilt();
            this.mIncompatibleTypes.addAll(incompatibleTypes);
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addIncompatibleType(@NonNull String incompatibleType) {
            Objects.requireNonNull(incompatibleType);
            this.resetIfBuilt();
            this.mIncompatibleTypes.add(incompatibleType);
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addMigratedTypes(@NonNull Collection<String> migratedTypes) {
            Objects.requireNonNull(migratedTypes);
            this.resetIfBuilt();
            this.mMigratedTypes.addAll(migratedTypes);
            return this;
        }

        @CanIgnoreReturnValue
        @NonNull
        public Builder addMigratedType(@NonNull String migratedType) {
            Objects.requireNonNull(migratedType);
            this.resetIfBuilt();
            this.mMigratedTypes.add(migratedType);
            return this;
        }

        @NonNull
        public SetSchemaResponse build() {
            this.mBuilt = true;
            return new SetSchemaResponse(this.mDeletedTypes, this.mIncompatibleTypes, this.mMigratedTypes, this.mMigrationFailures);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mMigrationFailures = new ArrayList<MigrationFailure>(this.mMigrationFailures);
                this.mDeletedTypes = new ArrayList<String>(this.mDeletedTypes);
                this.mMigratedTypes = new ArrayList<String>(this.mMigratedTypes);
                this.mIncompatibleTypes = new ArrayList<String>(this.mIncompatibleTypes);
                this.mBuilt = false;
            }
        }
    }
}

